/*
 * Decompiled with CFR 0.152.
 */
package tim.sql.h2parser;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.List;
import tim.sql.h2parser.Message;
import tim.sql.h2parser.SysProperties;
import tim.sql.h2parser.value.Value;
import tim.sql.h2parser.value.ValueDecimal;
import tim.sql.h2parser.value.ValueInt;
import tim.sql.h2parser.value.ValueString;

public class Lexer {
    protected static final int CHAR_END = -1;
    protected static final int CHAR_VALUE = 2;
    protected static final int CHAR_QUOTED = 3;
    protected static final int CHAR_NAME = 4;
    protected static final int CHAR_SPECIAL_1 = 5;
    protected static final int CHAR_SPECIAL_2 = 6;
    protected static final int CHAR_STRING = 7;
    protected static final int CHAR_DECIMAL = 8;
    protected static final int CHAR_DOLLAR_QUOTED_STRING = 9;
    protected static final int KEYWORD = 1;
    protected static final int IDENTIFIER = 2;
    protected static final int PARAMETER = 3;
    protected static final int END = 4;
    protected static final int VALUE = 5;
    protected static final int EQUAL = 6;
    protected static final int BIGGER_EQUAL = 7;
    protected static final int BIGGER = 8;
    protected static final int SMALLER = 9;
    protected static final int SMALLER_EQUAL = 10;
    protected static final int NOT_EQUAL = 11;
    protected static final int AT = 12;
    protected static final int MINUS = 17;
    protected static final int PLUS = 18;
    protected static final int STRING_CONCAT = 22;
    protected static final int OPEN = 31;
    protected static final int CLOSE = 32;
    protected static final int NULL = 34;
    protected static final int TRUE = 40;
    protected static final int FALSE = 41;
    protected static final int CURRENT_TIMESTAMP = 42;
    protected static final int CURRENT_DATE = 43;
    protected static final int CURRENT_TIME = 44;
    protected static final int ROWNUM = 45;
    protected int[] characterTypes;
    protected int currentTokenType;
    protected String currentToken;
    protected boolean currentTokenQuoted;
    protected Value currentValue;
    protected String sqlCommand;
    protected String originalSQL;
    protected char[] sqlCommandChars;
    protected int lastParseIndex;
    protected int parseIndex;
    protected List expectedList;
    boolean squareBracketQuotedNames = false;
    int allowLiterals = 2;
    boolean supportOffsetFetch = true;

    protected void initialize(String sql) throws SQLException {
        if (sql == null) {
            sql = "";
        }
        this.originalSQL = sql;
        this.sqlCommand = sql;
        int len = sql.length() + 1;
        char[] command = new char[len];
        int[] types = new int[len];
        sql.getChars(0, --len, command, 0);
        boolean changed = false;
        command[len] = 32;
        int startLoop = 0;
        int lastType = 0;
        for (int i = 0; i < len; ++i) {
            char c = command[i];
            int type = 0;
            switch (c) {
                case '/': {
                    if (command[i + 1] == '*') {
                        changed = true;
                        command[i] = 32;
                        command[i + 1] = 32;
                        startLoop = i;
                        this.checkRunOver(i += 2, len, startLoop);
                        while (command[i] != '*' || command[i + 1] != '/') {
                            command[i++] = 32;
                            this.checkRunOver(i, len, startLoop);
                        }
                        command[i] = 32;
                        command[i + 1] = 32;
                        ++i;
                        break;
                    }
                    if (command[i + 1] == '/') {
                        changed = true;
                        startLoop = i;
                        while ((c = command[i]) != '\n' && c != '\r' && i < len - 1) {
                            command[i++] = 32;
                            this.checkRunOver(i, len, startLoop);
                        }
                        break;
                    }
                    type = 5;
                    break;
                }
                case '-': {
                    if (command[i + 1] == '-') {
                        changed = true;
                        startLoop = i;
                        while ((c = command[i]) != '\n' && c != '\r' && i < len - 1) {
                            command[i++] = 32;
                            this.checkRunOver(i, len, startLoop);
                        }
                        break;
                    }
                    type = 5;
                    break;
                }
                case '$': {
                    if (SysProperties.DOLLAR_QUOTING && command[i + 1] == '$' && (i == 0 || command[i - 1] <= ' ')) {
                        changed = true;
                        command[i] = 32;
                        command[i + 1] = 32;
                        startLoop = i;
                        this.checkRunOver(i += 2, len, startLoop);
                        while (command[i] != '$' || command[i + 1] != '$') {
                            types[i++] = 9;
                            this.checkRunOver(i, len, startLoop);
                        }
                        command[i] = 32;
                        command[i + 1] = 32;
                        ++i;
                        break;
                    }
                    if (lastType == 4) {
                        type = 4;
                        break;
                    }
                    type = 5;
                    break;
                }
                case '%': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case ';': 
                case '?': 
                case '@': 
                case ']': 
                case '{': 
                case '}': {
                    type = 5;
                    break;
                }
                case '!': 
                case ':': 
                case '<': 
                case '=': 
                case '>': 
                case '|': 
                case '~': {
                    type = 6;
                    break;
                }
                case '.': {
                    type = 8;
                    break;
                }
                case '\'': {
                    types[i] = 7;
                    type = 7;
                    startLoop = i;
                    while (command[++i] != '\'') {
                        this.checkRunOver(i, len, startLoop);
                    }
                    break;
                }
                case '[': {
                    if (this.squareBracketQuotedNames) {
                        command[i] = 34;
                        changed = true;
                        types[i] = 3;
                        type = 3;
                        startLoop = i;
                        while (command[++i] != ']') {
                            this.checkRunOver(i, len, startLoop);
                        }
                        command[i] = 34;
                        break;
                    }
                    type = 5;
                    break;
                }
                case '`': {
                    command[i] = 34;
                    changed = true;
                    types[i] = 3;
                    type = 3;
                    startLoop = i;
                    while (command[++i] != '`') {
                        this.checkRunOver(i, len, startLoop);
                        c = command[i];
                        command[i] = Character.toUpperCase(c);
                    }
                    command[i] = 34;
                    break;
                }
                case '\"': {
                    types[i] = 3;
                    type = 3;
                    startLoop = i;
                    while (command[++i] != '\"') {
                        this.checkRunOver(i, len, startLoop);
                    }
                    break;
                }
                case '_': {
                    type = 4;
                    break;
                }
                default: {
                    if (c >= 'a' && c <= 'z') {
                        command[i] = (char)(c - 32);
                        changed = true;
                        type = 4;
                        break;
                    }
                    if (c >= 'A' && c <= 'Z') {
                        type = 4;
                        break;
                    }
                    if (c >= '0' && c <= '9') {
                        type = 2;
                        break;
                    }
                    if (!Character.isJavaIdentifierPart(c)) break;
                    type = 4;
                    char u = Character.toUpperCase(c);
                    if (u == c) break;
                    command[i] = u;
                    changed = true;
                }
            }
            types[i] = (byte)type;
            lastType = type;
        }
        this.sqlCommandChars = command;
        types[len] = -1;
        this.characterTypes = types;
        if (changed) {
            this.sqlCommand = new String(command);
        }
        this.parseIndex = 0;
    }

    protected SQLException getUnsupportedError() {
        if (this.expectedList == null || this.expectedList.size() == 0) {
            return Message.getUnsupportedError(this.sqlCommand, this.parseIndex);
        }
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this.expectedList.size(); ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(this.expectedList.get(i));
        }
        return Message.getUnsupportedError(this.sqlCommand, this.parseIndex, buff.toString());
    }

    protected SQLException getSyntaxError() {
        if (this.expectedList == null || this.expectedList.size() == 0) {
            return Message.getSyntaxError(this.sqlCommand, this.parseIndex);
        }
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this.expectedList.size(); ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(this.expectedList.get(i));
        }
        return Message.getSyntaxError(this.sqlCommand, this.parseIndex, buff.toString());
    }

    protected void checkRunOver(int i, int len, int startLoop) throws SQLException {
        if (i >= len) {
            this.parseIndex = startLoop;
            throw this.getSyntaxError();
        }
    }

    protected void read(String expected) throws SQLException {
        if (!expected.equals(this.currentToken) || this.currentTokenQuoted) {
            throw Message.getSyntaxError(this.sqlCommand, this.parseIndex, expected);
        }
        this.read();
    }

    protected boolean readIf(String token) throws SQLException {
        if (token.equals(this.currentToken) && !this.currentTokenQuoted) {
            this.read();
            return true;
        }
        this.addExpected(token);
        return false;
    }

    protected boolean isToken(String token) {
        boolean result;
        boolean bl = result = token.equals(this.currentToken) && !this.currentTokenQuoted;
        if (result) {
            return true;
        }
        this.addExpected(token);
        return false;
    }

    protected void addExpected(String token) {
        if (this.expectedList != null) {
            this.expectedList.add(token);
        }
    }

    protected void read() throws SQLException {
        this.currentTokenQuoted = false;
        if (this.expectedList != null) {
            this.expectedList.clear();
        }
        int[] types = this.characterTypes;
        this.lastParseIndex = this.parseIndex;
        int i = this.parseIndex;
        int type = types[i];
        while (type == 0) {
            type = types[++i];
        }
        int start = i;
        char[] chars = this.sqlCommandChars;
        char c = chars[i++];
        this.currentToken = "";
        switch (type) {
            case 4: {
                while ((type = types[i]) == 4 || type == 2) {
                    ++i;
                }
                this.currentToken = this.sqlCommand.substring(start, i);
                this.currentTokenType = this.getTokenType(this.currentToken);
                this.parseIndex = i;
                return;
            }
            case 3: {
                String result = null;
                while (true) {
                    int begin = ++i;
                    while (true) {
                        if (chars[i] == '\"') {
                            if (result == null) {
                                result = this.sqlCommand.substring(begin, i);
                                break;
                            }
                            result = result + this.sqlCommand.substring(begin - 1, i);
                            break;
                        }
                        ++i;
                    }
                    if (chars[++i] != '\"') break;
                }
                this.currentToken = result;
                this.parseIndex = i;
                this.currentTokenQuoted = true;
                this.currentTokenType = 2;
                return;
            }
            case 6: {
                if (types[i] == 6) {
                    ++i;
                }
                this.currentToken = this.sqlCommand.substring(start, i);
                this.currentTokenType = this.getSpecialType(this.currentToken);
                this.parseIndex = i;
                return;
            }
            case 5: {
                this.currentToken = this.sqlCommand.substring(start, i);
                this.currentTokenType = this.getSpecialType(this.currentToken);
                this.parseIndex = i;
                return;
            }
            case 2: {
                if (c == '0' && chars[i] == 'X') {
                    long number = 0L;
                    start += 2;
                    ++i;
                    while (true) {
                        if (!((c = chars[i]) >= '0' && c <= '9' || c >= 'A' && c <= 'F')) {
                            this.checkLiterals(false);
                            this.currentValue = ValueInt.get((int)number);
                            this.currentTokenType = 5;
                            this.currentToken = "0";
                            this.parseIndex = i;
                            return;
                        }
                        if ((number = (number << 4) + (long)c - (long)(c >= 'A' ? 55 : 48)) > Integer.MAX_VALUE) {
                            this.readHexDecimal(start, i);
                            return;
                        }
                        ++i;
                    }
                }
                long number = c - 48;
                while (true) {
                    if ((c = chars[i]) < '0' || c > '9') {
                        if (c == '.') {
                            this.readDecimal(start, i);
                            break;
                        }
                        if (c == 'E') {
                            this.readDecimal(start, i);
                            break;
                        }
                        this.checkLiterals(false);
                        this.currentValue = ValueInt.get((int)number);
                        this.currentTokenType = 5;
                        this.currentToken = "0";
                        this.parseIndex = i;
                        break;
                    }
                    if ((number = number * 10L + (long)(c - 48)) > Integer.MAX_VALUE) {
                        this.readDecimal(start, i);
                        break;
                    }
                    ++i;
                }
                return;
            }
            case 8: {
                if (types[i] != 2) {
                    this.currentTokenType = 1;
                    this.currentToken = ".";
                    this.parseIndex = i;
                    return;
                }
                this.readDecimal(i - 1, i);
                return;
            }
            case 7: {
                String result = null;
                while (true) {
                    int begin = ++i;
                    while (true) {
                        if (chars[i] == '\'') {
                            if (result == null) {
                                result = this.sqlCommand.substring(begin, i);
                                break;
                            }
                            result = result + this.sqlCommand.substring(begin - 1, i);
                            break;
                        }
                        ++i;
                    }
                    if (chars[++i] != '\'') break;
                }
                this.currentToken = "'";
                this.checkLiterals(true);
                this.currentValue = ValueString.get(result);
                this.parseIndex = i;
                this.currentTokenType = 5;
                return;
            }
            case 9: {
                String result = null;
                int begin = i - 1;
                while (types[i] == 9) {
                    ++i;
                }
                result = this.sqlCommand.substring(begin, i);
                this.currentToken = "'";
                this.checkLiterals(true);
                this.currentValue = ValueString.get(result);
                this.parseIndex = i;
                this.currentTokenType = 5;
                return;
            }
            case -1: {
                this.currentToken = "";
                this.currentTokenType = 4;
                this.parseIndex = i;
                return;
            }
        }
        throw this.getSyntaxError();
    }

    protected void checkLiterals(boolean text) throws SQLException {
        int allowed = this.allowLiterals;
        if (allowed == 0 || text && allowed != 2) {
            throw Message.getSQLException("LITERALS_ARE_NOT_ALLOWED");
        }
    }

    protected void readHexDecimal(int start, int i) throws SQLException {
        char c;
        char[] chars = this.sqlCommandChars;
        while ((c = chars[++i]) >= '0' && c <= '9' || c >= 'A' && c <= 'F') {
        }
        this.parseIndex = i;
        String sub = this.sqlCommand.substring(start, i);
        BigDecimal bd = new BigDecimal(new BigInteger(sub, 16));
        this.checkLiterals(false);
        this.currentValue = ValueDecimal.get(bd);
        this.currentTokenType = 5;
    }

    protected void readDecimal(int start, int i) throws SQLException {
        BigDecimal bd;
        int t;
        char[] chars = this.sqlCommandChars;
        int[] types = this.characterTypes;
        while ((t = types[i]) == 8 || t == 2) {
            ++i;
        }
        if (chars[i] == 'E') {
            if (chars[++i] == '+' || chars[i] == '-') {
                ++i;
            }
            if (types[i] != 2) {
                throw this.getSyntaxError();
            }
            while (types[++i] == 2) {
            }
        }
        this.parseIndex = i;
        String sub = this.sqlCommand.substring(start, i);
        try {
            bd = new BigDecimal(sub);
        }
        catch (NumberFormatException e) {
            throw Message.getSQLException("DATA_CONVERSION_ERROR_1", sub, (Throwable)e);
        }
        this.checkLiterals(false);
        this.currentValue = ValueDecimal.get(bd);
        this.currentTokenType = 5;
    }

    protected int getSpecialType(String s) throws SQLException {
        char c0 = s.charAt(0);
        if (s.length() == 1) {
            switch (c0) {
                case '$': 
                case '?': {
                    return 3;
                }
                case '@': {
                    return 12;
                }
                case '+': {
                    return 18;
                }
                case '-': {
                    return 17;
                }
                case '*': 
                case ',': 
                case '/': 
                case ':': 
                case ';': 
                case '[': 
                case ']': 
                case '{': 
                case '}': 
                case '~': {
                    return 1;
                }
                case '(': {
                    return 31;
                }
                case ')': {
                    return 32;
                }
                case '<': {
                    return 9;
                }
                case '>': {
                    return 8;
                }
                case '=': {
                    return 6;
                }
            }
        } else if (s.length() == 2) {
            switch (c0) {
                case ':': {
                    if (!"::".equals(s)) break;
                    return 1;
                }
                case '>': {
                    if (!">=".equals(s)) break;
                    return 7;
                }
                case '<': {
                    if ("<=".equals(s)) {
                        return 10;
                    }
                    if (!"<>".equals(s)) break;
                    return 11;
                }
                case '!': {
                    if ("!=".equals(s)) {
                        return 11;
                    }
                    if (!"!~".equals(s)) break;
                    return 1;
                }
                case '|': {
                    if (!"||".equals(s)) break;
                    return 22;
                }
            }
        }
        throw this.getSyntaxError();
    }

    protected int getTokenType(String s) throws SQLException {
        int len = s.length();
        if (len == 0) {
            throw this.getSyntaxError();
        }
        return Lexer.getSaveTokenType(s, this.supportOffsetFetch);
    }

    protected static int getSaveTokenType(String s, boolean supportOffsetFetch) {
        switch (s.charAt(0)) {
            case 'C': {
                if (s.equals("CURRENT_TIMESTAMP")) {
                    return 42;
                }
                if (s.equals("CURRENT_TIME")) {
                    return 44;
                }
                if (s.equals("CURRENT_DATE")) {
                    return 43;
                }
                return Lexer.getKeywordOrIdentifier(s, "CROSS", 1);
            }
            case 'D': {
                return Lexer.getKeywordOrIdentifier(s, "DISTINCT", 1);
            }
            case 'E': {
                if ("EXCEPT".equals(s)) {
                    return 1;
                }
                return Lexer.getKeywordOrIdentifier(s, "EXISTS", 1);
            }
            case 'F': {
                if ("FROM".equals(s)) {
                    return 1;
                }
                if ("FOR".equals(s)) {
                    return 1;
                }
                if ("FULL".equals(s)) {
                    return 1;
                }
                if (supportOffsetFetch && "FETCH".equals(s)) {
                    return 1;
                }
                return Lexer.getKeywordOrIdentifier(s, "FALSE", 41);
            }
            case 'G': {
                return Lexer.getKeywordOrIdentifier(s, "GROUP", 1);
            }
            case 'H': {
                return Lexer.getKeywordOrIdentifier(s, "HAVING", 1);
            }
            case 'I': {
                if ("INNER".equals(s)) {
                    return 1;
                }
                if ("INTERSECT".equals(s)) {
                    return 1;
                }
                return Lexer.getKeywordOrIdentifier(s, "IS", 1);
            }
            case 'J': {
                return Lexer.getKeywordOrIdentifier(s, "JOIN", 1);
            }
            case 'L': {
                if ("LIMIT".equals(s)) {
                    return 1;
                }
                return Lexer.getKeywordOrIdentifier(s, "LIKE", 1);
            }
            case 'M': {
                return Lexer.getKeywordOrIdentifier(s, "MINUS", 1);
            }
            case 'N': {
                if ("NOT".equals(s)) {
                    return 1;
                }
                if ("NATURAL".equals(s)) {
                    return 1;
                }
                return Lexer.getKeywordOrIdentifier(s, "NULL", 34);
            }
            case 'O': {
                if ("ON".equals(s)) {
                    return 1;
                }
                if (supportOffsetFetch && "OFFSET".equals(s)) {
                    return 1;
                }
                return Lexer.getKeywordOrIdentifier(s, "ORDER", 1);
            }
            case 'P': {
                return Lexer.getKeywordOrIdentifier(s, "PRIMARY", 1);
            }
            case 'R': {
                return Lexer.getKeywordOrIdentifier(s, "ROWNUM", 45);
            }
            case 'S': {
                if (s.equals("SYSTIMESTAMP")) {
                    return 42;
                }
                if (s.equals("SYSTIME")) {
                    return 44;
                }
                if (s.equals("SYSDATE")) {
                    return 42;
                }
                return Lexer.getKeywordOrIdentifier(s, "SELECT", 1);
            }
            case 'T': {
                if ("TODAY".equals(s)) {
                    return 43;
                }
                return Lexer.getKeywordOrIdentifier(s, "TRUE", 40);
            }
            case 'U': {
                return Lexer.getKeywordOrIdentifier(s, "UNION", 1);
            }
            case 'W': {
                return Lexer.getKeywordOrIdentifier(s, "WHERE", 1);
            }
        }
        return 2;
    }

    protected static int getKeywordOrIdentifier(String s1, String s2, int keywordType) {
        if (s1.equals(s2)) {
            return keywordType;
        }
        return 2;
    }
}

