/*
 * Decompiled with CFR 0.152.
 */
package tim.sql.h2parser;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import tim.sql.h2parser.StringUtils;

public class Message {
    public static SQLException getSyntaxError(String sql, int index) {
        sql = StringUtils.addAsterisk(sql, index);
        return new SQLException("SYNTAX_ERROR_1\n" + sql);
    }

    public static SQLException getSyntaxError(String sql, int index, String expected) {
        sql = StringUtils.addAsterisk(sql, index);
        return new SQLException("SYNTAX_ERROR_2\n" + sql + "\n-- expected: " + expected);
    }

    public static SQLException getUnsupportedError(String sql, int index) {
        sql = StringUtils.addAsterisk(sql, index);
        return new SQLException("UNSUPPORTED_ERROR_1\n" + sql);
    }

    public static SQLException getUnsupportedError(String sql, int index, String expected) {
        sql = StringUtils.addAsterisk(sql, index);
        return new SQLException("UNSUPPORTED_ERROR_2\n" + sql + "\n-- expected: " + expected);
    }

    public static SQLException getSQLException(String errorCode) {
        return new SQLException(errorCode);
    }

    public static SQLException getSQLException(String errorCode, String message) {
        return new SQLException(errorCode + "\n" + message);
    }

    public static SQLException getSQLException(String errorCode, String message, Throwable cause) {
        return new SQLException(errorCode + "\n" + message, cause);
    }

    public static Exception getSQLException(String string, String[] strings, NumberFormatException e) {
        return null;
    }

    public static SQLException convert(Throwable e) {
        if (e instanceof SQLException) {
            return (SQLException)e;
        }
        if (e instanceof OutOfMemoryError) {
            return Message.getSQLException("OUT_OF_MEMORY", null, e);
        }
        if (e instanceof InvocationTargetException) {
            InvocationTargetException te = (InvocationTargetException)e;
            Throwable t = te.getTargetException();
            if (t instanceof SQLException) {
                return (SQLException)t;
            }
            return Message.getSQLException("EXCEPTION_IN_FUNCTION", null, e);
        }
        if (e instanceof IOException) {
            return Message.getSQLException("IO_EXCEPTION_1", e.toString(), e);
        }
        return Message.getSQLException("GENERAL_ERROR_1", e.toString(), e);
    }

    public static RuntimeException getInternalError(String s) {
        RuntimeException e = new RuntimeException(s);
        return e;
    }

    public static Error getInternalError(String s, Exception e) {
        return new Error(s, e);
    }
}

