/*
 * Decompiled with CFR 0.152.
 */
package tim.sql.h2parser;

import java.sql.SQLException;
import java.util.ArrayList;
import tim.sql.h2parser.Database;
import tim.sql.h2parser.Lexer;
import tim.sql.h2parser.Message;
import tim.sql.h2parser.Prepared;
import tim.sql.h2parser.Schema;
import tim.sql.h2parser.Session;
import tim.sql.h2parser.Table;
import tim.sql.h2parser.TableFilter;
import tim.sql.h2parser.TableView;
import tim.sql.h2parser.dml.Query;
import tim.sql.h2parser.dml.Select;
import tim.sql.h2parser.dml.SelectOrderBy;
import tim.sql.h2parser.expr.Aggregate;
import tim.sql.h2parser.expr.Alias;
import tim.sql.h2parser.expr.CompareLike;
import tim.sql.h2parser.expr.Comparison;
import tim.sql.h2parser.expr.ConditionAndOr;
import tim.sql.h2parser.expr.ConditionExists;
import tim.sql.h2parser.expr.ConditionNot;
import tim.sql.h2parser.expr.Expression;
import tim.sql.h2parser.expr.ExpressionColumn;
import tim.sql.h2parser.expr.Function;
import tim.sql.h2parser.expr.Operation;
import tim.sql.h2parser.expr.Parameter;
import tim.sql.h2parser.expr.ValueExpression;
import tim.sql.h2parser.expr.Wildcard;

public class Parser
extends Lexer {
    Database database;
    Session session;
    protected Prepared prepared;
    protected Prepared currentPrepared;
    protected Select currentSelect;
    protected String schemaName;

    public Parser(Database database, Session session) {
        this.database = database;
        this.session = session;
    }

    public Prepared parseOnly(String sql) throws SQLException {
        try {
            return this.parse(sql);
        }
        catch (Exception e) {
            throw Message.convert(e);
        }
    }

    private Prepared parse(String sql) throws SQLException {
        this.initialize(sql);
        this.expectedList = new ArrayList();
        this.currentSelect = null;
        this.currentPrepared = null;
        this.prepared = null;
        this.read();
        return this.parsePrepared();
    }

    public Prepared parsePrepared() throws SQLException {
        int start = this.lastParseIndex;
        Query c = null;
        String token = this.currentToken;
        char first = token.charAt(0);
        switch (first) {
            case '(': {
                c = this.parseSelect();
                break;
            }
            case 'D': {
                if (this.readIf("DELETE")) {
                    throw this.getUnsupportedError();
                }
            }
            case 'F': {
                if (!this.isToken("FROM")) break;
                c = this.parseSelect();
                break;
            }
            case 'I': {
                if (!this.readIf("INSERT")) break;
                throw this.getUnsupportedError();
            }
            case 'M': {
                if (!this.readIf("MERGE")) break;
                throw this.getUnsupportedError();
            }
            case 'S': {
                if (this.isToken("SELECT")) {
                    c = this.parseSelect();
                }
            }
            case 'U': {
                if (!this.readIf("UPDATE")) break;
                throw this.getUnsupportedError();
            }
            default: {
                throw this.getSyntaxError();
            }
        }
        if (c == null) {
            throw this.getSyntaxError();
        }
        return c;
    }

    private Query parseSelect() throws SQLException {
        Query command = this.parseSelectUnion();
        return command;
    }

    private Query parseSelectUnion() throws SQLException {
        int start = this.lastParseIndex;
        Query command = this.parseSelectSub();
        return this.parseSelectUnionExtension(command, start, false);
    }

    private Query parseSelectUnionExtension(Query command, int start, boolean unionOnly) throws SQLException {
        if (this.readIf("UNION")) {
            throw this.getSyntaxError();
        }
        if (this.readIf("MINUS") || this.readIf("EXCEPT")) {
            throw this.getSyntaxError();
        }
        if (this.readIf("INTERSECT")) {
            throw this.getSyntaxError();
        }
        if (!unionOnly) {
            this.parseEndOfQuery(command);
        }
        return command;
    }

    private void parseEndOfQuery(Query command) throws SQLException {
        Select temp;
        if (this.readIf("ORDER")) {
            this.read("BY");
            Select oldSelect = this.currentSelect;
            if (command instanceof Select) {
                this.currentSelect = (Select)command;
            }
            ArrayList<SelectOrderBy> orderList = new ArrayList<SelectOrderBy>();
            do {
                boolean canBeNumber = true;
                if (this.readIf("=")) {
                    canBeNumber = false;
                }
                SelectOrderBy order = new SelectOrderBy();
                Expression expr = this.readExpression();
                if (canBeNumber && expr instanceof ValueExpression && expr.getType() == 4) {
                    order.columnIndexExpr = expr;
                } else if (expr instanceof Parameter) {
                    order.columnIndexExpr = expr;
                } else {
                    order.expression = expr;
                }
                if (this.readIf("DESC")) {
                    order.descending = true;
                } else {
                    this.readIf("ASC");
                }
                if (this.readIf("NULLS")) {
                    if (this.readIf("FIRST")) {
                        order.nullsFirst = true;
                    } else {
                        this.read("LAST");
                        order.nullsLast = true;
                    }
                }
                orderList.add(order);
            } while (this.readIf(","));
            command.setOrder(orderList);
            this.currentSelect = oldSelect;
        }
        if (this.supportOffsetFetch) {
            temp = this.currentSelect;
            this.currentSelect = null;
            if (this.readIf("OFFSET")) {
                throw this.getUnsupportedError();
            }
            if (this.readIf("FETCH")) {
                this.read("FIRST");
                throw this.getUnsupportedError();
            }
            this.currentSelect = temp;
        }
        if (this.readIf("LIMIT")) {
            temp = this.currentSelect;
            this.currentSelect = null;
            Expression limit = this.readExpression();
            command.setLimit(limit);
            if (this.readIf("OFFSET")) {
                Expression offset = this.readExpression();
                command.setOffset(offset);
            } else if (this.readIf(",")) {
                Expression offset = limit;
                limit = this.readExpression();
                command.setOffset(offset);
                command.setLimit(limit);
            }
            if (this.readIf("SAMPLE_SIZE")) {
                throw this.getUnsupportedError();
            }
            this.currentSelect = temp;
        }
        if (this.readIf("FOR")) {
            if (this.readIf("UPDATE")) {
                throw this.getUnsupportedError();
            }
            if (this.readIf("READ")) {
                throw this.getUnsupportedError();
            }
        }
    }

    private Query parseSelectSub() throws SQLException {
        if (this.readIf("(")) {
            Query command = this.parseSelectUnion();
            this.read(")");
            return command;
        }
        Select select = this.parseSelectSimple();
        return select;
    }

    private void parseSelectSimpleFromPart(Select command) throws SQLException {
        do {
            TableFilter filter = this.readTableFilter();
            this.parseJoinTableFilter(filter, command);
        } while (this.readIf(","));
    }

    private void parseJoinTableFilter(TableFilter top, Select command) throws SQLException {
        top = this.readJoin(top, command);
        command.setTableFilter(top);
    }

    private void parseSelectSimpleSelectPart(Select command) throws SQLException {
        Select temp = this.currentSelect;
        this.currentSelect = null;
        if (this.readIf("TOP")) {
            Expression limit = this.readTerm();
            command.setLimit(limit);
        } else if (this.readIf("LIMIT")) {
            Expression offset = this.readTerm();
            command.setOffset(offset);
            Expression limit = this.readTerm();
            command.setLimit(limit);
        }
        this.currentSelect = temp;
        if (this.readIf("DISTINCT")) {
            throw this.getUnsupportedError();
        }
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        do {
            if (this.readIf("*")) {
                expressions.add(new Wildcard());
                continue;
            }
            Expression expr = this.readExpression();
            if (this.readIf("AS") || this.currentTokenType == 2) {
                String alias = this.readAliasIdentifier();
                expr = new Alias(expr, alias);
            }
            expressions.add(expr);
        } while (this.readIf(","));
        command.setExpressions(expressions);
    }

    private Select parseSelectSimple() throws SQLException {
        Expression condition;
        boolean fromFirst;
        if (this.readIf("SELECT")) {
            fromFirst = false;
        } else if (this.readIf("FROM")) {
            fromFirst = true;
        } else {
            throw this.getSyntaxError();
        }
        Select command = new Select(this.session);
        int start = this.lastParseIndex;
        Select oldSelect = this.currentSelect;
        this.currentSelect = command;
        this.currentPrepared = command;
        if (fromFirst) {
            this.parseSelectSimpleFromPart(command);
            this.read("SELECT");
            this.parseSelectSimpleSelectPart(command);
        } else {
            this.parseSelectSimpleSelectPart(command);
            if (!this.readIf("FROM")) {
                throw this.getUnsupportedError();
            }
            this.parseSelectSimpleFromPart(command);
        }
        if (this.readIf("WHERE")) {
            condition = this.readExpression();
            command.addCondition(condition);
        }
        this.currentSelect = oldSelect;
        if (this.readIf("GROUP")) {
            this.read("BY");
            command.setGroupQuery();
            ArrayList<Expression> list = new ArrayList<Expression>();
            do {
                Expression expr = this.readExpression();
                list.add(expr);
            } while (this.readIf(","));
            command.setGroupBy(list);
        }
        this.currentSelect = command;
        if (this.readIf("HAVING")) {
            command.setGroupQuery();
            condition = this.readExpression();
            command.setHaving(condition);
        }
        this.currentSelect = oldSelect;
        return command;
    }

    private Expression readExpression() throws SQLException {
        Expression r = this.readAnd();
        while (this.readIf("OR")) {
            r = new ConditionAndOr(1, r, this.readAnd());
        }
        return r;
    }

    private Expression readAnd() throws SQLException {
        Expression r = this.readCondition();
        while (this.readIf("AND")) {
            r = new ConditionAndOr(0, r, this.readCondition());
        }
        return r;
    }

    private Expression readCondition() throws SQLException {
        if (this.readIf("NOT")) {
            return new ConditionNot(this.readCondition());
        }
        if (this.readIf("EXISTS")) {
            this.read("(");
            Query query = this.parseSelect();
            this.read(")");
            return new ConditionExists(query);
        }
        Expression r = this.readConcat();
        while (true) {
            int backup = this.parseIndex;
            boolean not = false;
            if (this.readIf("NOT")) {
                not = true;
                if (this.isToken("NULL")) {
                    this.parseIndex = backup;
                    this.currentToken = "NOT";
                    break;
                }
            }
            if (this.readIf("LIKE")) {
                Expression b = this.readConcat();
                Expression esc = null;
                if (this.readIf("ESCAPE")) {
                    esc = this.readConcat();
                }
                r = new CompareLike(r, b, esc, false);
            } else if (this.readIf("REGEXP")) {
                Expression b = this.readConcat();
                r = new CompareLike(r, b, null, true);
            } else if (this.readIf("IS")) {
                int type = this.readIf("NOT") ? 7 : 6;
                this.read("NULL");
                r = new Comparison(type, r, null);
            } else {
                if (this.readIf("IN")) {
                    throw this.getUnsupportedError();
                }
                if (this.readIf("BETWEEN")) {
                    throw this.getUnsupportedError();
                }
                int compareType = this.getCompareType(this.currentTokenType);
                if (compareType < 0) break;
                this.read();
                if (this.readIf("ALL")) {
                    throw this.getUnsupportedError();
                }
                if (this.readIf("ANY") || this.readIf("SOME")) {
                    throw this.getUnsupportedError();
                }
                Expression right = this.readConcat();
                r = new Comparison(compareType, r, right);
            }
            if (!not) continue;
            r = new ConditionNot(r);
        }
        return r;
    }

    private int getCompareType(int tokenType) {
        switch (tokenType) {
            case 6: {
                return 0;
            }
            case 7: {
                return 1;
            }
            case 8: {
                return 2;
            }
            case 9: {
                return 4;
            }
            case 10: {
                return 3;
            }
            case 11: {
                return 5;
            }
        }
        return -1;
    }

    private Expression readConcat() throws SQLException {
        Expression r = this.readSum();
        if (this.readIf("||")) {
            throw this.getUnsupportedError();
        }
        if (this.readIf("~")) {
            throw this.getUnsupportedError();
        }
        if (this.readIf("!~")) {
            throw this.getUnsupportedError();
        }
        return r;
    }

    private Expression readSum() throws SQLException {
        Expression r = this.readFactor();
        while (true) {
            if (this.readIf("+")) {
                r = new Operation(1, r, this.readFactor());
                continue;
            }
            if (!this.readIf("-")) break;
            r = new Operation(2, r, this.readFactor());
        }
        return r;
    }

    private Expression readFactor() throws SQLException {
        Expression r = this.readTerm();
        while (true) {
            if (this.readIf("*")) {
                r = new Operation(3, r, this.readTerm());
                continue;
            }
            if (!this.readIf("/")) break;
            r = new Operation(4, r, this.readTerm());
        }
        return r;
    }

    private Expression readAggregate(int aggregateType) throws SQLException {
        Aggregate r;
        if (this.currentSelect == null) {
            throw this.getSyntaxError();
        }
        this.currentSelect.setGroupQuery();
        if (aggregateType == 1) {
            if (this.readIf("*")) {
                r = new Aggregate(0, null, this.currentSelect, false);
            } else {
                boolean distinct = this.readIf("DISTINCT");
                Expression on = this.readExpression();
                r = on instanceof Wildcard && !distinct ? new Aggregate(0, null, this.currentSelect, false) : new Aggregate(1, on, this.currentSelect, distinct);
            }
        } else if (aggregateType == 6) {
            boolean distinct = this.readIf("DISTINCT");
            Aggregate agg = new Aggregate(6, this.readExpression(), this.currentSelect, distinct);
            if (this.readIf("ORDER")) {
                this.read("BY");
                agg.setOrder(this.parseSimpleOrderList());
            }
            if (this.readIf("SEPARATOR")) {
                agg.setSeparator(this.readExpression());
            }
            r = agg;
        } else {
            boolean distinct = this.readIf("DISTINCT");
            r = new Aggregate(aggregateType, this.readExpression(), this.currentSelect, distinct);
        }
        this.read(")");
        return r;
    }

    private ArrayList parseSimpleOrderList() throws SQLException {
        ArrayList<SelectOrderBy> orderList = new ArrayList<SelectOrderBy>();
        do {
            Expression expr;
            SelectOrderBy order = new SelectOrderBy();
            order.expression = expr = this.readExpression();
            if (this.readIf("DESC")) {
                order.descending = true;
            } else {
                this.readIf("ASC");
            }
            orderList.add(order);
        } while (this.readIf(","));
        return orderList;
    }

    private Expression readTermObjectDot(String objectName) throws SQLException {
        Expression expr = this.readWildcardOrSequenceValue(null, objectName);
        if (expr != null) {
            return expr;
        }
        String name = this.readColumnIdentifier();
        if (this.readIf(".")) {
            String schema = objectName;
            expr = this.readWildcardOrSequenceValue(schema, objectName = name);
            if (expr != null) {
                return expr;
            }
            name = this.readColumnIdentifier();
            if (this.readIf(".")) {
                schema = objectName;
                expr = this.readWildcardOrSequenceValue(schema, objectName = name);
                if (expr != null) {
                    return expr;
                }
                name = this.readColumnIdentifier();
                return new ExpressionColumn(schema, objectName, name);
            }
            return new ExpressionColumn(schema, objectName, name);
        }
        return new ExpressionColumn(null, objectName, name);
    }

    private Expression readWildcardOrSequenceValue(String schema, String objectName) throws SQLException {
        if (this.readIf("*")) {
            throw this.getUnsupportedError();
        }
        if (schema == null) {
            // empty if block
        }
        if (this.readIf("NEXTVAL")) {
            throw this.getUnsupportedError();
        }
        if (this.readIf("CURRVAL")) {
            throw this.getUnsupportedError();
        }
        return null;
    }

    private Expression readTerm() throws SQLException {
        Expression r;
        switch (this.currentTokenType) {
            case 12: {
                this.read();
                throw this.getUnsupportedError();
            }
            case 3: {
                this.read();
                r = new Parameter();
                break;
            }
            case 1: {
                if (this.isToken("SELECT") || this.isToken("FROM")) {
                    throw this.getUnsupportedError();
                }
                throw this.getSyntaxError();
            }
            case 2: {
                String name = this.currentToken;
                if (this.currentTokenQuoted) {
                    this.read();
                    if (this.readIf("(")) {
                        r = this.readFunction(name);
                        break;
                    }
                    if (this.readIf(".")) {
                        r = this.readTermObjectDot(name);
                        break;
                    }
                    r = new ExpressionColumn(null, null, name);
                    break;
                }
                this.read();
                if (this.readIf(".")) {
                    r = this.readTermObjectDot(name);
                    break;
                }
                if ("CASE".equals(name)) {
                    throw this.getUnsupportedError();
                }
                if (this.readIf("(")) {
                    r = this.readFunction(name);
                    break;
                }
                r = new ExpressionColumn(null, null, name);
                break;
            }
            case 17: {
                this.read();
                r = new Operation(5, this.readTerm(), null);
                break;
            }
            case 18: {
                this.read();
                r = this.readTerm();
                break;
            }
            case 31: {
                this.read();
                r = this.readExpression();
                if (this.readIf(",")) {
                    throw this.getUnsupportedError();
                }
                this.read(")");
                break;
            }
            case 40: {
                this.read();
                r = ValueExpression.TRUE;
                break;
            }
            case 41: {
                this.read();
                r = ValueExpression.FALSE;
                break;
            }
            case 44: {
                this.read();
                throw this.getUnsupportedError();
            }
            case 43: {
                this.read();
                throw this.getUnsupportedError();
            }
            case 42: {
                throw this.getUnsupportedError();
            }
            case 45: {
                this.read();
                throw this.getUnsupportedError();
            }
            case 34: {
                this.read();
                r = ValueExpression.NULL;
                break;
            }
            case 5: {
                r = new ValueExpression(this.currentValue);
                this.read();
                break;
            }
            default: {
                throw this.getSyntaxError();
            }
        }
        return r;
    }

    private String readAliasIdentifier() throws SQLException {
        return this.readColumnIdentifier();
    }

    private String readColumnIdentifier() throws SQLException {
        if (this.currentTokenType != 2) {
            throw Message.getSyntaxError(this.sqlCommand, this.parseIndex, "identifier");
        }
        String s = this.currentToken;
        this.read();
        return s;
    }

    private Expression readFunction(String name) throws SQLException {
        int agg = Aggregate.getAggregateType(name);
        if (agg >= 0) {
            return this.readAggregate(agg);
        }
        Function function = new Function(name);
        if (!this.readIf(")")) {
            int i = 0;
            do {
                function.setParameter(i++, this.readExpression());
            } while (this.readIf(","));
            this.read(")");
        }
        return function;
    }

    private Schema getSchema() throws SQLException {
        if (this.schemaName == null) {
            return null;
        }
        Schema schema = this.database.findSchema(this.schemaName);
        if (schema == null) {
            if ("SESSION".equals(this.schemaName)) {
                schema = this.database.getSchema(this.session.getCurrentSchemaName());
            } else {
                throw Message.getSQLException("SCHEMA_NOT_FOUND_1", this.schemaName);
            }
        }
        return schema;
    }

    private String readIdentifierWithSchema(String defaultSchemaName) throws SQLException {
        if (this.currentTokenType != 2) {
            throw Message.getSyntaxError(this.sqlCommand, this.parseIndex, "identifier");
        }
        String s = this.currentToken;
        this.read();
        this.schemaName = defaultSchemaName;
        if (this.readIf(".")) {
            this.schemaName = s;
            if (this.currentTokenType != 2) {
                throw Message.getSyntaxError(this.sqlCommand, this.parseIndex, "identifier");
            }
            s = this.currentToken;
            this.read();
        }
        if (".".equals(this.currentToken) && this.schemaName.equalsIgnoreCase(this.session.getDBShortName())) {
            this.read(".");
            this.schemaName = s;
            if (this.currentTokenType != 2) {
                throw Message.getSyntaxError(this.sqlCommand, this.parseIndex, "identifier");
            }
            s = this.currentToken;
            this.read();
        }
        return s;
    }

    private Table readTableOrView(String tableName) throws SQLException {
        if (this.schemaName != null) {
            return this.getSchema().getTableOrView(tableName);
        }
        Table table = this.database.getSchema(this.session.getCurrentSchemaName()).findTableOrView(tableName);
        if (table != null) {
            return table;
        }
        return this.session.findTableOrView(tableName);
    }

    /*
     * Enabled aggressive block sorting
     */
    private TableFilter readTableFilter() throws SQLException {
        Table table;
        String alias;
        block6: {
            alias = null;
            if (this.readIf("(")) {
                if (this.isToken("SELECT") || this.isToken("FROM")) {
                    int start = this.lastParseIndex;
                    Query query = this.parseSelectUnion();
                    this.read(")");
                    query = this.parseSelectUnionExtension(query, start, true);
                    table = TableView.createTempView(this.session.getNextTempViewName(), query);
                    alias = table.getName();
                    break block6;
                } else {
                    TableFilter top = this.readTableFilter();
                    top = this.readJoin(top, this.currentSelect);
                    this.read(")");
                    alias = this.readFromAlias(null);
                    if (alias != null) {
                        top.setAlias(alias);
                    }
                    return top;
                }
            }
            String tableName = this.readIdentifierWithSchema(null);
            if (this.readIf("(")) {
                throw this.getUnsupportedError();
            }
            if ("DUAL".equals(tableName)) {
                throw this.getUnsupportedError();
            }
            table = this.readTableOrView(tableName);
        }
        alias = this.readFromAlias(alias);
        return new TableFilter(table, alias);
    }

    private TableFilter readJoin(TableFilter top, Select command) throws SQLException {
        while (true) {
            Expression on;
            TableFilter join;
            if (this.readIf("RIGHT")) {
                this.readIf("OUTER");
                this.read("JOIN");
                join = this.readTableFilter();
                top = this.readJoin(top, command);
                on = null;
                if (this.readIf("ON")) {
                    on = this.readExpression();
                }
                top.addJoin(join, "RIGHT", on);
                continue;
            }
            if (this.readIf("LEFT")) {
                this.readIf("OUTER");
                this.read("JOIN");
                join = this.readTableFilter();
                top = this.readJoin(top, command);
                on = null;
                if (this.readIf("ON")) {
                    on = this.readExpression();
                }
                top.addJoin(join, "LEFT", on);
                continue;
            }
            if (this.readIf("FULL")) {
                throw this.getSyntaxError();
            }
            if (this.readIf("INNER")) {
                this.read("JOIN");
                join = this.readTableFilter();
                top = this.readJoin(top, command);
                on = null;
                if (this.readIf("ON")) {
                    on = this.readExpression();
                }
                top.addJoin(join, "INNER", on);
                continue;
            }
            if (!this.readIf("JOIN")) break;
            join = this.readTableFilter();
            top = this.readJoin(top, command);
            on = null;
            if (this.readIf("ON")) {
                on = this.readExpression();
            }
            top.addJoin(join, "", on);
        }
        if (this.readIf("CROSS")) {
            throw this.getSyntaxError();
        }
        if (this.readIf("NATURAL")) {
            throw this.getSyntaxError();
        }
        return top;
    }

    private String readFromAlias(String alias) throws SQLException {
        if (this.readIf("AS")) {
            alias = this.readAliasIdentifier();
        } else if (!(this.currentTokenType != 2 || this.isToken("LEFT") || this.isToken("RIGHT") || this.isToken("FULL"))) {
            alias = this.readAliasIdentifier();
        }
        return alias;
    }
}

