/*
 * Decompiled with CFR 0.152.
 */
package tim.sql.h2parser;

public class StringUtils {
    public static String addAsterisk(String s, int index) {
        if (s != null && index < s.length()) {
            s = s.substring(0, index) + "[*]" + s.substring(index);
        }
        return s;
    }

    public static String enclose(String s) {
        if (s.startsWith("(")) {
            return s;
        }
        return "(" + s + ")";
    }

    public static String unEnclose(String s) {
        if (s.startsWith("(") && s.endsWith(")")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String quoteStringSQL(String s) {
        if (s == null) {
            return "NULL";
        }
        StringBuffer buff = new StringBuffer(s.length() + 2);
        buff.append('\'');
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\'') {
                buff.append(c);
            } else if (c < ' ' || c > '\u007f') {
                return "STRINGDECODE(" + StringUtils.quoteStringSQL(StringUtils.javaEncode(s)) + ")";
            }
            buff.append(c);
        }
        buff.append('\'');
        return buff.toString();
    }

    public static String javaEncode(String s) {
        StringBuffer buff = new StringBuffer(s.length());
        block8: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\t': {
                    buff.append("\\t");
                    continue block8;
                }
                case '\n': {
                    buff.append("\\n");
                    continue block8;
                }
                case '\f': {
                    buff.append("\\f");
                    continue block8;
                }
                case '\r': {
                    buff.append("\\r");
                    continue block8;
                }
                case '\"': {
                    buff.append("\\\"");
                    continue block8;
                }
                case '\\': {
                    buff.append("\\\\");
                    continue block8;
                }
                default: {
                    int ch = c & 0xFFFF;
                    if (ch >= 32 && ch < 128) {
                        buff.append(c);
                        continue block8;
                    }
                    buff.append("\\u");
                    buff.append(Integer.toHexString(0x10000 | ch).substring(1));
                }
            }
        }
        return buff.toString();
    }
}

