/*
 * Decompiled with CFR 0.152.
 */
package tim.sql.h2parser;

import java.util.List;
import tim.sql.h2parser.Table;
import tim.sql.h2parser.expr.Expression;
import tim.sql.h2parser.expr.ExpressionColumn;

public class TableFilter {
    public Table table;
    String alias;
    TableFilter join;
    Expression joinOn;
    String joinType;

    public TableFilter(Table table, String alias) {
        this.table = table;
        this.alias = alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void addJoin(TableFilter filter, String joinType, Expression on) {
        if (this.join == null) {
            this.join = filter;
            this.joinOn = on;
            this.joinType = joinType;
        } else {
            this.join.addJoin(filter, joinType, on);
        }
    }

    public String getSQL() {
        String r = "";
        TableFilter prev = null;
        TableFilter tf = this;
        while (tf != null) {
            if (prev == null) {
                r = r + tf.table.getSQL();
                if (tf.alias != null) {
                    r = r + " AS " + tf.alias;
                }
            } else {
                r = r + prev.joinType + " JOIN " + tf.table.getSQL();
                if (tf.alias != null) {
                    r = r + " AS " + tf.alias;
                }
                r = r + " ON " + prev.joinOn.getSQL();
            }
            r = r + "\n";
            prev = tf;
            tf = prev.join;
        }
        return r;
    }

    public TableFilter getJoin() {
        return this.join;
    }

    public String getAlias() {
        return this.alias;
    }

    public void buildColList(List<ExpressionColumn> r) {
        if (this.joinOn != null) {
            this.joinOn.buildColList(r);
        }
        if (this.join != null) {
            this.join.buildColList(r);
        }
    }
}

