/*
 * Decompiled with CFR 0.152.
 */
package tim.sql.h2parser.dml;

import java.util.LinkedList;
import java.util.List;
import tim.sql.h2parser.ColumnScope;
import tim.sql.h2parser.StringUtils;
import tim.sql.h2parser.TableFilter;
import tim.sql.h2parser.TableView;
import tim.sql.h2parser.dml.Query;
import tim.sql.h2parser.dml.SelectOrderBy;
import tim.sql.h2parser.expr.Expression;
import tim.sql.h2parser.expr.ExpressionColumn;

public class Select
extends Query
implements ColumnScope {
    private boolean distinct = false;
    List<Expression> expressions;
    Expression condition;
    private boolean isGroupQuery;
    private List<SelectOrderBy> orderList;
    private List<Expression> group;
    Expression having;
    Expression limit;
    Expression offset;
    private TableFilter topTableFilter;

    public Select(Object session) {
    }

    public void setExpressions(List expressions) {
        this.expressions = expressions;
    }

    public void addCondition(Expression condition) {
        this.condition = condition;
    }

    @Override
    public void setOrder(List order) {
        this.orderList = order;
    }

    public void setGroupQuery() {
        this.isGroupQuery = true;
    }

    public void setGroupBy(List group) {
        this.group = group;
    }

    public void setHaving(Expression having) {
        this.having = having;
    }

    @Override
    public void setLimit(Expression limit) {
        this.limit = limit;
    }

    @Override
    public void setOffset(Expression offset) {
        this.offset = offset;
    }

    public void setTableFilter(TableFilter top) {
        this.topTableFilter = top;
    }

    @Override
    public String getSQL() {
        int i;
        StringBuffer buff = new StringBuffer();
        Expression[] exprList = new Expression[this.expressions.size()];
        this.expressions.toArray(exprList);
        buff.append("SELECT ");
        if (this.distinct) {
            buff.append("DISTINCT ");
        }
        for (i = 0; i < exprList.length; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            Expression expr = exprList[i];
            buff.append(expr.getSQL());
        }
        buff.append("\nFROM ");
        buff.append(this.topTableFilter.getSQL());
        if (this.condition != null) {
            buff.append("\nWHERE " + StringUtils.unEnclose(this.condition.getSQL()));
        }
        if (this.group != null) {
            buff.append("\nGROUP BY ");
            for (i = 0; i < this.group.size(); ++i) {
                Expression g = this.group.get(i);
                if (i > 0) {
                    buff.append(", ");
                }
                buff.append(StringUtils.unEnclose(g.getSQL()));
            }
        }
        if (this.having != null) {
            Expression h = this.having;
            buff.append("\nHAVING " + StringUtils.unEnclose(h.getSQL()));
        }
        if (this.orderList != null) {
            buff.append("\nORDER BY ");
            for (int i2 = 0; i2 < this.orderList.size(); ++i2) {
                if (i2 > 0) {
                    buff.append(", ");
                }
                SelectOrderBy o = this.orderList.get(i2);
                buff.append(StringUtils.unEnclose(o.getSQL()));
            }
        }
        if (this.limit != null) {
            buff.append("\nLIMIT ");
            buff.append(StringUtils.unEnclose(this.limit.getSQL()));
            if (this.offset != null) {
                buff.append(" OFFSET ");
                buff.append(StringUtils.unEnclose(this.offset.getSQL()));
            }
        }
        return buff.toString();
    }

    @Override
    public void listScopes(List<ColumnScope> r) {
        for (TableFilter tf = this.topTableFilter; tf != null; tf = tf.getJoin()) {
            if (!(tf.table instanceof TableView)) continue;
            ((TableView)tf.table).query.listScopes(r);
        }
        r.add(this);
    }

    @Override
    public Iterable<ExpressionColumn> listColumns() {
        LinkedList<ExpressionColumn> r = new LinkedList<ExpressionColumn>();
        for (Expression expr : this.expressions) {
            expr.buildColList(r);
        }
        this.topTableFilter.buildColList(r);
        if (this.condition != null) {
            this.condition.buildColList(r);
        }
        if (this.having != null) {
            this.having.buildColList(r);
        }
        if (this.limit != null) {
            this.limit.buildColList(r);
        }
        if (this.offset != null) {
            this.offset.buildColList(r);
        }
        if (this.group != null) {
            for (Expression expr : this.group) {
                expr.buildColList(r);
            }
        }
        if (this.orderList != null) {
            for (SelectOrderBy sob : this.orderList) {
                sob.buildColList(r);
            }
        }
        return r;
    }

    @Override
    public Iterable<TableFilter> listTableFilters() {
        LinkedList<TableFilter> r = new LinkedList<TableFilter>();
        for (TableFilter tf = this.topTableFilter; tf != null; tf = tf.getJoin()) {
            r.add(tf);
        }
        return r;
    }
}

