/*
 * Decompiled with CFR 0.152.
 */
package tim.sql.h2parser.expr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import tim.sql.h2parser.Message;
import tim.sql.h2parser.ObjectUtils;
import tim.sql.h2parser.StringUtils;
import tim.sql.h2parser.dml.Select;
import tim.sql.h2parser.dml.SelectOrderBy;
import tim.sql.h2parser.expr.Expression;
import tim.sql.h2parser.expr.ExpressionColumn;

public class Aggregate
extends Expression {
    public static final int COUNT_ALL = 0;
    public static final int COUNT = 1;
    public static final int SUM = 2;
    public static final int MIN = 3;
    public static final int MAX = 4;
    public static final int AVG = 5;
    public static final int GROUP_CONCAT = 6;
    public static final int STDDEV_POP = 7;
    public static final int STDDEV_SAMP = 8;
    public static final int VAR_POP = 9;
    public static final int VAR_SAMP = 10;
    public static final int BOOL_OR = 11;
    public static final int BOOL_AND = 12;
    public static final int SELECTIVITY = 13;
    private static final HashMap AGGREGATES = new HashMap();
    private final int type;
    private final Select select;
    private final boolean distinct;
    private Expression on;
    private Expression separator;
    private List<SelectOrderBy> orderList;
    private int dataType;
    private int scale;
    private long precision;
    private int displaySize;
    private int lastGroupRowId;

    public Aggregate(int type, Expression on, Select select, boolean distinct) {
        this.type = type;
        this.on = on;
        this.select = select;
        this.distinct = distinct;
    }

    private static void addAggregate(String name, int type) {
        AGGREGATES.put(name, ObjectUtils.getInteger(type));
    }

    public static int getAggregateType(String name) {
        Integer type = (Integer)AGGREGATES.get(name);
        return type == null ? -1 : type;
    }

    public void setOrder(ArrayList orderBy) {
        this.orderList = orderBy;
    }

    public void setSeparator(Expression separator) {
        this.separator = separator;
    }

    @Override
    public int getType() {
        return this.dataType;
    }

    public int getScale() {
        return this.scale;
    }

    public long getPrecision() {
        return this.precision;
    }

    public int getDisplaySize() {
        return this.displaySize;
    }

    private String getSQLGroupConcat() {
        StringBuffer buff = new StringBuffer();
        buff.append("GROUP_CONCAT(");
        buff.append(this.on.getSQL());
        if (this.orderList != null) {
            buff.append(" ORDER BY ");
            for (int i = 0; i < this.orderList.size(); ++i) {
                SelectOrderBy o = this.orderList.get(i);
                if (i > 0) {
                    buff.append(", ");
                }
                buff.append(o.expression.getSQL());
                if (!o.descending) continue;
                buff.append(" DESC");
            }
        }
        if (this.separator != null) {
            buff.append(" SEPARATOR ");
            buff.append(this.separator.getSQL());
        }
        buff.append(")");
        return buff.toString();
    }

    @Override
    public String getSQL() {
        String text;
        switch (this.type) {
            case 6: {
                return this.getSQLGroupConcat();
            }
            case 0: {
                return "COUNT(*)";
            }
            case 1: {
                text = "COUNT";
                break;
            }
            case 13: {
                text = "SELECTIVITY";
                break;
            }
            case 2: {
                text = "SUM";
                break;
            }
            case 3: {
                text = "MIN";
                break;
            }
            case 4: {
                text = "MAX";
                break;
            }
            case 5: {
                text = "AVG";
                break;
            }
            case 7: {
                text = "STDDEV_POP";
                break;
            }
            case 8: {
                text = "STDDEV_SAMP";
                break;
            }
            case 9: {
                text = "VAR_POP";
                break;
            }
            case 10: {
                text = "VAR_SAMP";
                break;
            }
            case 12: {
                text = "BOOL_AND";
                break;
            }
            case 11: {
                text = "BOOL_OR";
                break;
            }
            default: {
                throw Message.getInternalError("type=" + this.type);
            }
        }
        if (this.distinct) {
            return text + "(DISTINCT " + this.on.getSQL() + ")";
        }
        return text + StringUtils.enclose(this.on.getSQL());
    }

    @Override
    public void buildColList(List<ExpressionColumn> r) {
        this.on.buildColList(r);
        if (this.separator != null) {
            this.separator.buildColList(r);
        }
        if (this.orderList != null) {
            for (int i = 0; i < this.orderList.size(); ++i) {
                SelectOrderBy o = this.orderList.get(i);
                o.expression.buildColList(r);
            }
        }
    }

    static {
        Aggregate.addAggregate("COUNT", 1);
        Aggregate.addAggregate("SUM", 2);
        Aggregate.addAggregate("MIN", 3);
        Aggregate.addAggregate("MAX", 4);
        Aggregate.addAggregate("AVG", 5);
        Aggregate.addAggregate("GROUP_CONCAT", 6);
        Aggregate.addAggregate("STDDEV_SAMP", 8);
        Aggregate.addAggregate("STDDEV", 8);
        Aggregate.addAggregate("STDDEV_POP", 7);
        Aggregate.addAggregate("STDDEVP", 7);
        Aggregate.addAggregate("VAR_POP", 9);
        Aggregate.addAggregate("VARP", 9);
        Aggregate.addAggregate("VAR_SAMP", 10);
        Aggregate.addAggregate("VAR", 10);
        Aggregate.addAggregate("VARIANCE", 10);
        Aggregate.addAggregate("BOOL_OR", 11);
        Aggregate.addAggregate("SOME", 11);
        Aggregate.addAggregate("BOOL_AND", 12);
        Aggregate.addAggregate("EVERY", 12);
        Aggregate.addAggregate("SELECTIVITY", 13);
    }
}

