/*
 * Decompiled with CFR 0.152.
 */
package tim.sql.h2parser.expr;

import java.util.List;
import tim.sql.h2parser.expr.Condition;
import tim.sql.h2parser.expr.Expression;
import tim.sql.h2parser.expr.ExpressionColumn;

public class CompareLike
extends Condition {
    private final boolean regexp;
    private Expression left;
    private Expression right;
    private Expression escape;

    public CompareLike(Expression left, Expression right, Expression escape, boolean regexp) {
        this.regexp = regexp;
        this.left = left;
        this.right = right;
        this.escape = escape;
    }

    @Override
    public String getSQL() {
        String sql;
        if (this.regexp) {
            sql = this.left.getSQL() + " REGEXP " + this.right.getSQL();
        } else {
            sql = this.left.getSQL() + " LIKE " + this.right.getSQL();
            if (this.escape != null) {
                sql = sql + " ESCAPE " + this.escape.getSQL();
            }
        }
        return "(" + sql + ")";
    }

    @Override
    public void buildColList(List<ExpressionColumn> r) {
        this.left.buildColList(r);
        this.right.buildColList(r);
        this.escape.buildColList(r);
    }
}

