/*
 * Decompiled with CFR 0.152.
 */
package tim.sql.h2parser.expr;

import java.util.List;
import tim.sql.h2parser.Message;
import tim.sql.h2parser.expr.Condition;
import tim.sql.h2parser.expr.Expression;
import tim.sql.h2parser.expr.ExpressionColumn;

public class Comparison
extends Condition {
    public static final int EQUAL = 0;
    public static final int BIGGER_EQUAL = 1;
    public static final int BIGGER = 2;
    public static final int SMALLER_EQUAL = 3;
    public static final int SMALLER = 4;
    public static final int NOT_EQUAL = 5;
    public static final int IS_NULL = 6;
    public static final int IS_NOT_NULL = 7;
    public static final int FALSE = 8;
    private final int compareType;
    private Expression left;
    private Expression right;
    private int dataType = -2;

    public Comparison(int compareType, Expression left, Expression right) {
        this.left = left;
        this.right = right;
        this.compareType = compareType;
    }

    @Override
    public String getSQL() {
        String sql;
        switch (this.compareType) {
            case 0: {
                sql = this.left.getSQL() + " = " + this.right.getSQL();
                break;
            }
            case 1: {
                sql = this.left.getSQL() + " >= " + this.right.getSQL();
                break;
            }
            case 2: {
                sql = this.left.getSQL() + " > " + this.right.getSQL();
                break;
            }
            case 3: {
                sql = this.left.getSQL() + " <= " + this.right.getSQL();
                break;
            }
            case 4: {
                sql = this.left.getSQL() + " < " + this.right.getSQL();
                break;
            }
            case 5: {
                sql = this.left.getSQL() + " <> " + this.right.getSQL();
                break;
            }
            case 6: {
                sql = this.left.getSQL() + " IS NULL";
                break;
            }
            case 7: {
                sql = this.left.getSQL() + " IS NOT NULL";
                break;
            }
            default: {
                throw Message.getInternalError("compareType=" + this.compareType);
            }
        }
        return "(" + sql + ")";
    }

    public Expression getExpression(boolean left) {
        return left ? this.left : this.right;
    }

    @Override
    public void buildColList(List<ExpressionColumn> r) {
        this.left.buildColList(r);
        if (this.right != null) {
            this.right.buildColList(r);
        }
    }
}

