/*
 * Decompiled with CFR 0.152.
 */
package tim.sql.h2parser.expr;

import java.util.List;
import tim.sql.h2parser.Message;
import tim.sql.h2parser.expr.Condition;
import tim.sql.h2parser.expr.Expression;
import tim.sql.h2parser.expr.ExpressionColumn;

public class ConditionAndOr
extends Condition {
    public static final int AND = 0;
    public static final int OR = 1;
    private final int andOrType;
    private Expression left;
    private Expression right;

    public ConditionAndOr(int andOrType, Expression left, Expression right) {
        this.andOrType = andOrType;
        this.left = left;
        this.right = right;
        assert (left != null && right != null);
    }

    @Override
    public String getSQL() {
        String sql;
        switch (this.andOrType) {
            case 0: {
                sql = this.left.getSQL() + " AND " + this.right.getSQL();
                break;
            }
            case 1: {
                sql = this.left.getSQL() + " OR " + this.right.getSQL();
                break;
            }
            default: {
                throw Message.getInternalError("andOrType=" + this.andOrType);
            }
        }
        return "(" + sql + ")";
    }

    public Expression getExpression(boolean left) {
        return left ? this.left : this.right;
    }

    @Override
    public void buildColList(List<ExpressionColumn> r) {
        this.left.buildColList(r);
        this.right.buildColList(r);
    }
}

