/*
 * Decompiled with CFR 0.152.
 */
package tim.sql.h2parser.expr;

import java.util.ArrayList;
import java.util.List;
import tim.sql.h2parser.expr.Expression;
import tim.sql.h2parser.expr.ExpressionColumn;

public class Function
extends Expression {
    final String name;
    final List<Expression> params = new ArrayList<Expression>();

    public Function(String name) {
        this.name = name;
    }

    @Override
    public String getSQL() {
        String r = this.name + "(";
        for (int i = 0; i < this.params.size(); ++i) {
            if (i > 0) {
                r = r + ",";
            }
            r = r + this.params.get(i).getSQL();
        }
        r = r + ")";
        return r;
    }

    public void setParameter(int i, Expression readExpression) {
        this.params.add(readExpression);
    }

    @Override
    public void buildColList(List<ExpressionColumn> r) {
        for (Expression e : this.params) {
            e.buildColList(r);
        }
    }
}

