/*
 * Decompiled with CFR 0.152.
 */
package tim.sql.h2parser.expr;

import java.util.List;
import tim.sql.h2parser.Message;
import tim.sql.h2parser.expr.Expression;
import tim.sql.h2parser.expr.ExpressionColumn;

public class Operation
extends Expression {
    public static final int CONCAT = 0;
    public static final int PLUS = 1;
    public static final int MINUS = 2;
    public static final int MULTIPLY = 3;
    public static final int DIVIDE = 4;
    public static final int NEGATE = 5;
    private int opType;
    private Expression left;
    private Expression right;

    public Operation(int opType, Expression left, Expression right) {
        this.opType = opType;
        this.left = left;
        this.right = right;
    }

    @Override
    public String getSQL() {
        String sql;
        switch (this.opType) {
            case 5: {
                sql = "- " + this.left.getSQL();
                break;
            }
            case 0: {
                sql = this.left.getSQL() + " || " + this.right.getSQL();
                break;
            }
            case 1: {
                sql = this.left.getSQL() + " + " + this.right.getSQL();
                break;
            }
            case 2: {
                sql = this.left.getSQL() + " - " + this.right.getSQL();
                break;
            }
            case 3: {
                sql = this.left.getSQL() + " * " + this.right.getSQL();
                break;
            }
            case 4: {
                sql = this.left.getSQL() + " / " + this.right.getSQL();
                break;
            }
            default: {
                throw Message.getInternalError("opType=" + this.opType);
            }
        }
        return "(" + sql + ")";
    }

    @Override
    public void buildColList(List<ExpressionColumn> r) {
        this.left.buildColList(r);
        this.right.buildColList(r);
    }
}

