/*
 * Decompiled with CFR 0.152.
 */
package tim.sql.h2parser.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import tim.sql.h2parser.value.Value;

public class ValueBoolean
extends Value {
    public static final int PRECISION = 1;
    public static final int DISPLAY_SIZE = 5;
    private static final ValueBoolean TRUE = new ValueBoolean(true);
    private static final ValueBoolean FALSE = new ValueBoolean(false);
    private final Boolean value;

    private ValueBoolean(boolean value) {
        this.value = Boolean.valueOf("" + value);
    }

    public int getType() {
        return 1;
    }

    @Override
    public String getSQL() {
        return this.getString();
    }

    public String getString() {
        return this.value != false ? "TRUE" : "FALSE";
    }

    public Value negate() {
        return this.value != false ? FALSE : TRUE;
    }

    public Boolean getBoolean() {
        return this.value;
    }

    public long getPrecision() {
        return 1L;
    }

    public int hashCode() {
        return this.value != false ? 1 : 0;
    }

    public Object getObject() {
        return this.value;
    }

    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setBoolean(parameterIndex, this.value);
    }

    public static ValueBoolean get(boolean b) {
        return b ? TRUE : FALSE;
    }

    public int getDisplaySize() {
        return 5;
    }

    public boolean equals(Object other) {
        return this == other;
    }
}

