/*
 * Decompiled with CFR 0.152.
 */
package tim.sql.h2parser.value;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import tim.sql.h2parser.value.Value;

public class ValueDecimal
extends Value {
    static final int DEFAULT_PRECISION = 65535;
    static final int DEFAULT_SCALE = Short.MAX_VALUE;
    static final int DEFAULT_DISPLAY_SIZE = 65535;
    private static final int DIVIDE_SCALE_ADD = 25;
    private static final BigDecimal DEC_ZERO = new BigDecimal("0");
    private static final BigDecimal DEC_ONE = new BigDecimal("1");
    private static final ValueDecimal ZERO = new ValueDecimal(DEC_ZERO);
    private static final ValueDecimal ONE = new ValueDecimal(DEC_ONE);
    private final BigDecimal value;
    private String valueString;
    private int precision;

    private ValueDecimal(BigDecimal value) {
        this.value = value;
    }

    public Value add(Value v) {
        ValueDecimal dec = (ValueDecimal)v;
        return ValueDecimal.get(this.value.add(dec.value));
    }

    public Value subtract(Value v) {
        ValueDecimal dec = (ValueDecimal)v;
        return ValueDecimal.get(this.value.subtract(dec.value));
    }

    public Value negate() {
        return ValueDecimal.get(this.value.negate());
    }

    public Value multiply(Value v) {
        ValueDecimal dec = (ValueDecimal)v;
        return ValueDecimal.get(this.value.multiply(dec.value));
    }

    @Override
    public String getSQL() {
        return this.getString();
    }

    public int getType() {
        return 6;
    }

    public int getSignum() {
        return this.value.signum();
    }

    public BigDecimal getBigDecimal() {
        return this.value;
    }

    public String getString() {
        if (this.valueString == null) {
            this.valueString = this.value.toString();
        }
        return this.valueString;
    }

    public long getPrecision() {
        if (this.precision == 0) {
            this.precision = this.value.unscaledValue().abs().toString().length();
        }
        return this.precision;
    }

    public boolean checkPrecision(long precision) {
        if (precision == 65535L) {
            return true;
        }
        return this.getPrecision() <= precision;
    }

    public int getScale() {
        return this.value.scale();
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public Object getObject() {
        return this.value;
    }

    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setBigDecimal(parameterIndex, this.value);
    }

    public static ValueDecimal get(BigDecimal dec) {
        if (DEC_ZERO.equals(dec)) {
            return ZERO;
        }
        if (DEC_ONE.equals(dec)) {
            return ONE;
        }
        return new ValueDecimal(dec);
    }

    public boolean equals(Object other) {
        return other instanceof ValueDecimal && this.value.equals(((ValueDecimal)other).value);
    }

    public int getMemory() {
        return this.getString().length() * 3 + 120;
    }
}

