/*
 * Decompiled with CFR 0.152.
 */
package tim.sql.h2parser.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import tim.sql.h2parser.value.Value;

public class ValueInt
extends Value {
    public static final int PRECISION = 10;
    public static final int DISPLAY_SIZE = 11;
    private static final int STATIC_SIZE = 100;
    private static final int DYNAMIC_SIZE = 256;
    private static ValueInt[] staticCache = new ValueInt[100];
    private static ValueInt[] dynamicCache = new ValueInt[256];
    private final int value;

    private ValueInt(int value) {
        this.value = value;
    }

    public static ValueInt get(int i) {
        if (i >= 0 && i < 100) {
            return staticCache[i];
        }
        ValueInt v = dynamicCache[i & 0xFF];
        if (v == null || v.value != i) {
            ValueInt.dynamicCache[i & 0xFF] = v = new ValueInt(i);
        }
        return v;
    }

    public int getSignum() {
        return this.value == 0 ? 0 : (this.value < 0 ? -1 : 1);
    }

    @Override
    public String getSQL() {
        return this.getString();
    }

    public int getType() {
        return 4;
    }

    public int getInt() {
        return this.value;
    }

    public String getString() {
        return String.valueOf(this.value);
    }

    public long getPrecision() {
        return 10L;
    }

    public int hashCode() {
        return this.value;
    }

    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setInt(parameterIndex, this.value);
    }

    public int getDisplaySize() {
        return 11;
    }

    public boolean equals(Object other) {
        return other instanceof ValueInt && this.value == ((ValueInt)other).value;
    }

    static {
        for (int i = 0; i < 100; ++i) {
            ValueInt.staticCache[i] = new ValueInt(i);
        }
    }
}

