package tim.sql.h2parser;

import java.util.List;

import tim.sql.h2parser.expr.*;

public class TableFilter {
	public Table table;
	String alias;
	TableFilter join;
	Expression joinOn;
	String joinType;

	
	public TableFilter(Table table, String alias) {
		this.table = table;
		this.alias = alias;
	}

	public void setAlias(String alias) {
		this.alias = alias;
	}

	public void addJoin(TableFilter filter, String joinType, Expression on) {
        if (join == null) {
            this.join = filter;
            this.joinOn = on;
    		this.joinType = joinType;
        } else {
            join.addJoin(filter, joinType, on);
        }
	}

	public String getSQL() {
		String r = "";
		TableFilter prev = null;
		TableFilter tf = this;
		while(tf!=null){
			if(prev==null){
				r+=  tf.table.getSQL();
				if(tf.alias!=null) r+= " AS " + tf.alias;
			}else{
				r+= prev.joinType+" JOIN "+tf.table.getSQL();
				if(tf.alias!=null) r+= " AS " + tf.alias;
				r+= " ON "+prev.joinOn.getSQL();
			}
			r+="\n";
			prev = tf;
			tf = prev.join;
		}
		return r;
	}

	public TableFilter getJoin() { return join; }
	public String getAlias(){ return alias; }

	public void buildColList(List<ExpressionColumn> r) {
		if(joinOn!=null) joinOn.buildColList(r);
		if(join!=null) join.buildColList(r);
	}
}
