package tim.sql.h2parser.dml;

import java.util.*;



import tim.sql.h2parser.*;
import tim.sql.h2parser.expr.*;

public class Select extends Query implements ColumnScope {

	private boolean distinct = false;
	List<Expression> expressions;     // COLS
	Expression condition; // WHERE
	private boolean isGroupQuery;
	private List<SelectOrderBy> orderList;
	private List<Expression> group;
	Expression having;
	Expression limit;
	Expression offset;

	private TableFilter topTableFilter;

	public Select(Object session) {}


	public void setExpressions(List expressions) {
		this.expressions = expressions;
	}

	public void addCondition(Expression condition) {
		this.condition = condition;
	}
	
    public void setOrder(List order) {
        orderList = order;
    }
	/**
	 * Called if this query contains aggregate functions.
	 */
	public void setGroupQuery() {
		isGroupQuery = true;
	}

	public void setGroupBy(List group) {
		this.group = group;
	}

	public void setHaving(Expression having) {
		this.having = having;
	}

	public void setLimit(Expression limit) {
		this.limit = limit;

	}

	public void setOffset(Expression offset) {
		this.offset = offset;
	}


	public void setTableFilter(TableFilter top) {
		this.topTableFilter = top;
	}


	public String getSQL() {
		// can not use the field sqlStatement because the parameter
		// indexes may be incorrect: ? may be in fact ?2 for a subquery
		// but indexes may be set manually as well
		StringBuffer buff = new StringBuffer();
		Expression[] exprList = new Expression[expressions.size()];
		expressions.toArray(exprList);
		buff.append("SELECT ");
		if (distinct) {
			buff.append("DISTINCT ");
		}
		for (int i = 0; i < exprList.length; i++) {
			if (i > 0) {
				buff.append(", ");
			}
			Expression expr = exprList[i];
			buff.append(expr.getSQL());
		}
		buff.append("\nFROM ");
		buff.append(topTableFilter.getSQL());

		if (condition != null) {
			buff.append("\nWHERE " + StringUtils.unEnclose(condition.getSQL()));
		}
		if (group != null) {
			buff.append("\nGROUP BY ");
			for (int i = 0; i < group.size(); i++) {
				Expression g = (Expression) group.get(i);
				if (i > 0) {
					buff.append(", ");
				}
				buff.append(StringUtils.unEnclose(g.getSQL()));
			}
		}
		if (having != null) {
			// could be set in addGlobalCondition
			// in this case the query is not run directly, just getPlanSQL is
			// called
			Expression h = having;
			buff.append("\nHAVING " + StringUtils.unEnclose(h.getSQL()));
		} 
		/*
		if (sort != null) {
			buff.append("\nORDER BY ");
			buff.append(sort.getSQL(exprList, visibleColumnCount));
		}*/
		if (orderList != null) {
			buff.append("\nORDER BY ");
			for (int i = 0; i < orderList.size(); i++) {
				if (i > 0) {
					buff.append(", ");
				}
				SelectOrderBy o = (SelectOrderBy) orderList.get(i);
				buff.append(StringUtils.unEnclose(o.getSQL()));
			}            
		}
		if (limit != null) {
			buff.append("\nLIMIT ");
			buff.append(StringUtils.unEnclose(limit.getSQL()));
			if (offset != null) {
				buff.append(" OFFSET ");
				buff.append(StringUtils.unEnclose(offset.getSQL()));
			}
		}
		return buff.toString();
	}

	public void listScopes(List<ColumnScope> r) {
		TableFilter tf = topTableFilter;
		while(tf!=null){
			if(tf.table instanceof TableView){
				((TableView)tf.table).query.listScopes(r);
			}
			tf = tf.getJoin();
		}
		r.add(this);
	}


	@Override
	public Iterable<ExpressionColumn> listColumns() {
		List<ExpressionColumn> r = new LinkedList();
		for(Expression expr: expressions){
			expr.buildColList(r);
		}
		topTableFilter.buildColList(r);
		if(condition!=null)condition.buildColList(r);
		if(having!=null)having.buildColList(r);
		if(limit!=null)limit.buildColList(r);
		if(offset!=null)offset.buildColList(r);
		if(group!=null){
			for(Expression expr: group){
				expr.buildColList(r);
			}
		}
		if(orderList!=null){
			for(SelectOrderBy sob: orderList) sob.buildColList(r);
		}
		return r;
	}


	public Iterable<TableFilter> listTableFilters() {
		List<TableFilter> r = new LinkedList();
		TableFilter tf = topTableFilter;
		while(tf!=null){
			r.add(tf);
			tf = tf.getJoin();
		}
		return r;
	}
}
