/*
 * Copyright 2004-2008 H2 Group. Multiple-Licensed under the H2 License, 
 * Version 1.0, and under the Eclipse Public License, Version 1.0
 * (http://h2database.com/html/license.html).
 * Initial Developer: H2 Group
 */
package tim.sql.h2parser.expr;

import java.util.List;


/**
 * Pattern matching comparison expression: WHERE NAME LIKE ?
 */
public class CompareLike extends Condition {
    
    //private static final int MATCH = 0, ONE = 1, ANY = 2;
    
    private final boolean regexp;
    private Expression left;
    private Expression right;
    private Expression escape;


    public CompareLike(Expression left, Expression right, Expression escape, boolean regexp) {
        this.regexp = regexp;
        this.left = left;
        this.right = right;
        this.escape = escape;
    }

    public String getSQL() {
        String sql;
        if (regexp) {
            sql = left.getSQL() + " REGEXP " + right.getSQL();
        } else {
            sql = left.getSQL() + " LIKE " + right.getSQL();
            if (escape != null) {
                sql += " ESCAPE " + escape.getSQL();
            }
        }
        return "(" + sql + ")";
    }
    
	public void buildColList(List<ExpressionColumn> r){
		left.buildColList(r);
		right.buildColList(r);
		escape.buildColList(r);
	}
}
