/*
 * Copyright 2004-2008 H2 Group. Multiple-Licensed under the H2 License, 
 * Version 1.0, and under the Eclipse Public License, Version 1.0
 * (http://h2database.com/html/license.html).
 * Initial Developer: H2 Group
 */
package tim.sql.h2parser.expr;

import java.util.List;

import tim.sql.h2parser.dml.Query;

/**
 * An 'exists' condition as in WHERE EXISTS(SELECT ...)
 */
public class ConditionExists extends Condition {

    private final Query query;

    public ConditionExists(Query query) {
        this.query = query;
    }

    public String getSQL() {
        StringBuffer buff = new StringBuffer();
        buff.append("EXISTS(");
        buff.append(query.getSQL());
        buff.append(")");
        return buff.toString();
    }
    
	public void buildColList(List<ExpressionColumn> r){}
}
