package tim.sql.h2parser.expr;

import java.util.List;

public class ExpressionColumn extends Expression {
	final String schemaName;
	final public String tableAlias;
	public String columnName;
	public ExpressionColumn(String schemaName, String tableAlias, String columnName) {
		this.schemaName = schemaName;
		this.tableAlias = tableAlias;
		this.columnName = columnName;
	}
	
	public String getSQL() {
		String r = "";
		if(schemaName!=null) r+=schemaName+".";
		if(tableAlias!=null) r+=tableAlias+".";
		return r+"\""+columnName+"\"";
	}
	
	public void buildColList(List<ExpressionColumn> r){
		r.add(this);
	}

}
