/*
 * Copyright 2004-2008 H2 Group. Multiple-Licensed under the H2 License, 
 * Version 1.0, and under the Eclipse Public License, Version 1.0
 * (http://h2database.com/html/license.html).
 * Initial Developer: H2 Group
 */
package tim.sql.h2parser.expr;

import java.util.ArrayList;
import java.util.List;


/**
 * This class implements most built-in functions of this database.
 */
public class Function extends Expression {

	final String name;
	final List<Expression> params = new ArrayList();
	public Function(String name) {
		this.name = name;
	}

	public String getSQL() {
		String r = name +"(";
		for(int i=0;i<params.size();i++){
			if(i>0)r+=",";
			r+=params.get(i).getSQL();
		}
		r+=")";
		return r;
	}
	public void setParameter(int i, Expression readExpression) {
		params.add(readExpression);
	}
   
	public void buildColList(List<ExpressionColumn> r){
		for(Expression e: params){
			e.buildColList(r);
		}
	}
}
