/*
 * Copyright 2004-2008 H2 Group. Multiple-Licensed under the H2 License, 
 * Version 1.0, and under the Eclipse Public License, Version 1.0
 * (http://h2database.com/html/license.html).
 * Initial Developer: H2 Group
 */
package tim.sql.h2parser.expr;

import java.util.List;

import tim.sql.h2parser.value.Value;
import tim.sql.h2parser.value.ValueBoolean;


/**
 * An expression representing a constant value.
 */
public class ValueExpression extends Expression {

	static public ValueExpression TRUE = new ValueExpression(ValueBoolean.get(true));
	static public ValueExpression FALSE = new ValueExpression(ValueBoolean.get(false));
	static public ValueExpression NULL = new ValueExpression(null);
	
    private Value value;

    public ValueExpression(Value value) {
        this.value = value;
    }


    public String getSQL() {
        return ""+value.getSQL();
    }

	public void buildColList(List<ExpressionColumn> r){}
}
