/*
 * Copyright 2004-2008 H2 Group. Multiple-Licensed under the H2 License, 
 * Version 1.0, and under the Eclipse Public License, Version 1.0
 * (http://h2database.com/html/license.html).
 * Initial Developer: H2 Group
 */
package tim.sql.h2parser.value;


/**
 * This is the base class for all value classes.
 * It provides conversion and comparison methods.
 */
public abstract class Value {

    /**
     * The data type is unknown at this time.
     */
    public static final int UNKNOWN = -1;
    
    /**
     * The value type for NULL.
     */
    public static final int NULL = 0;
    
    /**
     * The value type for BOOLEAN values.
     */
    public static final int BOOLEAN = 1;
    
    /**
     * The value type for BYTE values.
     */
    public static final int BYTE = 2;
    
    /**
     * The value type for SHORT values.
     */
    public static final int SHORT = 3;
    
    /**
     * The value type for INT values.
     */
    public static final int INT = 4;
    
    /**
     * The value type for LONG values.
     */
    public static final int LONG = 5;
    
    /**
     * The value type for DECIMAL values.
     */
    public static final int DECIMAL = 6;
    
    /**
     * The value type for DOUBLE values.
     */
    public static final int DOUBLE = 7;
    
    /**
     * The value type for FLOAT values.
     */
    public static final int FLOAT = 8;
    
    /**
     * The value type for INT values.
     */
    public static final int TIME = 9;
    
    /**
     * The value type for DATE values.
     */
    public static final int DATE = 10;
    
    /**
     * The value type for TIMESTAMP values.
     */
    public static final int TIMESTAMP = 11;
    
    /**
     * The value type for BYTES values.
     */
    public static final int BYTES = 12;
    
    /**
     * The value type for STRING values.
     */
    public static final int STRING = 13;
    
    /**
     * The value type for case insensitive STRING values.
     */
    public static final int STRING_IGNORECASE = 14;
    
    /**
     * The value type for BLOB values.
     */
    public static final int BLOB = 15;
    
    /**
     * The value type for CLOB values.
     */
    public static final int CLOB = 16;
    
    /**
     * The value type for ARRAY values.
     */
    public static final int ARRAY = 17;
    
    /**
     * The value type for RESULT_SET values.
     */
    public static final int RESULT_SET = 18;
    /**
     * The value type for JAVA_OBJECT values.
     */
    public static final int JAVA_OBJECT = 19;
    
    /**
     * The value type for UUID values.
     */
    public static final int UUID = 20;
    
    /**
     * The value type for string values with a fixed size.
     */
    public static final int STRING_FIXED = 21;

	abstract public String getSQL();
   
}
