/*
 * Copyright 2004-2008 H2 Group. Multiple-Licensed under the H2 License, 
 * Version 1.0, and under the Eclipse Public License, Version 1.0
 * (http://h2database.com/html/license.html).
 * Initial Developer: H2 Group
 */
package tim.sql.h2parser.value;


/**
 * Implementation of the VARCHAR data type.
 */
public class ValueString extends ValueStringBase {

    private static final ValueString EMPTY = new ValueString("");

    protected ValueString(String value) {
        super(value);
    }

    public int getType() {
        return Value.STRING;
    }

    public boolean equals(Object other) {
        return other instanceof ValueStringBase && value.equals(((ValueStringBase) other).value);
    }

    public int hashCode() {
        // TODO hash performance: could build a quicker hash 
        // by hashing the size and a few characters
        return value.hashCode();

        // proposed code:
//        private int hash = 0;
//
//        public int hashCode() {
//            int h = hash;
//            if (h == 0) {
//                String s = value;
//                int l = s.length();
//                if (l > 0) {
//                    if (l < 16)
//                        h = s.hashCode();
//                    else {
//                        h = l;
//                        for (int i = 1; i <= l; i <<= 1)
//                            h = 31 * 
//                                (31 * h + s.charAt(i - 1)) + 
//                                s.charAt(l - i);
//                    }
//                    hash = h;
//                }
//            }
//            return h;
//        }

    }


    /**
     * Get or create a string value for the given string.
     * 
     * @param s the string
     * @return the value
     */
    public static ValueString get(String s) {
        if (s.length() == 0) {
            return EMPTY;
        }
        return new ValueString(s);
    }

}
