/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna;

import com.googlecode.lanterna.SGR;
import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.graphics.StyleSet;
import com.googlecode.lanterna.screen.TabBehaviour;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class TerminalTextUtils {
    private TerminalTextUtils() {
    }

    public static String getANSIControlSequenceAt(String string, int index) {
        int len = TerminalTextUtils.getANSIControlSequenceLength(string, index);
        return len == 0 ? null : string.substring(index, index + len);
    }

    public static int getANSIControlSequenceLength(String string, int index) {
        int len = 0;
        int restlen = string.length() - index;
        if (restlen >= 3) {
            char esc = string.charAt(index);
            char bracket = string.charAt(index + 1);
            if (esc == '\u001b' && bracket == '[') {
                len = 3;
                int i = 2;
                while (i < restlen) {
                    char ch = string.charAt(i + index);
                    if ((ch < '0' || ch > '9') && ch != ';') break;
                    ++len;
                    ++i;
                }
                if (len > restlen) {
                    len = 0;
                }
            }
        }
        return len;
    }

    public static boolean isCharCJK(char c) {
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
        return unicodeBlock == Character.UnicodeBlock.HIRAGANA || unicodeBlock == Character.UnicodeBlock.KATAKANA || unicodeBlock == Character.UnicodeBlock.KATAKANA_PHONETIC_EXTENSIONS || unicodeBlock == Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO || unicodeBlock == Character.UnicodeBlock.HANGUL_JAMO || unicodeBlock == Character.UnicodeBlock.HANGUL_SYLLABLES || unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || unicodeBlock == Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS || unicodeBlock == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || unicodeBlock == Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT || unicodeBlock == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || unicodeBlock == Character.UnicodeBlock.ENCLOSED_CJK_LETTERS_AND_MONTHS || unicodeBlock == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS && c < '\uff61';
    }

    public static boolean isCharThai(char c) {
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
        return unicodeBlock == Character.UnicodeBlock.THAI;
    }

    public static boolean isCharDoubleWidth(char c) {
        return TerminalTextUtils.isCharCJK(c);
    }

    public static boolean isControlCharacter(char c) {
        return c < ' ' || c == '\u007f';
    }

    public static boolean isPrintableCharacter(char c) {
        return !TerminalTextUtils.isControlCharacter(c) || c == '\t' || c == '\n' || c == '\b';
    }

    public static int getColumnWidth(String s) {
        return TerminalTextUtils.getColumnIndex(s, s.length());
    }

    public static int getColumnIndex(String s, int stringCharacterIndex) throws StringIndexOutOfBoundsException {
        return TerminalTextUtils.getColumnIndex(s, stringCharacterIndex, TabBehaviour.CONVERT_TO_FOUR_SPACES, -1);
    }

    public static int getColumnIndex(String s, int stringCharacterIndex, TabBehaviour tabBehaviour, int firstCharacterColumnPosition) throws StringIndexOutOfBoundsException {
        int index = 0;
        int i = 0;
        while (i < stringCharacterIndex) {
            if (s.charAt(i) == '\t') {
                index += tabBehaviour.getTabReplacement(firstCharacterColumnPosition).length();
            } else {
                if (TerminalTextUtils.isCharCJK(s.charAt(i))) {
                    ++index;
                }
                ++index;
            }
            ++i;
        }
        return index;
    }

    public static int getStringCharacterIndex(String s, int columnIndex) {
        int index = 0;
        int counter = 0;
        while (counter < columnIndex) {
            if (TerminalTextUtils.isCharCJK(s.charAt(index++)) && ++counter == columnIndex) {
                return index - 1;
            }
            ++counter;
        }
        return index;
    }

    public static String fitString(String string, int availableColumnSpace) {
        return TerminalTextUtils.fitString(string, 0, availableColumnSpace);
    }

    public static String fitString(String string, int fromColumn, int availableColumnSpace) {
        char c;
        if (availableColumnSpace <= 0) {
            return "";
        }
        StringBuilder bob = new StringBuilder();
        int column = 0;
        int index = 0;
        while (index < string.length() && column < fromColumn) {
            column += TerminalTextUtils.isCharCJK(c = string.charAt(index++)) ? 2 : 1;
        }
        if (column > fromColumn) {
            bob.append(" ");
            --availableColumnSpace;
        }
        while (availableColumnSpace > 0 && index < string.length()) {
            if ((availableColumnSpace -= TerminalTextUtils.isCharCJK(c = string.charAt(index++)) ? 2 : 1) < 0) {
                bob.append(' ');
                continue;
            }
            bob.append(c);
        }
        return bob.toString();
    }

    public static List<String> getWordWrappedText(int maxWidth, String ... lines) {
        if (maxWidth <= 0) {
            return Arrays.asList(lines);
        }
        ArrayList<String> result = new ArrayList<String>();
        LinkedList<String> linesToBeWrapped = new LinkedList<String>(Arrays.asList(lines));
        while (!linesToBeWrapped.isEmpty()) {
            int characterIndexMax;
            String row = linesToBeWrapped.removeFirst();
            int rowWidth = TerminalTextUtils.getColumnWidth(row);
            if (rowWidth <= maxWidth) {
                result.add(row);
                continue;
            }
            int characterIndex = characterIndexMax = TerminalTextUtils.getStringCharacterIndex(row, maxWidth);
            while (characterIndex >= 0 && !Character.isSpaceChar(row.charAt(characterIndex)) && !TerminalTextUtils.isCharCJK(row.charAt(characterIndex))) {
                --characterIndex;
            }
            if (characterIndex >= 0 && characterIndex < characterIndexMax && TerminalTextUtils.isCharCJK(row.charAt(characterIndex))) {
                ++characterIndex;
            }
            if (characterIndex < 0) {
                characterIndex = Math.max(characterIndexMax, 1);
                result.add(row.substring(0, characterIndex));
                linesToBeWrapped.addFirst(row.substring(characterIndex));
                continue;
            }
            characterIndex = Math.max(characterIndex, 1);
            result.add(row.substring(0, characterIndex));
            while (characterIndex < row.length() && Character.isSpaceChar(row.charAt(characterIndex))) {
                ++characterIndex;
            }
            if (characterIndex >= row.length()) continue;
            linesToBeWrapped.addFirst(row.substring(characterIndex));
        }
        return result;
    }

    private static Integer[] mapCodesToIntegerArray(String[] codes) {
        Integer[] result = new Integer[codes.length];
        int i = 0;
        while (i < result.length) {
            if (codes[i].isEmpty()) {
                result[i] = 0;
            } else {
                try {
                    result[i] = Integer.parseInt(codes[i]);
                }
                catch (NumberFormatException ignored) {
                    throw new IllegalArgumentException("Unknown CSI code " + codes[i]);
                }
            }
            ++i;
        }
        return result;
    }

    public static void updateModifiersFromCSICode(String controlSequence, StyleSet<?> target, StyleSet<?> original) {
        char controlCodeType = controlSequence.charAt(controlSequence.length() - 1);
        controlSequence = controlSequence.substring(2, controlSequence.length() - 1);
        Integer[] codes = TerminalTextUtils.mapCodesToIntegerArray(controlSequence.split(";"));
        TextColor.ANSI[] palette = TextColor.ANSI.values();
        if (controlCodeType == 'm') {
            int i = 0;
            while (i < codes.length) {
                int code = codes[i];
                switch (code) {
                    case 0: {
                        target.setStyleFrom(original);
                        break;
                    }
                    case 1: {
                        target.enableModifiers(SGR.BOLD);
                        break;
                    }
                    case 3: {
                        target.enableModifiers(SGR.ITALIC);
                        break;
                    }
                    case 4: {
                        target.enableModifiers(SGR.UNDERLINE);
                        break;
                    }
                    case 5: {
                        target.enableModifiers(SGR.BLINK);
                        break;
                    }
                    case 7: {
                        target.enableModifiers(SGR.REVERSE);
                        break;
                    }
                    case 21: 
                    case 22: {
                        target.disableModifiers(SGR.BOLD);
                        break;
                    }
                    case 23: {
                        target.disableModifiers(SGR.ITALIC);
                        break;
                    }
                    case 24: {
                        target.disableModifiers(SGR.UNDERLINE);
                        break;
                    }
                    case 25: {
                        target.disableModifiers(SGR.BLINK);
                        break;
                    }
                    case 27: {
                        target.disableModifiers(SGR.REVERSE);
                        break;
                    }
                    case 38: {
                        if (i + 2 < codes.length && codes[i + 1] == 5) {
                            target.setForegroundColor(new TextColor.Indexed(codes[i + 2]));
                            i += 2;
                            break;
                        }
                        if (i + 4 >= codes.length || codes[i + 1] != 2) break;
                        target.setForegroundColor(new TextColor.RGB(codes[i + 2], codes[i + 3], codes[i + 4]));
                        i += 4;
                        break;
                    }
                    case 39: {
                        target.setForegroundColor(original.getForegroundColor());
                        break;
                    }
                    case 48: {
                        if (i + 2 < codes.length && codes[i + 1] == 5) {
                            target.setBackgroundColor(new TextColor.Indexed(codes[i + 2]));
                            i += 2;
                            break;
                        }
                        if (i + 4 >= codes.length || codes[i + 1] != 2) break;
                        target.setBackgroundColor(new TextColor.RGB(codes[i + 2], codes[i + 3], codes[i + 4]));
                        i += 4;
                        break;
                    }
                    case 49: {
                        target.setBackgroundColor(original.getBackgroundColor());
                        break;
                    }
                    default: {
                        if (code >= 30 && code <= 37) {
                            target.setForegroundColor(palette[code - 30]);
                            break;
                        }
                        if (code < 40 || code > 47) break;
                        target.setBackgroundColor(palette[code - 40]);
                    }
                }
                ++i;
            }
        }
    }
}

