/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna;

import com.googlecode.lanterna.SGR;
import com.googlecode.lanterna.TerminalTextUtils;
import com.googlecode.lanterna.TextColor;
import java.io.Serializable;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;

public class TextCharacter
implements Serializable {
    public static final TextCharacter DEFAULT_CHARACTER = new TextCharacter(' ', (TextColor)TextColor.ANSI.DEFAULT, (TextColor)TextColor.ANSI.DEFAULT, new SGR[0]);
    private final String character;
    private final TextColor foregroundColor;
    private final TextColor backgroundColor;
    private final EnumSet<SGR> modifiers;

    private static EnumSet<SGR> toEnumSet(SGR ... modifiers) {
        if (modifiers.length == 0) {
            return EnumSet.noneOf(SGR.class);
        }
        return EnumSet.copyOf(Arrays.asList(modifiers));
    }

    public static TextCharacter[] fromCharacter(char c) {
        return TextCharacter.fromString(Character.toString(c));
    }

    public static TextCharacter[] fromString(String string) {
        return TextCharacter.fromString(string, (TextColor)TextColor.ANSI.DEFAULT, (TextColor)TextColor.ANSI.DEFAULT, new SGR[0]);
    }

    public static TextCharacter[] fromCharacter(char c, TextColor foregroundColor, TextColor backgroundColor, SGR ... modifiers) {
        return TextCharacter.fromString(Character.toString(c), foregroundColor, backgroundColor, modifiers);
    }

    public static TextCharacter[] fromString(String string, TextColor foregroundColor, TextColor backgroundColor, SGR ... modifiers) {
        return TextCharacter.fromString(string, foregroundColor, backgroundColor, TextCharacter.toEnumSet(modifiers));
    }

    public static TextCharacter[] fromString(String string, TextColor foregroundColor, TextColor backgroundColor, EnumSet<SGR> modifiers) {
        BreakIterator breakIterator = BreakIterator.getCharacterInstance();
        breakIterator.setText(string);
        ArrayList<TextCharacter> result = new ArrayList<TextCharacter>();
        int begin = 0;
        int end = 0;
        while ((end = breakIterator.next()) != -1) {
            result.add(new TextCharacter(string.substring(begin, end), foregroundColor, backgroundColor, modifiers));
            begin = breakIterator.current();
        }
        return result.toArray(new TextCharacter[0]);
    }

    @Deprecated
    public TextCharacter(char character) {
        this(character, (TextColor)TextColor.ANSI.DEFAULT, (TextColor)TextColor.ANSI.DEFAULT, new SGR[0]);
    }

    @Deprecated
    public TextCharacter(TextCharacter character) {
        this(character.getCharacterString(), character.getForegroundColor(), character.getBackgroundColor(), EnumSet.copyOf(character.getModifiers()));
    }

    @Deprecated
    public TextCharacter(char character, TextColor foregroundColor, TextColor backgroundColor, SGR ... styles) {
        this(character, foregroundColor, backgroundColor, TextCharacter.toEnumSet(styles));
    }

    @Deprecated
    public TextCharacter(char character, TextColor foregroundColor, TextColor backgroundColor, EnumSet<SGR> modifiers) {
        this(Character.toString(character), foregroundColor, backgroundColor, modifiers);
    }

    private TextCharacter(String character, TextColor foregroundColor, TextColor backgroundColor, EnumSet<SGR> modifiers) {
        if (character.isEmpty()) {
            throw new IllegalArgumentException("Cannot create TextCharacter from an empty string");
        }
        this.validateSingleCharacter(character);
        this.character = character.intern();
        char firstCharacter = character.charAt(0);
        if (TerminalTextUtils.isControlCharacter(firstCharacter) && firstCharacter != '\t') {
            throw new IllegalArgumentException("Cannot create a TextCharacter from a control character (0x" + Integer.toHexString(firstCharacter) + ")");
        }
        if (foregroundColor == null) {
            foregroundColor = TextColor.ANSI.DEFAULT;
        }
        if (backgroundColor == null) {
            backgroundColor = TextColor.ANSI.DEFAULT;
        }
        this.foregroundColor = foregroundColor;
        this.backgroundColor = backgroundColor;
        this.modifiers = EnumSet.copyOf(modifiers);
    }

    private void validateSingleCharacter(String character) {
        BreakIterator breakIterator = BreakIterator.getCharacterInstance();
        breakIterator.setText(character);
        String firstCharacter = null;
        int begin = 0;
        int end = 0;
        while ((end = breakIterator.next()) != -1) {
            if (firstCharacter != null) {
                throw new IllegalArgumentException("Invalid String for TextCharacter, can only have one logical character");
            }
            firstCharacter = character.substring(begin, end);
            begin = breakIterator.current();
        }
    }

    public boolean is(char otherCharacter) {
        return otherCharacter == this.character.charAt(0) && this.character.length() == 1;
    }

    @Deprecated
    public char getCharacter() {
        return this.character.charAt(0);
    }

    public String getCharacterString() {
        return this.character;
    }

    public TextColor getForegroundColor() {
        return this.foregroundColor;
    }

    public TextColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public EnumSet<SGR> getModifiers() {
        return EnumSet.copyOf(this.modifiers);
    }

    public boolean isBold() {
        return this.modifiers.contains((Object)SGR.BOLD);
    }

    public boolean isReversed() {
        return this.modifiers.contains((Object)SGR.REVERSE);
    }

    public boolean isUnderlined() {
        return this.modifiers.contains((Object)SGR.UNDERLINE);
    }

    public boolean isBlinking() {
        return this.modifiers.contains((Object)SGR.BLINK);
    }

    public boolean isBordered() {
        return this.modifiers.contains((Object)SGR.BORDERED);
    }

    public boolean isCrossedOut() {
        return this.modifiers.contains((Object)SGR.CROSSED_OUT);
    }

    public boolean isItalic() {
        return this.modifiers.contains((Object)SGR.ITALIC);
    }

    public TextCharacter withCharacter(char character) {
        if (this.character.equals(Character.toString(character))) {
            return this;
        }
        return new TextCharacter(character, this.foregroundColor, this.backgroundColor, this.modifiers);
    }

    public TextCharacter withForegroundColor(TextColor foregroundColor) {
        if (this.foregroundColor == foregroundColor || this.foregroundColor.equals(foregroundColor)) {
            return this;
        }
        return new TextCharacter(this.character, foregroundColor, this.backgroundColor, this.modifiers);
    }

    public TextCharacter withBackgroundColor(TextColor backgroundColor) {
        if (this.backgroundColor == backgroundColor || this.backgroundColor.equals(backgroundColor)) {
            return this;
        }
        return new TextCharacter(this.character, this.foregroundColor, backgroundColor, this.modifiers);
    }

    public TextCharacter withModifiers(Collection<SGR> modifiers) {
        EnumSet<SGR> newSet = EnumSet.copyOf(modifiers);
        if (modifiers.equals(newSet)) {
            return this;
        }
        return new TextCharacter(this.character, this.foregroundColor, this.backgroundColor, newSet);
    }

    public TextCharacter withModifier(SGR modifier) {
        if (this.modifiers.contains((Object)modifier)) {
            return this;
        }
        EnumSet<SGR> newSet = EnumSet.copyOf(this.modifiers);
        newSet.add(modifier);
        return new TextCharacter(this.character, this.foregroundColor, this.backgroundColor, newSet);
    }

    public TextCharacter withoutModifier(SGR modifier) {
        if (!this.modifiers.contains((Object)modifier)) {
            return this;
        }
        EnumSet<SGR> newSet = EnumSet.copyOf(this.modifiers);
        newSet.remove((Object)modifier);
        return new TextCharacter(this.character, this.foregroundColor, this.backgroundColor, newSet);
    }

    public boolean isDoubleWidth() {
        return TerminalTextUtils.isCharDoubleWidth(this.character.charAt(0)) || this.character.length() > 1 && !TerminalTextUtils.isCharThai(this.character.charAt(0));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextCharacter other = (TextCharacter)obj;
        if (!Objects.equals(this.character, other.character)) {
            return false;
        }
        if (!Objects.equals(this.foregroundColor, other.foregroundColor)) {
            return false;
        }
        if (!Objects.equals(this.backgroundColor, other.backgroundColor)) {
            return false;
        }
        return Objects.equals(this.modifiers, other.modifiers);
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + this.character.hashCode();
        hash = 37 * hash + (this.foregroundColor != null ? this.foregroundColor.hashCode() : 0);
        hash = 37 * hash + (this.backgroundColor != null ? this.backgroundColor.hashCode() : 0);
        hash = 37 * hash + (this.modifiers != null ? this.modifiers.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "TextCharacter{character=" + this.character + ", foregroundColor=" + this.foregroundColor + ", backgroundColor=" + this.backgroundColor + ", modifiers=" + this.modifiers + '}';
    }
}

