/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna;

import java.awt.Color;
import java.io.Serializable;
import java.util.regex.Pattern;

public interface TextColor
extends Serializable {
    public byte[] getForegroundSGRSequence();

    public byte[] getBackgroundSGRSequence();

    public int getRed();

    public int getGreen();

    public int getBlue();

    @Deprecated
    public Color toColor();

    public static enum ANSI implements TextColor
    {
        BLACK(0, 0, 0, 0),
        RED(1, 170, 0, 0),
        GREEN(2, 0, 170, 0),
        YELLOW(3, 170, 85, 0),
        BLUE(4, 0, 0, 170),
        MAGENTA(5, 170, 0, 170),
        CYAN(6, 0, 170, 170),
        WHITE(7, 170, 170, 170),
        DEFAULT(9, 0, 0, 0),
        BLACK_BRIGHT(0, true, 85, 85, 85),
        RED_BRIGHT(1, true, 255, 85, 85),
        GREEN_BRIGHT(2, true, 85, 255, 85),
        YELLOW_BRIGHT(3, true, 255, 255, 85),
        BLUE_BRIGHT(4, true, 85, 85, 255),
        MAGENTA_BRIGHT(5, true, 255, 85, 255),
        CYAN_BRIGHT(6, true, 85, 255, 255),
        WHITE_BRIGHT(7, true, 255, 255, 255);

        private final boolean bright;
        private final int red;
        private final int green;
        private final int blue;
        private final byte[] foregroundSGR;
        private final byte[] backgroundSGR;

        private ANSI(int index, int red, int green, int blue) {
            this(index, false, red, green, blue);
        }

        private ANSI(int index, boolean bright, int red, int green, int blue) {
            this.bright = bright;
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.foregroundSGR = String.format("%d%d", bright ? 9 : 3, index).getBytes();
            this.backgroundSGR = String.format("%d%d", bright ? 10 : 4, index).getBytes();
        }

        @Override
        public byte[] getForegroundSGRSequence() {
            return (byte[])this.foregroundSGR.clone();
        }

        @Override
        public byte[] getBackgroundSGRSequence() {
            return (byte[])this.backgroundSGR.clone();
        }

        public boolean isBright() {
            return this.bright;
        }

        @Override
        public int getRed() {
            return this.red;
        }

        @Override
        public int getGreen() {
            return this.green;
        }

        @Override
        public int getBlue() {
            return this.blue;
        }

        @Override
        public Color toColor() {
            return new Color(this.getRed(), this.getGreen(), this.getBlue());
        }
    }

    public static class Factory {
        private static final Pattern INDEXED_COLOR = Pattern.compile("#[0-9]{1,3}");
        private static final Pattern RGB_COLOR = Pattern.compile("#[0-9a-fA-F]{6}");

        private Factory() {
        }

        public static TextColor fromString(String value) {
            if (value == null) {
                return null;
            }
            if (RGB_COLOR.matcher(value = value.trim()).matches()) {
                int r = Integer.parseInt(value.substring(1, 3), 16);
                int g = Integer.parseInt(value.substring(3, 5), 16);
                int b = Integer.parseInt(value.substring(5, 7), 16);
                return new RGB(r, g, b);
            }
            if (INDEXED_COLOR.matcher(value).matches()) {
                int index = Integer.parseInt(value.substring(1));
                return new Indexed(index);
            }
            try {
                return ANSI.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unknown color definition \"" + value + "\"", e);
            }
        }
    }

    public static class Indexed
    implements TextColor {
        private static final byte[][] COLOR_TABLE;
        private final int colorIndex;

        static {
            byte[][] byArrayArray = new byte[256][];
            byArrayArray[0] = new byte[3];
            byte[] byArray = new byte[3];
            byArray[0] = -86;
            byArrayArray[1] = byArray;
            byte[] byArray2 = new byte[3];
            byArray2[1] = -86;
            byArrayArray[2] = byArray2;
            byte[] byArray3 = new byte[3];
            byArray3[0] = -86;
            byArray3[1] = 85;
            byArrayArray[3] = byArray3;
            byte[] byArray4 = new byte[3];
            byArray4[2] = -86;
            byArrayArray[4] = byArray4;
            byte[] byArray5 = new byte[3];
            byArray5[0] = -86;
            byArray5[2] = -86;
            byArrayArray[5] = byArray5;
            byte[] byArray6 = new byte[3];
            byArray6[1] = -86;
            byArray6[2] = -86;
            byArrayArray[6] = byArray6;
            byArrayArray[7] = new byte[]{-86, -86, -86};
            byArrayArray[8] = new byte[]{85, 85, 85};
            byArrayArray[9] = new byte[]{-1, 85, 85};
            byArrayArray[10] = new byte[]{85, -1, 85};
            byArrayArray[11] = new byte[]{-1, -1, 85};
            byArrayArray[12] = new byte[]{85, 85, -1};
            byArrayArray[13] = new byte[]{-1, 85, -1};
            byArrayArray[14] = new byte[]{85, -1, -1};
            byArrayArray[15] = new byte[]{-1, -1, -1};
            byArrayArray[16] = new byte[3];
            byte[] byArray7 = new byte[3];
            byArray7[2] = 95;
            byArrayArray[17] = byArray7;
            byte[] byArray8 = new byte[3];
            byArray8[2] = -121;
            byArrayArray[18] = byArray8;
            byte[] byArray9 = new byte[3];
            byArray9[2] = -81;
            byArrayArray[19] = byArray9;
            byte[] byArray10 = new byte[3];
            byArray10[2] = -41;
            byArrayArray[20] = byArray10;
            byte[] byArray11 = new byte[3];
            byArray11[2] = -1;
            byArrayArray[21] = byArray11;
            byte[] byArray12 = new byte[3];
            byArray12[1] = 95;
            byArrayArray[22] = byArray12;
            byte[] byArray13 = new byte[3];
            byArray13[1] = 95;
            byArray13[2] = 95;
            byArrayArray[23] = byArray13;
            byte[] byArray14 = new byte[3];
            byArray14[1] = 95;
            byArray14[2] = -121;
            byArrayArray[24] = byArray14;
            byte[] byArray15 = new byte[3];
            byArray15[1] = 95;
            byArray15[2] = -81;
            byArrayArray[25] = byArray15;
            byte[] byArray16 = new byte[3];
            byArray16[1] = 95;
            byArray16[2] = -41;
            byArrayArray[26] = byArray16;
            byte[] byArray17 = new byte[3];
            byArray17[1] = 95;
            byArray17[2] = -1;
            byArrayArray[27] = byArray17;
            byte[] byArray18 = new byte[3];
            byArray18[1] = -121;
            byArrayArray[28] = byArray18;
            byte[] byArray19 = new byte[3];
            byArray19[1] = -121;
            byArray19[2] = 95;
            byArrayArray[29] = byArray19;
            byte[] byArray20 = new byte[3];
            byArray20[1] = -121;
            byArray20[2] = -121;
            byArrayArray[30] = byArray20;
            byte[] byArray21 = new byte[3];
            byArray21[1] = -121;
            byArray21[2] = -81;
            byArrayArray[31] = byArray21;
            byte[] byArray22 = new byte[3];
            byArray22[1] = -121;
            byArray22[2] = -41;
            byArrayArray[32] = byArray22;
            byte[] byArray23 = new byte[3];
            byArray23[1] = -121;
            byArray23[2] = -1;
            byArrayArray[33] = byArray23;
            byte[] byArray24 = new byte[3];
            byArray24[1] = -81;
            byArrayArray[34] = byArray24;
            byte[] byArray25 = new byte[3];
            byArray25[1] = -81;
            byArray25[2] = 95;
            byArrayArray[35] = byArray25;
            byte[] byArray26 = new byte[3];
            byArray26[1] = -81;
            byArray26[2] = -121;
            byArrayArray[36] = byArray26;
            byte[] byArray27 = new byte[3];
            byArray27[1] = -81;
            byArray27[2] = -81;
            byArrayArray[37] = byArray27;
            byte[] byArray28 = new byte[3];
            byArray28[1] = -81;
            byArray28[2] = -41;
            byArrayArray[38] = byArray28;
            byte[] byArray29 = new byte[3];
            byArray29[1] = -81;
            byArray29[2] = -1;
            byArrayArray[39] = byArray29;
            byte[] byArray30 = new byte[3];
            byArray30[1] = -41;
            byArrayArray[40] = byArray30;
            byte[] byArray31 = new byte[3];
            byArray31[1] = -41;
            byArray31[2] = 95;
            byArrayArray[41] = byArray31;
            byte[] byArray32 = new byte[3];
            byArray32[1] = -41;
            byArray32[2] = -121;
            byArrayArray[42] = byArray32;
            byte[] byArray33 = new byte[3];
            byArray33[1] = -41;
            byArray33[2] = -81;
            byArrayArray[43] = byArray33;
            byte[] byArray34 = new byte[3];
            byArray34[1] = -41;
            byArray34[2] = -41;
            byArrayArray[44] = byArray34;
            byte[] byArray35 = new byte[3];
            byArray35[1] = -41;
            byArray35[2] = -1;
            byArrayArray[45] = byArray35;
            byte[] byArray36 = new byte[3];
            byArray36[1] = -1;
            byArrayArray[46] = byArray36;
            byte[] byArray37 = new byte[3];
            byArray37[1] = -1;
            byArray37[2] = 95;
            byArrayArray[47] = byArray37;
            byte[] byArray38 = new byte[3];
            byArray38[1] = -1;
            byArray38[2] = -121;
            byArrayArray[48] = byArray38;
            byte[] byArray39 = new byte[3];
            byArray39[1] = -1;
            byArray39[2] = -81;
            byArrayArray[49] = byArray39;
            byte[] byArray40 = new byte[3];
            byArray40[1] = -1;
            byArray40[2] = -41;
            byArrayArray[50] = byArray40;
            byte[] byArray41 = new byte[3];
            byArray41[1] = -1;
            byArray41[2] = -1;
            byArrayArray[51] = byArray41;
            byte[] byArray42 = new byte[3];
            byArray42[0] = 95;
            byArrayArray[52] = byArray42;
            byte[] byArray43 = new byte[3];
            byArray43[0] = 95;
            byArray43[2] = 95;
            byArrayArray[53] = byArray43;
            byte[] byArray44 = new byte[3];
            byArray44[0] = 95;
            byArray44[2] = -121;
            byArrayArray[54] = byArray44;
            byte[] byArray45 = new byte[3];
            byArray45[0] = 95;
            byArray45[2] = -81;
            byArrayArray[55] = byArray45;
            byte[] byArray46 = new byte[3];
            byArray46[0] = 95;
            byArray46[2] = -41;
            byArrayArray[56] = byArray46;
            byte[] byArray47 = new byte[3];
            byArray47[0] = 95;
            byArray47[2] = -1;
            byArrayArray[57] = byArray47;
            byte[] byArray48 = new byte[3];
            byArray48[0] = 95;
            byArray48[1] = 95;
            byArrayArray[58] = byArray48;
            byArrayArray[59] = new byte[]{95, 95, 95};
            byArrayArray[60] = new byte[]{95, 95, -121};
            byArrayArray[61] = new byte[]{95, 95, -81};
            byArrayArray[62] = new byte[]{95, 95, -41};
            byArrayArray[63] = new byte[]{95, 95, -1};
            byte[] byArray49 = new byte[3];
            byArray49[0] = 95;
            byArray49[1] = -121;
            byArrayArray[64] = byArray49;
            byArrayArray[65] = new byte[]{95, -121, 95};
            byArrayArray[66] = new byte[]{95, -121, -121};
            byArrayArray[67] = new byte[]{95, -121, -81};
            byArrayArray[68] = new byte[]{95, -121, -41};
            byArrayArray[69] = new byte[]{95, -121, -1};
            byte[] byArray50 = new byte[3];
            byArray50[0] = 95;
            byArray50[1] = -81;
            byArrayArray[70] = byArray50;
            byArrayArray[71] = new byte[]{95, -81, 95};
            byArrayArray[72] = new byte[]{95, -81, -121};
            byArrayArray[73] = new byte[]{95, -81, -81};
            byArrayArray[74] = new byte[]{95, -81, -41};
            byArrayArray[75] = new byte[]{95, -81, -1};
            byte[] byArray51 = new byte[3];
            byArray51[0] = 95;
            byArray51[1] = -41;
            byArrayArray[76] = byArray51;
            byArrayArray[77] = new byte[]{95, -41, 95};
            byArrayArray[78] = new byte[]{95, -41, -121};
            byArrayArray[79] = new byte[]{95, -41, -81};
            byArrayArray[80] = new byte[]{95, -41, -41};
            byArrayArray[81] = new byte[]{95, -41, -1};
            byte[] byArray52 = new byte[3];
            byArray52[0] = 95;
            byArray52[1] = -1;
            byArrayArray[82] = byArray52;
            byArrayArray[83] = new byte[]{95, -1, 95};
            byArrayArray[84] = new byte[]{95, -1, -121};
            byArrayArray[85] = new byte[]{95, -1, -81};
            byArrayArray[86] = new byte[]{95, -1, -41};
            byArrayArray[87] = new byte[]{95, -1, -1};
            byte[] byArray53 = new byte[3];
            byArray53[0] = -121;
            byArrayArray[88] = byArray53;
            byte[] byArray54 = new byte[3];
            byArray54[0] = -121;
            byArray54[2] = 95;
            byArrayArray[89] = byArray54;
            byte[] byArray55 = new byte[3];
            byArray55[0] = -121;
            byArray55[2] = -121;
            byArrayArray[90] = byArray55;
            byte[] byArray56 = new byte[3];
            byArray56[0] = -121;
            byArray56[2] = -81;
            byArrayArray[91] = byArray56;
            byte[] byArray57 = new byte[3];
            byArray57[0] = -121;
            byArray57[2] = -41;
            byArrayArray[92] = byArray57;
            byte[] byArray58 = new byte[3];
            byArray58[0] = -121;
            byArray58[2] = -1;
            byArrayArray[93] = byArray58;
            byte[] byArray59 = new byte[3];
            byArray59[0] = -121;
            byArray59[1] = 95;
            byArrayArray[94] = byArray59;
            byArrayArray[95] = new byte[]{-121, 95, 95};
            byArrayArray[96] = new byte[]{-121, 95, -121};
            byArrayArray[97] = new byte[]{-121, 95, -81};
            byArrayArray[98] = new byte[]{-121, 95, -41};
            byArrayArray[99] = new byte[]{-121, 95, -1};
            byte[] byArray60 = new byte[3];
            byArray60[0] = -121;
            byArray60[1] = -121;
            byArrayArray[100] = byArray60;
            byArrayArray[101] = new byte[]{-121, -121, 95};
            byArrayArray[102] = new byte[]{-121, -121, -121};
            byArrayArray[103] = new byte[]{-121, -121, -81};
            byArrayArray[104] = new byte[]{-121, -121, -41};
            byArrayArray[105] = new byte[]{-121, -121, -1};
            byte[] byArray61 = new byte[3];
            byArray61[0] = -121;
            byArray61[1] = -81;
            byArrayArray[106] = byArray61;
            byArrayArray[107] = new byte[]{-121, -81, 95};
            byArrayArray[108] = new byte[]{-121, -81, -121};
            byArrayArray[109] = new byte[]{-121, -81, -81};
            byArrayArray[110] = new byte[]{-121, -81, -41};
            byArrayArray[111] = new byte[]{-121, -81, -1};
            byte[] byArray62 = new byte[3];
            byArray62[0] = -121;
            byArray62[1] = -41;
            byArrayArray[112] = byArray62;
            byArrayArray[113] = new byte[]{-121, -41, 95};
            byArrayArray[114] = new byte[]{-121, -41, -121};
            byArrayArray[115] = new byte[]{-121, -41, -81};
            byArrayArray[116] = new byte[]{-121, -41, -41};
            byArrayArray[117] = new byte[]{-121, -41, -1};
            byte[] byArray63 = new byte[3];
            byArray63[0] = -121;
            byArray63[1] = -1;
            byArrayArray[118] = byArray63;
            byArrayArray[119] = new byte[]{-121, -1, 95};
            byArrayArray[120] = new byte[]{-121, -1, -121};
            byArrayArray[121] = new byte[]{-121, -1, -81};
            byArrayArray[122] = new byte[]{-121, -1, -41};
            byArrayArray[123] = new byte[]{-121, -1, -1};
            byte[] byArray64 = new byte[3];
            byArray64[0] = -81;
            byArrayArray[124] = byArray64;
            byte[] byArray65 = new byte[3];
            byArray65[0] = -81;
            byArray65[2] = 95;
            byArrayArray[125] = byArray65;
            byte[] byArray66 = new byte[3];
            byArray66[0] = -81;
            byArray66[2] = -121;
            byArrayArray[126] = byArray66;
            byte[] byArray67 = new byte[3];
            byArray67[0] = -81;
            byArray67[2] = -81;
            byArrayArray[127] = byArray67;
            byte[] byArray68 = new byte[3];
            byArray68[0] = -81;
            byArray68[2] = -41;
            byArrayArray[128] = byArray68;
            byte[] byArray69 = new byte[3];
            byArray69[0] = -81;
            byArray69[2] = -1;
            byArrayArray[129] = byArray69;
            byte[] byArray70 = new byte[3];
            byArray70[0] = -81;
            byArray70[1] = 95;
            byArrayArray[130] = byArray70;
            byArrayArray[131] = new byte[]{-81, 95, 95};
            byArrayArray[132] = new byte[]{-81, 95, -121};
            byArrayArray[133] = new byte[]{-81, 95, -81};
            byArrayArray[134] = new byte[]{-81, 95, -41};
            byArrayArray[135] = new byte[]{-81, 95, -1};
            byte[] byArray71 = new byte[3];
            byArray71[0] = -81;
            byArray71[1] = -121;
            byArrayArray[136] = byArray71;
            byArrayArray[137] = new byte[]{-81, -121, 95};
            byArrayArray[138] = new byte[]{-81, -121, -121};
            byArrayArray[139] = new byte[]{-81, -121, -81};
            byArrayArray[140] = new byte[]{-81, -121, -41};
            byArrayArray[141] = new byte[]{-81, -121, -1};
            byte[] byArray72 = new byte[3];
            byArray72[0] = -81;
            byArray72[1] = -81;
            byArrayArray[142] = byArray72;
            byArrayArray[143] = new byte[]{-81, -81, 95};
            byArrayArray[144] = new byte[]{-81, -81, -121};
            byArrayArray[145] = new byte[]{-81, -81, -81};
            byArrayArray[146] = new byte[]{-81, -81, -41};
            byArrayArray[147] = new byte[]{-81, -81, -1};
            byte[] byArray73 = new byte[3];
            byArray73[0] = -81;
            byArray73[1] = -41;
            byArrayArray[148] = byArray73;
            byArrayArray[149] = new byte[]{-81, -41, 95};
            byArrayArray[150] = new byte[]{-81, -41, -121};
            byArrayArray[151] = new byte[]{-81, -41, -81};
            byArrayArray[152] = new byte[]{-81, -41, -41};
            byArrayArray[153] = new byte[]{-81, -41, -1};
            byte[] byArray74 = new byte[3];
            byArray74[0] = -81;
            byArray74[1] = -1;
            byArrayArray[154] = byArray74;
            byArrayArray[155] = new byte[]{-81, -1, 95};
            byArrayArray[156] = new byte[]{-81, -1, -121};
            byArrayArray[157] = new byte[]{-81, -1, -81};
            byArrayArray[158] = new byte[]{-81, -1, -41};
            byArrayArray[159] = new byte[]{-81, -1, -1};
            byte[] byArray75 = new byte[3];
            byArray75[0] = -41;
            byArrayArray[160] = byArray75;
            byte[] byArray76 = new byte[3];
            byArray76[0] = -41;
            byArray76[2] = 95;
            byArrayArray[161] = byArray76;
            byte[] byArray77 = new byte[3];
            byArray77[0] = -41;
            byArray77[2] = -121;
            byArrayArray[162] = byArray77;
            byte[] byArray78 = new byte[3];
            byArray78[0] = -41;
            byArray78[2] = -81;
            byArrayArray[163] = byArray78;
            byte[] byArray79 = new byte[3];
            byArray79[0] = -41;
            byArray79[2] = -41;
            byArrayArray[164] = byArray79;
            byte[] byArray80 = new byte[3];
            byArray80[0] = -41;
            byArray80[2] = -1;
            byArrayArray[165] = byArray80;
            byte[] byArray81 = new byte[3];
            byArray81[0] = -41;
            byArray81[1] = 95;
            byArrayArray[166] = byArray81;
            byArrayArray[167] = new byte[]{-41, 95, 95};
            byArrayArray[168] = new byte[]{-41, 95, -121};
            byArrayArray[169] = new byte[]{-41, 95, -81};
            byArrayArray[170] = new byte[]{-41, 95, -41};
            byArrayArray[171] = new byte[]{-41, 95, -1};
            byte[] byArray82 = new byte[3];
            byArray82[0] = -41;
            byArray82[1] = -121;
            byArrayArray[172] = byArray82;
            byArrayArray[173] = new byte[]{-41, -121, 95};
            byArrayArray[174] = new byte[]{-41, -121, -121};
            byArrayArray[175] = new byte[]{-41, -121, -81};
            byArrayArray[176] = new byte[]{-41, -121, -41};
            byArrayArray[177] = new byte[]{-41, -121, -1};
            byte[] byArray83 = new byte[3];
            byArray83[0] = -41;
            byArray83[1] = -81;
            byArrayArray[178] = byArray83;
            byArrayArray[179] = new byte[]{-41, -81, 95};
            byArrayArray[180] = new byte[]{-41, -81, -121};
            byArrayArray[181] = new byte[]{-41, -81, -81};
            byArrayArray[182] = new byte[]{-41, -81, -41};
            byArrayArray[183] = new byte[]{-41, -81, -1};
            byte[] byArray84 = new byte[3];
            byArray84[0] = -41;
            byArray84[1] = -41;
            byArrayArray[184] = byArray84;
            byArrayArray[185] = new byte[]{-41, -41, 95};
            byArrayArray[186] = new byte[]{-41, -41, -121};
            byArrayArray[187] = new byte[]{-41, -41, -81};
            byArrayArray[188] = new byte[]{-41, -41, -41};
            byArrayArray[189] = new byte[]{-41, -41, -1};
            byte[] byArray85 = new byte[3];
            byArray85[0] = -41;
            byArray85[1] = -1;
            byArrayArray[190] = byArray85;
            byArrayArray[191] = new byte[]{-41, -1, 95};
            byArrayArray[192] = new byte[]{-41, -1, -121};
            byArrayArray[193] = new byte[]{-41, -1, -81};
            byArrayArray[194] = new byte[]{-41, -1, -41};
            byArrayArray[195] = new byte[]{-41, -1, -1};
            byte[] byArray86 = new byte[3];
            byArray86[0] = -1;
            byArrayArray[196] = byArray86;
            byte[] byArray87 = new byte[3];
            byArray87[0] = -1;
            byArray87[2] = 95;
            byArrayArray[197] = byArray87;
            byte[] byArray88 = new byte[3];
            byArray88[0] = -1;
            byArray88[2] = -121;
            byArrayArray[198] = byArray88;
            byte[] byArray89 = new byte[3];
            byArray89[0] = -1;
            byArray89[2] = -81;
            byArrayArray[199] = byArray89;
            byte[] byArray90 = new byte[3];
            byArray90[0] = -1;
            byArray90[2] = -41;
            byArrayArray[200] = byArray90;
            byte[] byArray91 = new byte[3];
            byArray91[0] = -1;
            byArray91[2] = -1;
            byArrayArray[201] = byArray91;
            byte[] byArray92 = new byte[3];
            byArray92[0] = -1;
            byArray92[1] = 95;
            byArrayArray[202] = byArray92;
            byArrayArray[203] = new byte[]{-1, 95, 95};
            byArrayArray[204] = new byte[]{-1, 95, -121};
            byArrayArray[205] = new byte[]{-1, 95, -81};
            byArrayArray[206] = new byte[]{-1, 95, -41};
            byArrayArray[207] = new byte[]{-1, 95, -1};
            byte[] byArray93 = new byte[3];
            byArray93[0] = -1;
            byArray93[1] = -121;
            byArrayArray[208] = byArray93;
            byArrayArray[209] = new byte[]{-1, -121, 95};
            byArrayArray[210] = new byte[]{-1, -121, -121};
            byArrayArray[211] = new byte[]{-1, -121, -81};
            byArrayArray[212] = new byte[]{-1, -121, -41};
            byArrayArray[213] = new byte[]{-1, -121, -1};
            byte[] byArray94 = new byte[3];
            byArray94[0] = -1;
            byArray94[1] = -81;
            byArrayArray[214] = byArray94;
            byArrayArray[215] = new byte[]{-1, -81, 95};
            byArrayArray[216] = new byte[]{-1, -81, -121};
            byArrayArray[217] = new byte[]{-1, -81, -81};
            byArrayArray[218] = new byte[]{-1, -81, -41};
            byArrayArray[219] = new byte[]{-1, -81, -1};
            byte[] byArray95 = new byte[3];
            byArray95[0] = -1;
            byArray95[1] = -41;
            byArrayArray[220] = byArray95;
            byArrayArray[221] = new byte[]{-1, -41, 95};
            byArrayArray[222] = new byte[]{-1, -41, -121};
            byArrayArray[223] = new byte[]{-1, -41, -81};
            byArrayArray[224] = new byte[]{-1, -41, -41};
            byArrayArray[225] = new byte[]{-1, -41, -1};
            byte[] byArray96 = new byte[3];
            byArray96[0] = -1;
            byArray96[1] = -1;
            byArrayArray[226] = byArray96;
            byArrayArray[227] = new byte[]{-1, -1, 95};
            byArrayArray[228] = new byte[]{-1, -1, -121};
            byArrayArray[229] = new byte[]{-1, -1, -81};
            byArrayArray[230] = new byte[]{-1, -1, -41};
            byArrayArray[231] = new byte[]{-1, -1, -1};
            byArrayArray[232] = new byte[]{8, 8, 8};
            byArrayArray[233] = new byte[]{18, 18, 18};
            byArrayArray[234] = new byte[]{28, 28, 28};
            byArrayArray[235] = new byte[]{38, 38, 38};
            byArrayArray[236] = new byte[]{48, 48, 48};
            byArrayArray[237] = new byte[]{58, 58, 58};
            byArrayArray[238] = new byte[]{68, 68, 68};
            byArrayArray[239] = new byte[]{78, 78, 78};
            byArrayArray[240] = new byte[]{88, 88, 88};
            byArrayArray[241] = new byte[]{98, 98, 98};
            byArrayArray[242] = new byte[]{108, 108, 108};
            byArrayArray[243] = new byte[]{118, 118, 118};
            byArrayArray[244] = new byte[]{-128, -128, -128};
            byArrayArray[245] = new byte[]{-118, -118, -118};
            byArrayArray[246] = new byte[]{-108, -108, -108};
            byArrayArray[247] = new byte[]{-98, -98, -98};
            byArrayArray[248] = new byte[]{-88, -88, -88};
            byArrayArray[249] = new byte[]{-78, -78, -78};
            byArrayArray[250] = new byte[]{-68, -68, -68};
            byArrayArray[251] = new byte[]{-58, -58, -58};
            byArrayArray[252] = new byte[]{-48, -48, -48};
            byArrayArray[253] = new byte[]{-38, -38, -38};
            byArrayArray[254] = new byte[]{-28, -28, -28};
            byArrayArray[255] = new byte[]{-18, -18, -18};
            COLOR_TABLE = byArrayArray;
        }

        public Indexed(int colorIndex) {
            if (colorIndex > 255 || colorIndex < 0) {
                throw new IllegalArgumentException("Cannot create a Color.Indexed with a color index of " + colorIndex + ", must be in the range of 0-255");
            }
            this.colorIndex = colorIndex;
        }

        @Override
        public byte[] getForegroundSGRSequence() {
            return ("38;5;" + this.colorIndex).getBytes();
        }

        @Override
        public byte[] getBackgroundSGRSequence() {
            return ("48;5;" + this.colorIndex).getBytes();
        }

        @Override
        public int getRed() {
            return COLOR_TABLE[this.colorIndex][0] & 0xFF;
        }

        @Override
        public int getGreen() {
            return COLOR_TABLE[this.colorIndex][1] & 0xFF;
        }

        @Override
        public int getBlue() {
            return COLOR_TABLE[this.colorIndex][2] & 0xFF;
        }

        @Override
        public Color toColor() {
            return new Color(this.getRed(), this.getGreen(), this.getBlue());
        }

        public String toString() {
            return "{IndexedColor:" + this.colorIndex + "}";
        }

        public int hashCode() {
            int hash = 3;
            hash = 43 * hash + this.colorIndex;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Indexed other = (Indexed)obj;
            return this.colorIndex == other.colorIndex;
        }

        public static Indexed fromRGB(int red, int green, int blue) {
            int greyDistance;
            if (red < 0 || red > 255) {
                throw new IllegalArgumentException("fromRGB: red is outside of valid range (0-255)");
            }
            if (green < 0 || green > 255) {
                throw new IllegalArgumentException("fromRGB: green is outside of valid range (0-255)");
            }
            if (blue < 0 || blue > 255) {
                throw new IllegalArgumentException("fromRGB: blue is outside of valid range (0-255)");
            }
            int rescaledRed = (int)((double)red / 255.0 * 5.0);
            int rescaledGreen = (int)((double)green / 255.0 * 5.0);
            int rescaledBlue = (int)((double)blue / 255.0 * 5.0);
            int index = rescaledBlue + 6 * rescaledGreen + 36 * rescaledRed + 16;
            Indexed fromColorCube = new Indexed(index);
            Indexed fromGreyRamp = Indexed.fromGreyRamp((red + green + blue) / 3);
            int coloredDistance = (red - fromColorCube.getRed()) * (red - fromColorCube.getRed()) + (green - fromColorCube.getGreen()) * (green - fromColorCube.getGreen()) + (blue - fromColorCube.getBlue()) * (blue - fromColorCube.getBlue());
            if (coloredDistance < (greyDistance = (red - fromGreyRamp.getRed()) * (red - fromGreyRamp.getRed()) + (green - fromGreyRamp.getGreen()) * (green - fromGreyRamp.getGreen()) + (blue - fromGreyRamp.getBlue()) * (blue - fromGreyRamp.getBlue()))) {
                return fromColorCube;
            }
            return fromGreyRamp;
        }

        private static Indexed fromGreyRamp(int intensity) {
            int rescaled = (int)((double)intensity / 255.0 * 23.0) + 232;
            return new Indexed(rescaled);
        }
    }

    public static class RGB
    implements TextColor {
        private final int red;
        private final int green;
        private final int blue;

        public RGB(int r, int g, int b) {
            if (r < 0 || r > 255) {
                throw new IllegalArgumentException("RGB: r is outside of valid range (0-255)");
            }
            if (g < 0 || g > 255) {
                throw new IllegalArgumentException("RGB: g is outside of valid range (0-255)");
            }
            if (b < 0 || b > 255) {
                throw new IllegalArgumentException("RGB: b is outside of valid range (0-255)");
            }
            this.red = r;
            this.green = g;
            this.blue = b;
        }

        @Override
        public byte[] getForegroundSGRSequence() {
            return ("38;2;" + this.getRed() + ";" + this.getGreen() + ";" + this.getBlue()).getBytes();
        }

        @Override
        public byte[] getBackgroundSGRSequence() {
            return ("48;2;" + this.getRed() + ";" + this.getGreen() + ";" + this.getBlue()).getBytes();
        }

        @Override
        public int getRed() {
            return this.red;
        }

        @Override
        public int getGreen() {
            return this.green;
        }

        @Override
        public int getBlue() {
            return this.blue;
        }

        @Override
        public Color toColor() {
            return new Color(this.getRed(), this.getGreen(), this.getBlue());
        }

        public String toString() {
            return "{RGB:" + this.getRed() + "," + this.getGreen() + "," + this.getBlue() + "}";
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + this.red;
            hash = 29 * hash + this.green;
            hash = 29 * hash + this.blue;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RGB other = (RGB)obj;
            return this.red == other.red && this.green == other.green && this.blue == other.blue;
        }
    }
}

