/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.bundle;

import com.googlecode.lanterna.bundle.DefaultTheme;
import com.googlecode.lanterna.graphics.PropertyTheme;
import com.googlecode.lanterna.graphics.Theme;
import com.googlecode.lanterna.gui2.AbstractTextGUI;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class LanternaThemes {
    private static final ConcurrentHashMap<String, Theme> REGISTERED_THEMES = new ConcurrentHashMap();

    static {
        Properties defaultThemeProperties = LanternaThemes.loadPropTheme("default-theme.properties");
        if (defaultThemeProperties != null) {
            LanternaThemes.registerPropTheme("default", defaultThemeProperties);
        } else {
            LanternaThemes.registerTheme("default", new DefaultTheme());
        }
        LanternaThemes.registerPropTheme("bigsnake", LanternaThemes.loadPropTheme("bigsnake-theme.properties"));
        LanternaThemes.registerPropTheme("businessmachine", LanternaThemes.loadPropTheme("businessmachine-theme.properties"));
        LanternaThemes.registerPropTheme("conqueror", LanternaThemes.loadPropTheme("conqueror-theme.properties"));
        LanternaThemes.registerPropTheme("defrost", LanternaThemes.loadPropTheme("defrost-theme.properties"));
        LanternaThemes.registerPropTheme("blaster", LanternaThemes.loadPropTheme("blaster-theme.properties"));
    }

    private LanternaThemes() {
    }

    public static Collection<String> getRegisteredThemes() {
        return new ArrayList<String>(REGISTERED_THEMES.keySet());
    }

    public static Theme getRegisteredTheme(String name) {
        return REGISTERED_THEMES.get(name);
    }

    public static void registerTheme(String name, Theme theme) {
        if (theme == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Name cannot be empty");
        }
        Theme result = REGISTERED_THEMES.putIfAbsent(name, theme);
        if (result != null && result != theme) {
            throw new IllegalArgumentException("There is already a theme registered with the name '" + name + "'");
        }
    }

    public static Theme getDefaultTheme() {
        return REGISTERED_THEMES.get("default");
    }

    private static void registerPropTheme(String name, Properties properties) {
        if (properties != null) {
            LanternaThemes.registerTheme(name, new PropertyTheme(properties, false));
        }
    }

    private static Properties loadPropTheme(String resourceFileName) {
        Properties properties = new Properties();
        try {
            ClassLoader classLoader = AbstractTextGUI.class.getClassLoader();
            InputStream resourceAsStream = classLoader.getResourceAsStream(resourceFileName);
            if (resourceAsStream == null) {
                resourceAsStream = new FileInputStream("src/main/resources/" + resourceFileName);
            }
            properties.load(resourceAsStream);
            resourceAsStream.close();
            return properties;
        }
        catch (IOException e) {
            return null;
        }
    }
}

