/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.graphics;

import com.googlecode.lanterna.SGR;
import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TerminalTextUtils;
import com.googlecode.lanterna.TextCharacter;
import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.graphics.DefaultShapeRenderer;
import com.googlecode.lanterna.graphics.NullTextGraphics;
import com.googlecode.lanterna.graphics.ShapeRenderer;
import com.googlecode.lanterna.graphics.StyleSet;
import com.googlecode.lanterna.graphics.SubTextGraphics;
import com.googlecode.lanterna.graphics.TextGraphics;
import com.googlecode.lanterna.graphics.TextImage;
import com.googlecode.lanterna.screen.TabBehaviour;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;

public abstract class AbstractTextGraphics
implements TextGraphics {
    protected TextColor foregroundColor;
    protected TextColor backgroundColor;
    protected TabBehaviour tabBehaviour;
    protected final EnumSet<SGR> activeModifiers = EnumSet.noneOf(SGR.class);
    private final ShapeRenderer shapeRenderer;

    protected AbstractTextGraphics() {
        this.tabBehaviour = TabBehaviour.ALIGN_TO_COLUMN_4;
        this.foregroundColor = TextColor.ANSI.DEFAULT;
        this.backgroundColor = TextColor.ANSI.DEFAULT;
        this.shapeRenderer = new DefaultShapeRenderer(this::setCharacter);
    }

    @Override
    public TextColor getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public TextGraphics setBackgroundColor(TextColor backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @Override
    public TextColor getForegroundColor() {
        return this.foregroundColor;
    }

    @Override
    public TextGraphics setForegroundColor(TextColor foregroundColor) {
        this.foregroundColor = foregroundColor;
        return this;
    }

    @Override
    public TextGraphics enableModifiers(SGR ... modifiers) {
        this.enableModifiers(Arrays.asList(modifiers));
        return this;
    }

    private void enableModifiers(Collection<SGR> modifiers) {
        this.activeModifiers.addAll(modifiers);
    }

    @Override
    public TextGraphics disableModifiers(SGR ... modifiers) {
        this.disableModifiers(Arrays.asList(modifiers));
        return this;
    }

    private void disableModifiers(Collection<SGR> modifiers) {
        this.activeModifiers.removeAll(modifiers);
    }

    @Override
    public synchronized TextGraphics setModifiers(EnumSet<SGR> modifiers) {
        this.activeModifiers.clear();
        this.activeModifiers.addAll(modifiers);
        return this;
    }

    @Override
    public TextGraphics clearModifiers() {
        this.activeModifiers.clear();
        return this;
    }

    @Override
    public EnumSet<SGR> getActiveModifiers() {
        return this.activeModifiers;
    }

    @Override
    public TabBehaviour getTabBehaviour() {
        return this.tabBehaviour;
    }

    @Override
    public TextGraphics setTabBehaviour(TabBehaviour tabBehaviour) {
        if (tabBehaviour != null) {
            this.tabBehaviour = tabBehaviour;
        }
        return this;
    }

    @Override
    public TextGraphics fill(char c) {
        this.fillRectangle(TerminalPosition.TOP_LEFT_CORNER, this.getSize(), c);
        return this;
    }

    @Override
    public TextGraphics setCharacter(int column, int row, char character) {
        return this.setCharacter(column, row, this.newTextCharacter(character));
    }

    @Override
    public TextGraphics setCharacter(TerminalPosition position, TextCharacter textCharacter) {
        this.setCharacter(position.getColumn(), position.getRow(), textCharacter);
        return this;
    }

    @Override
    public TextGraphics setCharacter(TerminalPosition position, char character) {
        return this.setCharacter(position.getColumn(), position.getRow(), character);
    }

    @Override
    public TextGraphics drawLine(TerminalPosition fromPosition, TerminalPosition toPoint, char character) {
        return this.drawLine(fromPosition, toPoint, this.newTextCharacter(character));
    }

    @Override
    public TextGraphics drawLine(TerminalPosition fromPoint, TerminalPosition toPoint, TextCharacter character) {
        this.shapeRenderer.drawLine(fromPoint, toPoint, character);
        return this;
    }

    @Override
    public TextGraphics drawLine(int fromX, int fromY, int toX, int toY, char character) {
        return this.drawLine(fromX, fromY, toX, toY, this.newTextCharacter(character));
    }

    @Override
    public TextGraphics drawLine(int fromX, int fromY, int toX, int toY, TextCharacter character) {
        return this.drawLine(new TerminalPosition(fromX, fromY), new TerminalPosition(toX, toY), character);
    }

    @Override
    public TextGraphics drawTriangle(TerminalPosition p1, TerminalPosition p2, TerminalPosition p3, char character) {
        return this.drawTriangle(p1, p2, p3, this.newTextCharacter(character));
    }

    @Override
    public TextGraphics drawTriangle(TerminalPosition p1, TerminalPosition p2, TerminalPosition p3, TextCharacter character) {
        this.shapeRenderer.drawTriangle(p1, p2, p3, character);
        return this;
    }

    @Override
    public TextGraphics fillTriangle(TerminalPosition p1, TerminalPosition p2, TerminalPosition p3, char character) {
        return this.fillTriangle(p1, p2, p3, this.newTextCharacter(character));
    }

    @Override
    public TextGraphics fillTriangle(TerminalPosition p1, TerminalPosition p2, TerminalPosition p3, TextCharacter character) {
        this.shapeRenderer.fillTriangle(p1, p2, p3, character);
        return this;
    }

    @Override
    public TextGraphics drawRectangle(TerminalPosition topLeft, TerminalSize size, char character) {
        return this.drawRectangle(topLeft, size, this.newTextCharacter(character));
    }

    @Override
    public TextGraphics drawRectangle(TerminalPosition topLeft, TerminalSize size, TextCharacter character) {
        this.shapeRenderer.drawRectangle(topLeft, size, character);
        return this;
    }

    @Override
    public TextGraphics fillRectangle(TerminalPosition topLeft, TerminalSize size, char character) {
        return this.fillRectangle(topLeft, size, this.newTextCharacter(character));
    }

    @Override
    public TextGraphics fillRectangle(TerminalPosition topLeft, TerminalSize size, TextCharacter character) {
        this.shapeRenderer.fillRectangle(topLeft, size, character);
        return this;
    }

    @Override
    public TextGraphics drawImage(TerminalPosition topLeft, TextImage image) {
        return this.drawImage(topLeft, image, TerminalPosition.TOP_LEFT_CORNER, image.getSize());
    }

    @Override
    public TextGraphics drawImage(TerminalPosition topLeft, TextImage image, TerminalPosition sourceImageTopLeft, TerminalSize sourceImageSize) {
        if (sourceImageTopLeft.getColumn() < 0) {
            topLeft = topLeft.withRelativeColumn(-sourceImageTopLeft.getColumn());
            sourceImageSize = sourceImageSize.withRelativeColumns(sourceImageTopLeft.getColumn());
            sourceImageTopLeft = sourceImageTopLeft.withColumn(0);
        }
        if (sourceImageTopLeft.getRow() < 0) {
            topLeft = topLeft.withRelativeRow(-sourceImageTopLeft.getRow());
            sourceImageSize = sourceImageSize.withRelativeRows(sourceImageTopLeft.getRow());
            sourceImageTopLeft = sourceImageTopLeft.withRow(0);
        }
        int fromRow = Math.max(sourceImageTopLeft.getRow(), 0);
        int untilRow = Math.min(sourceImageTopLeft.getRow() + sourceImageSize.getRows(), image.getSize().getRows());
        int fromColumn = Math.max(sourceImageTopLeft.getColumn(), 0);
        int untilColumn = Math.min(sourceImageTopLeft.getColumn() + sourceImageSize.getColumns(), image.getSize().getColumns());
        int diffRow = topLeft.getRow() - sourceImageTopLeft.getRow();
        int diffColumn = topLeft.getColumn() - sourceImageTopLeft.getColumn();
        fromRow = Math.max(fromRow, -diffRow);
        fromColumn = Math.max(fromColumn, -diffColumn);
        untilRow = Math.min(untilRow, this.getSize().getRows() - diffRow);
        untilColumn = Math.min(untilColumn, this.getSize().getColumns() - diffColumn);
        if (fromRow >= untilRow || fromColumn >= untilColumn) {
            return this;
        }
        int row = fromRow;
        while (row < untilRow) {
            int column = fromColumn;
            while (column < untilColumn) {
                this.setCharacter(column + diffColumn, row + diffRow, image.getCharacterAt(column, row));
                ++column;
            }
            ++row;
        }
        return this;
    }

    @Override
    public TextGraphics putString(int column, int row, String string) {
        string = this.prepareStringForPut(column, string);
        int offset = 0;
        int i = 0;
        while (i < string.length()) {
            char character = string.charAt(i);
            this.setCharacter(column + offset, row, this.newTextCharacter(character));
            offset += this.getOffsetToNextCharacter(character);
            ++i;
        }
        return this;
    }

    @Override
    public TextGraphics putString(TerminalPosition position, String string) {
        this.putString(position.getColumn(), position.getRow(), string);
        return this;
    }

    @Override
    public TextGraphics putString(int column, int row, String string, SGR extraModifier, SGR ... optionalExtraModifiers) {
        this.clearModifiers();
        return this.putString(column, row, string, EnumSet.of(extraModifier, optionalExtraModifiers));
    }

    @Override
    public TextGraphics putString(int column, int row, String string, Collection<SGR> extraModifiers) {
        EnumSet<SGR> newModifiers = EnumSet.copyOf(extraModifiers);
        newModifiers.removeAll(this.activeModifiers);
        this.enableModifiers(newModifiers);
        this.putString(column, row, string);
        this.disableModifiers(newModifiers);
        return this;
    }

    @Override
    public TextGraphics putString(TerminalPosition position, String string, SGR extraModifier, SGR ... optionalExtraModifiers) {
        this.putString(position.getColumn(), position.getRow(), string, extraModifier, optionalExtraModifiers);
        return this;
    }

    @Override
    public synchronized TextGraphics putCSIStyledString(int column, int row, String string) {
        StyleSet.Set original = new StyleSet.Set(this);
        string = this.prepareStringForPut(column, string);
        int offset = 0;
        int i = 0;
        while (i < string.length()) {
            char character = string.charAt(i);
            String controlSequence = TerminalTextUtils.getANSIControlSequenceAt(string, i);
            if (controlSequence != null) {
                TerminalTextUtils.updateModifiersFromCSICode(controlSequence, this, original);
                i += controlSequence.length() - 1;
            } else {
                this.setCharacter(column + offset, row, this.newTextCharacter(character));
                offset += this.getOffsetToNextCharacter(character);
            }
            ++i;
        }
        this.setStyleFrom((StyleSet)original);
        return this;
    }

    @Override
    public TextGraphics putCSIStyledString(TerminalPosition position, String string) {
        return this.putCSIStyledString(position.getColumn(), position.getRow(), string);
    }

    @Override
    public TextCharacter getCharacter(TerminalPosition position) {
        return this.getCharacter(position.getColumn(), position.getRow());
    }

    @Override
    public TextGraphics newTextGraphics(TerminalPosition topLeftCorner, TerminalSize size) throws IllegalArgumentException {
        TerminalSize writableArea = this.getSize();
        if (topLeftCorner.getColumn() + size.getColumns() <= 0 || topLeftCorner.getColumn() >= writableArea.getColumns() || topLeftCorner.getRow() + size.getRows() <= 0 || topLeftCorner.getRow() >= writableArea.getRows()) {
            return new NullTextGraphics(size);
        }
        return new SubTextGraphics(this, topLeftCorner, size);
    }

    private TextCharacter newTextCharacter(char character) {
        return new TextCharacter(character, this.foregroundColor, this.backgroundColor, this.activeModifiers);
    }

    private String prepareStringForPut(int column, String string) {
        if (string.contains("\n")) {
            string = string.substring(0, string.indexOf("\n"));
        }
        if (string.contains("\r")) {
            string = string.substring(0, string.indexOf("\r"));
        }
        string = this.tabBehaviour.replaceTabs(string, column);
        return string;
    }

    private int getOffsetToNextCharacter(char character) {
        if (TerminalTextUtils.isCharDoubleWidth(character)) {
            return 2;
        }
        return 1;
    }

    @Override
    public TextGraphics setStyleFrom(StyleSet<?> source) {
        this.setBackgroundColor(source.getBackgroundColor());
        this.setForegroundColor(source.getForegroundColor());
        this.setModifiers((EnumSet)source.getActiveModifiers());
        return this;
    }
}

