/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.graphics;

import com.googlecode.lanterna.SGR;
import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TextCharacter;
import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.graphics.AbstractTextGraphics;
import com.googlecode.lanterna.graphics.TextGraphics;
import com.googlecode.lanterna.graphics.TextImage;
import java.util.Arrays;

public class BasicTextImage
implements TextImage {
    private final TerminalSize size;
    private final TextCharacter[][] buffer;

    public BasicTextImage(int columns, int rows) {
        this(new TerminalSize(columns, rows));
    }

    public BasicTextImage(TerminalSize size) {
        this(size, new TextCharacter(' ', (TextColor)TextColor.ANSI.DEFAULT, (TextColor)TextColor.ANSI.DEFAULT, new SGR[0]));
    }

    public BasicTextImage(TerminalSize size, TextCharacter initialContent) {
        this(size, new TextCharacter[0][], initialContent);
    }

    private BasicTextImage(TerminalSize size, TextCharacter[][] toCopy, TextCharacter initialContent) {
        if (size == null || toCopy == null || initialContent == null) {
            throw new IllegalArgumentException("Cannot create BasicTextImage with null " + (size == null ? "size" : (toCopy == null ? "toCopy" : "filler")));
        }
        this.size = size;
        int rows = size.getRows();
        int columns = size.getColumns();
        this.buffer = new TextCharacter[rows][];
        int y = 0;
        while (y < rows) {
            this.buffer[y] = new TextCharacter[columns];
            int x = 0;
            while (x < columns) {
                this.buffer[y][x] = y < toCopy.length && x < toCopy[y].length ? toCopy[y][x] : initialContent;
                ++x;
            }
            ++y;
        }
    }

    @Override
    public TerminalSize getSize() {
        return this.size;
    }

    @Override
    public void setAll(TextCharacter character) {
        if (character == null) {
            throw new IllegalArgumentException("Cannot call BasicTextImage.setAll(..) with null character");
        }
        TextCharacter[][] textCharacterArray = this.buffer;
        int n = this.buffer.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] line = textCharacterArray[n2];
            Arrays.fill(line, character);
            ++n2;
        }
    }

    @Override
    public BasicTextImage resize(TerminalSize newSize, TextCharacter filler) {
        if (newSize == null || filler == null) {
            throw new IllegalArgumentException("Cannot resize BasicTextImage with null " + (newSize == null ? "newSize" : "filler"));
        }
        if (newSize.getRows() == this.buffer.length && (this.buffer.length == 0 || newSize.getColumns() == this.buffer[0].length)) {
            return this;
        }
        return new BasicTextImage(newSize, this.buffer, filler);
    }

    @Override
    public void setCharacterAt(TerminalPosition position, TextCharacter character) {
        if (position == null) {
            throw new IllegalArgumentException("Cannot call BasicTextImage.setCharacterAt(..) with null position");
        }
        this.setCharacterAt(position.getColumn(), position.getRow(), character);
    }

    @Override
    public void setCharacterAt(int column, int row, TextCharacter character) {
        if (character == null) {
            throw new IllegalArgumentException("Cannot call BasicTextImage.setCharacterAt(..) with null character");
        }
        if (column < 0 || row < 0 || row >= this.buffer.length || column >= this.buffer[0].length) {
            return;
        }
        if (column > 0 && this.buffer[row][column - 1].isDoubleWidth()) {
            this.buffer[row][column - 1] = this.buffer[row][column - 1].withCharacter(' ');
        }
        this.buffer[row][column] = character;
        if (character.isDoubleWidth() && column + 1 < this.buffer[0].length) {
            this.buffer[row][column + 1] = character.withCharacter(' ');
        }
    }

    @Override
    public TextCharacter getCharacterAt(TerminalPosition position) {
        if (position == null) {
            throw new IllegalArgumentException("Cannot call BasicTextImage.getCharacterAt(..) with null position");
        }
        return this.getCharacterAt(position.getColumn(), position.getRow());
    }

    @Override
    public TextCharacter getCharacterAt(int column, int row) {
        if (column < 0 || row < 0 || row >= this.buffer.length || column >= this.buffer[0].length) {
            return null;
        }
        return this.buffer[row][column];
    }

    @Override
    public void copyTo(TextImage destination) {
        if (this.buffer.length > 0) {
            this.copyTo(destination, 0, this.buffer.length, 0, this.buffer[0].length, 0, 0);
        }
    }

    @Override
    public void copyTo(TextImage destination, int startRowIndex, int rows, int startColumnIndex, int columns, int destinationRowOffset, int destinationColumnOffset) {
        int y;
        if (startColumnIndex < 0) {
            destinationColumnOffset += -startColumnIndex;
            columns += startColumnIndex;
            startColumnIndex = 0;
        }
        if (startRowIndex < 0) {
            destinationRowOffset += -startRowIndex;
            rows += startRowIndex;
            startRowIndex = 0;
        }
        if (destinationColumnOffset < 0) {
            startColumnIndex -= destinationColumnOffset;
            columns += destinationColumnOffset;
            destinationColumnOffset = 0;
        }
        if (destinationRowOffset < 0) {
            startRowIndex -= destinationRowOffset;
            rows += destinationRowOffset;
            destinationRowOffset = 0;
        }
        columns = (rows = Math.min(this.buffer.length - startRowIndex, rows)) > 0 ? Math.min(this.buffer[0].length - startColumnIndex, columns) : 0;
        columns = Math.min(destination.getSize().getColumns() - destinationColumnOffset, columns);
        rows = Math.min(destination.getSize().getRows() - destinationRowOffset, rows);
        if (columns <= 0 || rows <= 0) {
            return;
        }
        TerminalSize destinationSize = destination.getSize();
        if (destination instanceof BasicTextImage) {
            int targetRow = destinationRowOffset;
            y = startRowIndex;
            while (y < startRowIndex + rows && targetRow < destinationSize.getRows()) {
                System.arraycopy(this.buffer[y], startColumnIndex, ((BasicTextImage)destination).buffer[targetRow++], destinationColumnOffset, columns);
                ++y;
            }
        } else {
            int y2 = startRowIndex;
            while (y2 < startRowIndex + rows) {
                int x = startColumnIndex;
                while (x < startColumnIndex + columns) {
                    TextCharacter character = this.buffer[y2][x];
                    if (character.isDoubleWidth()) {
                        if (x + 1 < startColumnIndex + columns) {
                            destination.setCharacterAt(x - startColumnIndex + destinationColumnOffset, y2 - startRowIndex + destinationRowOffset, character.withCharacter(' '));
                        } else if (x + 1 == startColumnIndex + columns) {
                            character = character.withCharacter(' ');
                        }
                    }
                    destination.setCharacterAt(x - startColumnIndex + destinationColumnOffset, y2 - startRowIndex + destinationRowOffset, character);
                    if (character.isDoubleWidth()) {
                        ++x;
                    }
                    ++x;
                }
                ++y2;
            }
        }
        if (destinationColumnOffset > 0) {
            int destinationX = destinationColumnOffset - 1;
            y = startRowIndex;
            while (y < startRowIndex + rows) {
                int destinationY = y - startRowIndex + destinationRowOffset;
                TextCharacter neighbour = destination.getCharacterAt(destinationX, destinationY);
                if (neighbour.isDoubleWidth()) {
                    destination.setCharacterAt(destinationX, destinationY, neighbour.withCharacter(' '));
                }
                ++y;
            }
        }
    }

    @Override
    public TextGraphics newTextGraphics() {
        return new AbstractTextGraphics(){

            @Override
            public TextGraphics setCharacter(int columnIndex, int rowIndex, TextCharacter textCharacter) {
                BasicTextImage.this.setCharacterAt(columnIndex, rowIndex, textCharacter);
                return this;
            }

            @Override
            public TextCharacter getCharacter(int column, int row) {
                return BasicTextImage.this.getCharacterAt(column, row);
            }

            @Override
            public TerminalSize getSize() {
                return BasicTextImage.this.size;
            }
        };
    }

    private TextCharacter[] newBlankLine() {
        Object[] line = new TextCharacter[this.size.getColumns()];
        Arrays.fill(line, TextCharacter.DEFAULT_CHARACTER);
        return line;
    }

    @Override
    public void scrollLines(int firstLine, int lastLine, int distance) {
        block6: {
            block7: {
                if (firstLine < 0) {
                    firstLine = 0;
                }
                if (lastLine >= this.size.getRows()) {
                    lastLine = this.size.getRows() - 1;
                }
                if (firstLine >= lastLine) break block6;
                if (distance <= 0) break block7;
                int curLine = firstLine;
                while (curLine <= lastLine - distance) {
                    this.buffer[curLine] = this.buffer[curLine + distance];
                    ++curLine;
                }
                while (curLine <= lastLine) {
                    this.buffer[curLine] = this.newBlankLine();
                    ++curLine;
                }
                break block6;
            }
            if (distance >= 0) break block6;
            int curLine = lastLine;
            distance = -distance;
            while (curLine >= firstLine + distance) {
                this.buffer[curLine] = this.buffer[curLine - distance];
                --curLine;
            }
            while (curLine >= firstLine) {
                this.buffer[curLine] = this.newBlankLine();
                --curLine;
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.size.getRows() * (this.size.getColumns() + 1) + 50);
        sb.append('{').append(this.size.getColumns()).append('x').append(this.size.getRows()).append('}').append('\n');
        TextCharacter[][] textCharacterArray = this.buffer;
        int n = this.buffer.length;
        int n2 = 0;
        while (n2 < n) {
            TextCharacter[] line;
            TextCharacter[] textCharacterArray2 = line = textCharacterArray[n2];
            int n3 = line.length;
            int n4 = 0;
            while (n4 < n3) {
                TextCharacter tc = textCharacterArray2[n4];
                sb.append(tc.getCharacterString());
                ++n4;
            }
            sb.append('\n');
            ++n2;
        }
        return sb.toString();
    }
}

