/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.gui2.AbstractComponent;
import com.googlecode.lanterna.gui2.BasePane;
import com.googlecode.lanterna.gui2.InputFilter;
import com.googlecode.lanterna.gui2.Interactable;
import com.googlecode.lanterna.gui2.InteractableRenderer;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.input.KeyType;
import com.googlecode.lanterna.input.MouseAction;
import com.googlecode.lanterna.input.MouseActionType;

public abstract class AbstractInteractableComponent<T extends AbstractInteractableComponent<T>>
extends AbstractComponent<T>
implements Interactable {
    private InputFilter inputFilter = null;
    private boolean inFocus = false;
    private boolean enabled = true;

    protected AbstractInteractableComponent() {
    }

    public T takeFocus() {
        if (!this.isEnabled()) {
            return (T)((AbstractInteractableComponent)this.self());
        }
        BasePane basePane = this.getBasePane();
        if (basePane != null) {
            basePane.setFocusedInteractable(this);
        }
        return (T)((AbstractInteractableComponent)this.self());
    }

    @Override
    public final void onEnterFocus(Interactable.FocusChangeDirection direction, Interactable previouslyInFocus) {
        this.inFocus = true;
        this.afterEnterFocus(direction, previouslyInFocus);
    }

    protected void afterEnterFocus(Interactable.FocusChangeDirection direction, Interactable previouslyInFocus) {
    }

    @Override
    public final void onLeaveFocus(Interactable.FocusChangeDirection direction, Interactable nextInFocus) {
        this.inFocus = false;
        this.afterLeaveFocus(direction, nextInFocus);
    }

    protected void afterLeaveFocus(Interactable.FocusChangeDirection direction, Interactable nextInFocus) {
    }

    @Override
    protected abstract InteractableRenderer<T> createDefaultRenderer();

    @Override
    public InteractableRenderer<T> getRenderer() {
        return (InteractableRenderer)super.getRenderer();
    }

    @Override
    public boolean isFocused() {
        return this.inFocus;
    }

    public synchronized T setEnabled(boolean enabled) {
        BasePane basePane;
        this.enabled = enabled;
        if (!enabled && this.isFocused() && (basePane = this.getBasePane()) != null) {
            basePane.setFocusedInteractable(null);
        }
        return (T)((AbstractInteractableComponent)this.self());
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public final synchronized Interactable.Result handleInput(KeyStroke keyStroke) {
        if (this.inputFilter == null || this.inputFilter.onInput(this, keyStroke)) {
            return this.handleKeyStroke(keyStroke);
        }
        return Interactable.Result.UNHANDLED;
    }

    protected Interactable.Result handleKeyStroke(KeyStroke keyStroke) {
        if (!(keyStroke.isAltDown() || keyStroke.isCtrlDown() || keyStroke.isShiftDown())) {
            switch (keyStroke.getKeyType()) {
                case ArrowDown: {
                    return Interactable.Result.MOVE_FOCUS_DOWN;
                }
                case ArrowLeft: {
                    return Interactable.Result.MOVE_FOCUS_LEFT;
                }
                case ArrowRight: {
                    return Interactable.Result.MOVE_FOCUS_RIGHT;
                }
                case ArrowUp: {
                    return Interactable.Result.MOVE_FOCUS_UP;
                }
                case Tab: {
                    return Interactable.Result.MOVE_FOCUS_NEXT;
                }
                case ReverseTab: {
                    return Interactable.Result.MOVE_FOCUS_PREVIOUS;
                }
                case MouseEvent: {
                    if (this.isMouseMove(keyStroke)) {
                        return Interactable.Result.UNHANDLED;
                    }
                    this.getBasePane().setFocusedInteractable(this);
                    return Interactable.Result.HANDLED;
                }
            }
        }
        return Interactable.Result.UNHANDLED;
    }

    @Override
    public TerminalPosition getCursorLocation() {
        return this.getRenderer().getCursorLocation((AbstractInteractableComponent)this.self());
    }

    @Override
    public InputFilter getInputFilter() {
        return this.inputFilter;
    }

    public synchronized T setInputFilter(InputFilter inputFilter) {
        this.inputFilter = inputFilter;
        return (T)((AbstractInteractableComponent)this.self());
    }

    public boolean isKeyboardActivationStroke(KeyStroke keyStroke) {
        boolean isKeyboardActivation;
        boolean bl = isKeyboardActivation = keyStroke.getKeyType() == KeyType.Character && keyStroke.getCharacter().charValue() == ' ' || keyStroke.getKeyType() == KeyType.Enter;
        return this.isFocused() && isKeyboardActivation;
    }

    public boolean isMouseActivationStroke(KeyStroke keyStroke) {
        boolean isMouseActivation = false;
        if (keyStroke instanceof MouseAction) {
            MouseAction action = (MouseAction)keyStroke;
            isMouseActivation = action.getActionType() == MouseActionType.CLICK_DOWN;
        }
        return isMouseActivation;
    }

    public boolean isActivationStroke(KeyStroke keyStroke) {
        boolean isKeyboardActivationStroke = this.isKeyboardActivationStroke(keyStroke);
        boolean isMouseActivationStroke = this.isMouseActivationStroke(keyStroke);
        return isKeyboardActivationStroke || isMouseActivationStroke;
    }

    public boolean isMouseDown(KeyStroke keyStroke) {
        return keyStroke.getKeyType() == KeyType.MouseEvent && ((MouseAction)keyStroke).isMouseDown();
    }

    public boolean isMouseDrag(KeyStroke keyStroke) {
        return keyStroke.getKeyType() == KeyType.MouseEvent && ((MouseAction)keyStroke).isMouseDrag();
    }

    public boolean isMouseMove(KeyStroke keyStroke) {
        return keyStroke.getKeyType() == KeyType.MouseEvent && ((MouseAction)keyStroke).isMouseMove();
    }

    public boolean isMouseUp(KeyStroke keyStroke) {
        return keyStroke.getKeyType() == KeyType.MouseEvent && ((MouseAction)keyStroke).isMouseUp();
    }
}

