/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.bundle.LanternaThemes;
import com.googlecode.lanterna.graphics.Theme;
import com.googlecode.lanterna.gui2.DefaultTextGUIGraphics;
import com.googlecode.lanterna.gui2.TextGUI;
import com.googlecode.lanterna.gui2.TextGUIGraphics;
import com.googlecode.lanterna.gui2.TextGUIThread;
import com.googlecode.lanterna.gui2.TextGUIThreadFactory;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.input.KeyType;
import com.googlecode.lanterna.screen.Screen;
import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AbstractTextGUI
implements TextGUI {
    private final Screen screen;
    private final List<TextGUI.Listener> listeners;
    private boolean blockingIO;
    private boolean dirty;
    private TextGUIThread textGUIThread;
    private Theme guiTheme;

    protected AbstractTextGUI(TextGUIThreadFactory textGUIThreadFactory, Screen screen) {
        if (screen == null) {
            throw new IllegalArgumentException("Creating a TextGUI requires an underlying Screen");
        }
        this.screen = screen;
        this.listeners = new CopyOnWriteArrayList<TextGUI.Listener>();
        this.blockingIO = false;
        this.dirty = false;
        this.guiTheme = LanternaThemes.getDefaultTheme();
        this.textGUIThread = textGUIThreadFactory.createTextGUIThread(this);
    }

    protected KeyStroke readKeyStroke() throws IOException {
        return this.blockingIO ? this.screen.readInput() : this.pollInput();
    }

    protected KeyStroke pollInput() throws IOException {
        return this.screen.pollInput();
    }

    @Override
    public synchronized boolean processInput() throws IOException {
        boolean gotInput = false;
        KeyStroke keyStroke = this.readKeyStroke();
        if (keyStroke != null) {
            gotInput = true;
            do {
                if (keyStroke.getKeyType() == KeyType.EOF) {
                    throw new EOFException();
                }
                boolean handled = this.handleInput(keyStroke);
                if (!handled) {
                    handled = this.fireUnhandledKeyStroke(keyStroke);
                }
                boolean bl = this.dirty = handled || this.dirty;
            } while ((keyStroke = this.pollInput()) != null);
        }
        return gotInput;
    }

    @Override
    public void setTheme(Theme theme) {
        if (theme != null) {
            this.guiTheme = theme;
        }
    }

    @Override
    public Theme getTheme() {
        return this.guiTheme;
    }

    @Override
    public synchronized void updateScreen() throws IOException {
        this.screen.doResizeIfNecessary();
        this.drawGUI(new DefaultTextGUIGraphics(this, this.screen.newTextGraphics()));
        this.screen.setCursorPosition(this.getCursorPosition());
        this.screen.refresh();
        this.dirty = false;
    }

    @Override
    public Screen getScreen() {
        return this.screen;
    }

    @Override
    public boolean isPendingUpdate() {
        return this.screen.doResizeIfNecessary() != null || this.dirty;
    }

    @Override
    public TextGUIThread getGUIThread() {
        return this.textGUIThread;
    }

    @Override
    public void addListener(TextGUI.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(TextGUI.Listener listener) {
        this.listeners.remove(listener);
    }

    public void setBlockingIO(boolean blockingIO) {
        this.blockingIO = blockingIO;
    }

    public boolean isBlockingIO() {
        return this.blockingIO;
    }

    protected final boolean fireUnhandledKeyStroke(KeyStroke keyStroke) {
        boolean handled = false;
        for (TextGUI.Listener listener : this.listeners) {
            boolean bl = handled = listener.onUnhandledKeyStroke(this, keyStroke) || handled;
        }
        return handled;
    }

    protected void invalidate() {
        this.dirty = true;
    }

    protected abstract void drawGUI(TextGUIGraphics var1);

    protected abstract TerminalPosition getCursorPosition();

    protected abstract boolean handleInput(KeyStroke var1);
}

