/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.gui2.TextGUI;
import com.googlecode.lanterna.gui2.TextGUIThread;
import java.io.EOFException;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class AbstractTextGUIThread
implements TextGUIThread {
    protected final TextGUI textGUI;
    protected final Queue<Runnable> customTasks;
    protected TextGUIThread.ExceptionHandler exceptionHandler = new TextGUIThread.ExceptionHandler(){

        @Override
        public boolean onIOException(IOException e) {
            e.printStackTrace();
            return true;
        }

        @Override
        public boolean onRuntimeException(RuntimeException e) {
            e.printStackTrace();
            return true;
        }
    };

    public AbstractTextGUIThread(TextGUI textGUI) {
        this.textGUI = textGUI;
        this.customTasks = new LinkedBlockingQueue<Runnable>();
    }

    @Override
    public void invokeLater(Runnable runnable) throws IllegalStateException {
        this.customTasks.add(runnable);
    }

    @Override
    public void setExceptionHandler(TextGUIThread.ExceptionHandler exceptionHandler) {
        if (exceptionHandler == null) {
            throw new IllegalArgumentException("Cannot call setExceptionHandler(null)");
        }
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public synchronized boolean processEventsAndUpdate() throws IOException {
        if (this.getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Calling processEventAndUpdate outside of GUI thread");
        }
        try {
            this.textGUI.processInput();
            while (!this.customTasks.isEmpty()) {
                Runnable r = this.customTasks.poll();
                if (r == null) continue;
                r.run();
            }
            if (this.textGUI.isPendingUpdate()) {
                this.textGUI.updateScreen();
                return true;
            }
            return false;
        }
        catch (EOFException e) {
            throw e;
        }
        catch (IOException e) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.onIOException(e);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.onRuntimeException(e);
            }
            throw e;
        }
        return true;
    }

    @Override
    public void invokeAndWait(Runnable runnable) throws IllegalStateException, InterruptedException {
        Thread guiThread = this.getThread();
        if (guiThread == null || Thread.currentThread() == guiThread) {
            runnable.run();
        } else {
            CountDownLatch countDownLatch = new CountDownLatch(1);
            this.invokeLater(() -> {
                try {
                    runnable.run();
                }
                finally {
                    countDownLatch.countDown();
                }
            });
            countDownLatch.await();
        }
    }
}

