/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TerminalTextUtils;
import com.googlecode.lanterna.graphics.Theme;
import com.googlecode.lanterna.graphics.ThemeDefinition;
import com.googlecode.lanterna.gui2.AbstractInteractableComponent;
import com.googlecode.lanterna.gui2.ActionListBox;
import com.googlecode.lanterna.gui2.BasicWindow;
import com.googlecode.lanterna.gui2.Interactable;
import com.googlecode.lanterna.gui2.InteractableRenderer;
import com.googlecode.lanterna.gui2.TextGUIGraphics;
import com.googlecode.lanterna.gui2.Window;
import com.googlecode.lanterna.gui2.WindowBasedTextGUI;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.input.KeyType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ComboBox<V>
extends AbstractInteractableComponent<ComboBox<V>> {
    private final List<V> items;
    private final List<Listener> listeners;
    private PopupWindow popupWindow;
    private String text;
    private int selectedIndex;
    private boolean readOnly;
    private boolean dropDownFocused;
    private int textInputPosition;
    private int dropDownNumberOfRows;

    @SafeVarargs
    public ComboBox(V ... items) {
        this((Collection<V>)Arrays.asList(items));
    }

    public ComboBox(Collection<V> items) {
        this(items, items.isEmpty() ? -1 : 0);
    }

    public ComboBox(String initialText, Collection<V> items) {
        this(items, -1);
        this.text = initialText;
    }

    public ComboBox(Collection<V> items, int selectedIndex) {
        for (V item : items) {
            if (item != null) continue;
            throw new IllegalArgumentException("Cannot add null elements to a ComboBox");
        }
        this.items = new ArrayList<V>(items);
        this.listeners = new CopyOnWriteArrayList<Listener>();
        this.popupWindow = null;
        this.selectedIndex = selectedIndex;
        this.readOnly = true;
        this.dropDownFocused = true;
        this.textInputPosition = 0;
        this.dropDownNumberOfRows = 10;
        this.text = selectedIndex != -1 ? this.items.get(selectedIndex).toString() : "";
    }

    public synchronized ComboBox<V> addItem(V item) {
        if (item == null) {
            throw new IllegalArgumentException("Cannot add null elements to a ComboBox");
        }
        this.items.add(item);
        if (this.selectedIndex == -1 && this.items.size() == 1) {
            this.setSelectedIndex(0);
        }
        this.invalidate();
        return this;
    }

    public synchronized ComboBox<V> addItem(int index, V item) {
        if (item == null) {
            throw new IllegalArgumentException("Cannot add null elements to a ComboBox");
        }
        this.items.add(index, item);
        if (index <= this.selectedIndex) {
            this.setSelectedIndex(this.selectedIndex + 1);
        }
        this.invalidate();
        return this;
    }

    public synchronized ComboBox<V> clearItems() {
        this.items.clear();
        this.setSelectedIndex(-1);
        this.invalidate();
        return this;
    }

    public synchronized ComboBox<V> removeItem(V item) {
        int index = this.items.indexOf(item);
        if (index == -1) {
            return this;
        }
        return this.removeItem(index);
    }

    public synchronized ComboBox<V> removeItem(int index) {
        this.items.remove(index);
        if (index < this.selectedIndex) {
            this.setSelectedIndex(this.selectedIndex - 1);
        } else if (index == this.selectedIndex) {
            this.setSelectedIndex(-1);
        }
        this.invalidate();
        return this;
    }

    public synchronized ComboBox<V> setItem(int index, V item) {
        if (item == null) {
            throw new IllegalArgumentException("Cannot add null elements to a ComboBox");
        }
        this.items.set(index, item);
        this.invalidate();
        return this;
    }

    public synchronized int getItemCount() {
        return this.items.size();
    }

    public synchronized V getItem(int index) {
        return this.items.get(index);
    }

    public String getText() {
        return this.text;
    }

    public synchronized ComboBox<V> setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        if (readOnly) {
            this.dropDownFocused = true;
        }
        return this;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isDropDownFocused() {
        return this.dropDownFocused || this.isReadOnly();
    }

    public int getTextInputPosition() {
        return this.textInputPosition;
    }

    public int getDropDownNumberOfRows() {
        return this.dropDownNumberOfRows;
    }

    public void setDropDownNumberOfRows(int dropDownNumberOfRows) {
        this.dropDownNumberOfRows = dropDownNumberOfRows;
    }

    public void setSelectedIndex(int selectedIndex) {
        this.setSelectedIndex(selectedIndex, false);
    }

    private synchronized void setSelectedIndex(int selectedIndex, boolean changedByUserInteraction) {
        if (this.items.size() <= selectedIndex || selectedIndex < -1) {
            throw new IndexOutOfBoundsException("Illegal argument to ComboBox.setSelectedIndex: " + selectedIndex);
        }
        int oldSelection = this.selectedIndex;
        this.selectedIndex = selectedIndex;
        if (selectedIndex == -1) {
            this.updateText("");
        } else {
            this.updateText(this.items.get(selectedIndex).toString());
        }
        this.runOnGUIThreadIfExistsOtherwiseRunDirect(() -> {
            for (Listener listener : this.listeners) {
                listener.onSelectionChanged(selectedIndex, oldSelection, changedByUserInteraction);
            }
        });
        this.invalidate();
    }

    public synchronized void setSelectedItem(V item) {
        if (item == null) {
            this.setSelectedIndex(-1);
        } else {
            int indexOf = this.items.indexOf(item);
            if (indexOf != -1) {
                this.setSelectedIndex(indexOf);
            } else if (!this.readOnly) {
                this.updateText(item.toString());
            }
        }
    }

    private void updateText(String newText) {
        this.text = newText;
        if (this.textInputPosition > this.text.length()) {
            this.textInputPosition = this.text.length();
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public synchronized V getSelectedItem() {
        return this.getSelectedIndex() > -1 ? (V)this.getItem(this.getSelectedIndex()) : null;
    }

    public ComboBox<V> addListener(Listener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
        return this;
    }

    public ComboBox<V> removeListener(Listener listener) {
        this.listeners.remove(listener);
        return this;
    }

    @Override
    protected void afterEnterFocus(Interactable.FocusChangeDirection direction, Interactable previouslyInFocus) {
        if (direction == Interactable.FocusChangeDirection.RIGHT && !this.isReadOnly()) {
            this.dropDownFocused = false;
            this.selectedIndex = 0;
        }
    }

    @Override
    protected synchronized void afterLeaveFocus(Interactable.FocusChangeDirection direction, Interactable nextInFocus) {
        if (this.popupWindow != null) {
            this.popupWindow.close();
        }
    }

    @Override
    protected InteractableRenderer<ComboBox<V>> createDefaultRenderer() {
        return new DefaultComboBoxRenderer();
    }

    @Override
    public synchronized Interactable.Result handleKeyStroke(KeyStroke keyStroke) {
        if (this.isReadOnly()) {
            return this.handleReadOnlyCBKeyStroke(keyStroke);
        }
        return this.handleEditableCBKeyStroke(keyStroke);
    }

    private Interactable.Result handleReadOnlyCBKeyStroke(KeyStroke keyStroke) {
        switch (keyStroke.getKeyType()) {
            case Character: 
            case Enter: {
                if (this.isKeyboardActivationStroke(keyStroke)) {
                    this.showPopup(keyStroke);
                }
                return super.handleKeyStroke(keyStroke);
            }
            case MouseEvent: {
                if (!this.isMouseActivationStroke(keyStroke)) break;
                this.showPopup(keyStroke);
            }
        }
        return super.handleKeyStroke(keyStroke);
    }

    protected void showPopup(KeyStroke keyStroke) {
        this.popupWindow = new PopupWindow();
        this.popupWindow.setPosition(this.toGlobal(new TerminalPosition(0, 1)));
        ((WindowBasedTextGUI)this.getTextGUI()).addWindow(this.popupWindow);
        ((WindowBasedTextGUI)this.getTextGUI()).setActiveWindow(this.popupWindow);
    }

    private Interactable.Result handleEditableCBKeyStroke(KeyStroke keyStroke) {
        if (this.isDropDownFocused()) {
            switch (keyStroke.getKeyType()) {
                case ArrowLeft: 
                case ReverseTab: {
                    this.dropDownFocused = false;
                    this.textInputPosition = this.text.length();
                    return Interactable.Result.HANDLED;
                }
            }
            return this.handleReadOnlyCBKeyStroke(keyStroke);
        }
        switch (keyStroke.getKeyType()) {
            case Character: {
                this.text = String.valueOf(this.text.substring(0, this.textInputPosition)) + keyStroke.getCharacter() + this.text.substring(this.textInputPosition);
                ++this.textInputPosition;
                return Interactable.Result.HANDLED;
            }
            case Tab: {
                this.dropDownFocused = true;
                return Interactable.Result.HANDLED;
            }
            case Backspace: {
                if (this.textInputPosition > 0) {
                    this.text = String.valueOf(this.text.substring(0, this.textInputPosition - 1)) + this.text.substring(this.textInputPosition);
                    --this.textInputPosition;
                }
                return Interactable.Result.HANDLED;
            }
            case Delete: {
                if (this.textInputPosition < this.text.length()) {
                    this.text = String.valueOf(this.text.substring(0, this.textInputPosition)) + this.text.substring(this.textInputPosition + 1);
                }
                return Interactable.Result.HANDLED;
            }
            case ArrowLeft: {
                if (this.textInputPosition > 0) {
                    --this.textInputPosition;
                } else {
                    return Interactable.Result.MOVE_FOCUS_LEFT;
                }
                return Interactable.Result.HANDLED;
            }
            case ArrowRight: {
                if (this.textInputPosition < this.text.length()) {
                    ++this.textInputPosition;
                } else {
                    this.dropDownFocused = true;
                    return Interactable.Result.HANDLED;
                }
                return Interactable.Result.HANDLED;
            }
            case ArrowDown: {
                if (this.selectedIndex < this.items.size() - 1) {
                    this.setSelectedIndex(this.selectedIndex + 1, true);
                }
                return Interactable.Result.HANDLED;
            }
            case ArrowUp: {
                if (this.selectedIndex > 0) {
                    this.setSelectedIndex(this.selectedIndex - 1, true);
                }
                return Interactable.Result.HANDLED;
            }
        }
        return super.handleKeyStroke(keyStroke);
    }

    public static abstract class ComboBoxRenderer<V>
    implements InteractableRenderer<ComboBox<V>> {
    }

    public static class DefaultComboBoxRenderer<V>
    extends ComboBoxRenderer<V> {
        private int textVisibleLeftPosition = 0;

        @Override
        public TerminalPosition getCursorLocation(ComboBox<V> comboBox) {
            if (comboBox.isDropDownFocused()) {
                if (comboBox.getThemeDefinition().isCursorVisible()) {
                    return new TerminalPosition(comboBox.getSize().getColumns() - 1, 0);
                }
                return null;
            }
            int textInputPosition = comboBox.getTextInputPosition();
            int textInputColumn = TerminalTextUtils.getColumnWidth(comboBox.getText().substring(0, textInputPosition));
            return new TerminalPosition(textInputColumn - this.textVisibleLeftPosition, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TerminalSize getPreferredSize(ComboBox<V> comboBox) {
            TerminalSize size = TerminalSize.ONE.withColumns((comboBox.getItemCount() == 0 ? TerminalTextUtils.getColumnWidth(comboBox.getText()) : 0) + 2);
            ComboBox<V> comboBox2 = comboBox;
            synchronized (comboBox2) {
                int i = 0;
                while (i < comboBox.getItemCount()) {
                    V item = comboBox.getItem(i);
                    size = size.max(new TerminalSize(TerminalTextUtils.getColumnWidth(item.toString()) + 2 + 1, 1));
                    ++i;
                }
            }
            return size;
        }

        @Override
        public void drawComponent(TextGUIGraphics graphics, ComboBox<V> comboBox) {
            ThemeDefinition themeDefinition = comboBox.getThemeDefinition();
            if (comboBox.isReadOnly()) {
                graphics.applyThemeStyle(themeDefinition.getNormal());
            } else if (comboBox.isFocused()) {
                graphics.applyThemeStyle(themeDefinition.getActive());
            } else {
                graphics.applyThemeStyle(themeDefinition.getPreLight());
            }
            graphics.fill(' ');
            int editableArea = graphics.getSize().getColumns() - 2;
            int textInputPosition = comboBox.getTextInputPosition();
            int columnsToInputPosition = TerminalTextUtils.getColumnWidth(comboBox.getText().substring(0, textInputPosition));
            if (columnsToInputPosition < this.textVisibleLeftPosition) {
                this.textVisibleLeftPosition = columnsToInputPosition;
            }
            if (columnsToInputPosition - this.textVisibleLeftPosition >= editableArea) {
                this.textVisibleLeftPosition = columnsToInputPosition - editableArea + 1;
            }
            if (columnsToInputPosition - this.textVisibleLeftPosition + 1 == editableArea && comboBox.getText().length() > textInputPosition && TerminalTextUtils.isCharCJK(comboBox.getText().charAt(textInputPosition))) {
                ++this.textVisibleLeftPosition;
            }
            String textToDraw = TerminalTextUtils.fitString(comboBox.getText(), this.textVisibleLeftPosition, editableArea);
            graphics.putString(0, 0, textToDraw);
            graphics.applyThemeStyle(themeDefinition.getInsensitive());
            graphics.setCharacter(editableArea, 0, themeDefinition.getCharacter("POPUP_SEPARATOR", '\u2502'));
            if (comboBox.isFocused() && comboBox.isDropDownFocused()) {
                graphics.applyThemeStyle(themeDefinition.getSelected());
            }
            graphics.setCharacter(editableArea + 1, 0, themeDefinition.getCharacter("POPUP", '\u25bc'));
        }
    }

    public static interface Listener {
        public void onSelectionChanged(int var1, int var2, boolean var3);
    }

    private class PopupWindow
    extends BasicWindow {
        private final ActionListBox listBox;

        public PopupWindow() {
            this.setHints(Arrays.asList(Window.Hint.NO_FOCUS, Window.Hint.FIXED_POSITION, Window.Hint.MENU_POPUP));
            this.listBox = new ActionListBox(ComboBox.this.getSize().withRows(ComboBox.this.getItemCount()));
            int i = 0;
            while (i < ComboBox.this.getItemCount()) {
                Object item = ComboBox.this.items.get(i);
                int index = i++;
                this.listBox.addItem(item.toString(), () -> {
                    ComboBox.this.setSelectedIndex(index, true);
                    this.close();
                });
            }
            this.listBox.setSelectedIndex(ComboBox.this.getSelectedIndex());
            TerminalSize dropDownListPreferedSize = this.listBox.getPreferredSize();
            if (ComboBox.this.dropDownNumberOfRows > 0) {
                this.listBox.setPreferredSize(dropDownListPreferedSize.withRows(Math.min(ComboBox.this.dropDownNumberOfRows, dropDownListPreferedSize.getRows())));
            }
            this.setComponent(this.listBox);
        }

        @Override
        public void close() {
            super.close();
            ComboBox.this.popupWindow = null;
        }

        @Override
        public synchronized Theme getTheme() {
            return ComboBox.this.getTheme();
        }

        @Override
        public synchronized boolean handleInput(KeyStroke keyStroke) {
            if (keyStroke.getKeyType() == KeyType.Escape) {
                this.close();
                return true;
            }
            return super.handleInput(keyStroke);
        }
    }
}

