/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.LayoutData;
import com.googlecode.lanterna.gui2.LayoutManager;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class GridLayout
implements LayoutManager {
    private static final GridLayoutData DEFAULT = new GridLayoutData(Alignment.BEGINNING, Alignment.BEGINNING, false, false, 1, 1);
    private final int numberOfColumns;
    private int horizontalSpacing;
    private int verticalSpacing;
    private int topMarginSize;
    private int bottomMarginSize;
    private int leftMarginSize;
    private int rightMarginSize;
    private boolean changed;

    public static LayoutData createLayoutData(Alignment horizontalAlignment, Alignment verticalAlignment) {
        return GridLayout.createLayoutData(horizontalAlignment, verticalAlignment, false, false);
    }

    public static LayoutData createLayoutData(Alignment horizontalAlignment, Alignment verticalAlignment, boolean grabExtraHorizontalSpace, boolean grabExtraVerticalSpace) {
        return GridLayout.createLayoutData(horizontalAlignment, verticalAlignment, grabExtraHorizontalSpace, grabExtraVerticalSpace, 1, 1);
    }

    public static LayoutData createLayoutData(Alignment horizontalAlignment, Alignment verticalAlignment, boolean grabExtraHorizontalSpace, boolean grabExtraVerticalSpace, int horizontalSpan, int verticalSpan) {
        return new GridLayoutData(horizontalAlignment, verticalAlignment, grabExtraHorizontalSpace, grabExtraVerticalSpace, horizontalSpan, verticalSpan);
    }

    public static LayoutData createHorizontallyFilledLayoutData() {
        return GridLayout.createLayoutData(Alignment.FILL, Alignment.CENTER, true, false, 1, 1);
    }

    public static LayoutData createHorizontallyFilledLayoutData(int horizontalSpan) {
        return GridLayout.createLayoutData(Alignment.FILL, Alignment.CENTER, true, false, horizontalSpan, 1);
    }

    public static LayoutData createHorizontallyEndAlignedLayoutData(int horizontalSpan) {
        return GridLayout.createLayoutData(Alignment.END, Alignment.CENTER, true, false, horizontalSpan, 1);
    }

    public GridLayout(int numberOfColumns) {
        this.numberOfColumns = numberOfColumns;
        this.horizontalSpacing = 1;
        this.verticalSpacing = 0;
        this.topMarginSize = 0;
        this.bottomMarginSize = 0;
        this.leftMarginSize = 1;
        this.rightMarginSize = 1;
        this.changed = true;
    }

    public int getHorizontalSpacing() {
        return this.horizontalSpacing;
    }

    public GridLayout setHorizontalSpacing(int horizontalSpacing) {
        if (horizontalSpacing < 0) {
            throw new IllegalArgumentException("Horizontal spacing cannot be less than 0");
        }
        this.horizontalSpacing = horizontalSpacing;
        this.changed = true;
        return this;
    }

    public int getVerticalSpacing() {
        return this.verticalSpacing;
    }

    public GridLayout setVerticalSpacing(int verticalSpacing) {
        if (verticalSpacing < 0) {
            throw new IllegalArgumentException("Vertical spacing cannot be less than 0");
        }
        this.verticalSpacing = verticalSpacing;
        this.changed = true;
        return this;
    }

    public int getTopMarginSize() {
        return this.topMarginSize;
    }

    public GridLayout setTopMarginSize(int topMarginSize) {
        if (topMarginSize < 0) {
            throw new IllegalArgumentException("Top margin size cannot be less than 0");
        }
        this.topMarginSize = topMarginSize;
        this.changed = true;
        return this;
    }

    public int getBottomMarginSize() {
        return this.bottomMarginSize;
    }

    public GridLayout setBottomMarginSize(int bottomMarginSize) {
        if (bottomMarginSize < 0) {
            throw new IllegalArgumentException("Bottom margin size cannot be less than 0");
        }
        this.bottomMarginSize = bottomMarginSize;
        this.changed = true;
        return this;
    }

    public int getLeftMarginSize() {
        return this.leftMarginSize;
    }

    public GridLayout setLeftMarginSize(int leftMarginSize) {
        if (leftMarginSize < 0) {
            throw new IllegalArgumentException("Left margin size cannot be less than 0");
        }
        this.leftMarginSize = leftMarginSize;
        this.changed = true;
        return this;
    }

    public int getRightMarginSize() {
        return this.rightMarginSize;
    }

    public GridLayout setRightMarginSize(int rightMarginSize) {
        if (rightMarginSize < 0) {
            throw new IllegalArgumentException("Right margin size cannot be less than 0");
        }
        this.rightMarginSize = rightMarginSize;
        this.changed = true;
        return this;
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public TerminalSize getPreferredSize(List<Component> components) {
        TerminalSize preferredSize = TerminalSize.ZERO;
        if (components.isEmpty()) {
            return preferredSize.withRelative(this.leftMarginSize + this.rightMarginSize, this.topMarginSize + this.bottomMarginSize);
        }
        Component[][] table = this.buildTable(components);
        table = this.eliminateUnusedRowsAndColumns(table);
        int preferredWidth = 0;
        int preferredHeight = 0;
        int[] nArray = this.getPreferredColumnWidths(table);
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int width = nArray[n2];
            preferredWidth += width;
            ++n2;
        }
        nArray = this.getPreferredRowHeights(table);
        n = nArray.length;
        n2 = 0;
        while (n2 < n) {
            int height = nArray[n2];
            preferredHeight += height;
            ++n2;
        }
        preferredSize = preferredSize.withRelative(preferredWidth, preferredHeight);
        preferredSize = preferredSize.withRelativeColumns(this.leftMarginSize + this.rightMarginSize + (table[0].length - 1) * this.horizontalSpacing);
        preferredSize = preferredSize.withRelativeRows(this.topMarginSize + this.bottomMarginSize + (table.length - 1) * this.verticalSpacing);
        return preferredSize;
    }

    @Override
    public void doLayout(TerminalSize area, List<Component> components) {
        Component[][] table = this.buildTable(components);
        table = this.eliminateUnusedRowsAndColumns(table);
        if (area.equals(TerminalSize.ZERO) || table.length == 0 || area.getColumns() <= this.leftMarginSize + this.rightMarginSize + (table[0].length - 1) * this.horizontalSpacing || area.getRows() <= this.bottomMarginSize + this.topMarginSize + (table.length - 1) * this.verticalSpacing) {
            this.changed = false;
            return;
        }
        area = area.withRelative(-this.leftMarginSize - this.rightMarginSize, -this.topMarginSize - this.bottomMarginSize);
        IdentityHashMap<Component, TerminalSize> sizeMap = new IdentityHashMap<Component, TerminalSize>();
        IdentityHashMap<Component, TerminalPosition> positionMap = new IdentityHashMap<Component, TerminalPosition>();
        int[] columnWidths = this.getPreferredColumnWidths(table);
        Set<Integer> expandableColumns = this.getExpandableColumns(table);
        TerminalSize areaWithoutHorizontalSpacing = area.withRelativeColumns(-this.horizontalSpacing * (table[0].length - 1));
        int totalWidth = this.shrinkWidthToFitArea(areaWithoutHorizontalSpacing, columnWidths);
        while (areaWithoutHorizontalSpacing.getColumns() > totalWidth && !expandableColumns.isEmpty()) {
            totalWidth = this.grabExtraHorizontalSpace(areaWithoutHorizontalSpacing, columnWidths, expandableColumns, totalWidth);
        }
        int[] rowHeights = this.getPreferredRowHeights(table);
        Set<Integer> expandableRows = this.getExpandableRows(table);
        TerminalSize areaWithoutVerticalSpacing = area.withRelativeRows(-this.verticalSpacing * (table.length - 1));
        int totalHeight = this.shrinkHeightToFitArea(areaWithoutVerticalSpacing, rowHeights);
        while (areaWithoutVerticalSpacing.getRows() > totalHeight && !expandableRows.isEmpty()) {
            totalHeight = this.grabExtraVerticalSpace(areaWithoutVerticalSpacing, rowHeights, expandableRows, totalHeight);
        }
        TerminalPosition tableCellTopLeft = TerminalPosition.TOP_LEFT_CORNER;
        int y = 0;
        while (y < table.length) {
            tableCellTopLeft = tableCellTopLeft.withColumn(0);
            int x = 0;
            while (x < table[y].length) {
                Component component = table[y][x];
                if (component != null && !positionMap.containsKey(component)) {
                    GridLayoutData layoutData = this.getLayoutData(component);
                    TerminalSize size = component.getPreferredSize();
                    TerminalPosition position = tableCellTopLeft;
                    int availableHorizontalSpace = 0;
                    int availableVerticalSpace = 0;
                    int i = 0;
                    while (i < layoutData.horizontalSpan && x + i < columnWidths.length) {
                        availableHorizontalSpace += columnWidths[x + i] + (i > 0 ? this.horizontalSpacing : 0);
                        ++i;
                    }
                    i = 0;
                    while (i < layoutData.verticalSpan) {
                        availableVerticalSpace += rowHeights[y + i] + (i > 0 ? this.verticalSpacing : 0);
                        ++i;
                    }
                    size = size.withColumns(Math.min(size.getColumns(), availableHorizontalSpace));
                    size = size.withRows(Math.min(size.getRows(), availableVerticalSpace));
                    switch (layoutData.horizontalAlignment) {
                        case CENTER: {
                            position = position.withRelativeColumn((availableHorizontalSpace - size.getColumns()) / 2);
                            break;
                        }
                        case END: {
                            position = position.withRelativeColumn(availableHorizontalSpace - size.getColumns());
                            break;
                        }
                        case FILL: {
                            size = size.withColumns(availableHorizontalSpace);
                            break;
                        }
                    }
                    switch (layoutData.verticalAlignment) {
                        case CENTER: {
                            position = position.withRelativeRow((availableVerticalSpace - size.getRows()) / 2);
                            break;
                        }
                        case END: {
                            position = position.withRelativeRow(availableVerticalSpace - size.getRows());
                            break;
                        }
                        case FILL: {
                            size = size.withRows(availableVerticalSpace);
                            break;
                        }
                    }
                    sizeMap.put(component, size);
                    positionMap.put(component, position);
                }
                tableCellTopLeft = tableCellTopLeft.withRelativeColumn(columnWidths[x] + this.horizontalSpacing);
                ++x;
            }
            tableCellTopLeft = tableCellTopLeft.withRelativeRow(rowHeights[y] + this.verticalSpacing);
            ++y;
        }
        for (Component component : components) {
            component.setPosition(((TerminalPosition)positionMap.get(component)).withRelative(this.leftMarginSize, this.topMarginSize));
            component.setSize((TerminalSize)sizeMap.get(component));
        }
        this.changed = false;
    }

    private int[] getPreferredColumnWidths(Component[][] table) {
        GridLayoutData layoutData;
        Component component;
        int i;
        Component[] row;
        int actualNumberOfColumns = table[0].length;
        int[] columnWidths = new int[actualNumberOfColumns];
        Component[][] componentArray = table;
        int n = table.length;
        int n2 = 0;
        while (n2 < n) {
            row = componentArray[n2];
            i = 0;
            while (i < actualNumberOfColumns) {
                component = row[i];
                if (component != null) {
                    layoutData = this.getLayoutData(component);
                    if (layoutData.horizontalSpan == 1) {
                        columnWidths[i] = Math.max(columnWidths[i], component.getPreferredSize().getColumns());
                    }
                }
                ++i;
            }
            ++n2;
        }
        componentArray = table;
        n = table.length;
        n2 = 0;
        while (n2 < n) {
            row = componentArray[n2];
            i = 0;
            while (i < actualNumberOfColumns) {
                component = row[i];
                if (component == null) {
                    ++i;
                    continue;
                }
                layoutData = this.getLayoutData(component);
                int horizontalSpan = Math.min(layoutData.horizontalSpan, actualNumberOfColumns - i);
                if (horizontalSpan > 1) {
                    int accumWidth = 0;
                    int j = i;
                    while (j < i + horizontalSpan) {
                        accumWidth += columnWidths[j];
                        ++j;
                    }
                    int preferredWidth = component.getPreferredSize().getColumns();
                    if (preferredWidth > accumWidth) {
                        int columnOffset = 0;
                        do {
                            int n3 = i + columnOffset++;
                            columnWidths[n3] = columnWidths[n3] + 1;
                            ++accumWidth;
                            if (columnOffset != horizontalSpan) continue;
                            columnOffset = 0;
                        } while (preferredWidth > accumWidth);
                    }
                }
                i += horizontalSpan;
            }
            ++n2;
        }
        return columnWidths;
    }

    private int[] getPreferredRowHeights(Component[][] table) {
        int numberOfRows = table.length;
        int[] rowHeights = new int[numberOfRows];
        int rowIndex = 0;
        Component[][] componentArray = table;
        int n = table.length;
        int n2 = 0;
        while (n2 < n) {
            Component[] row;
            Component[] componentArray2 = row = componentArray[n2];
            int n3 = row.length;
            int n4 = 0;
            while (n4 < n3) {
                Component component = componentArray2[n4];
                if (component != null) {
                    GridLayoutData layoutData = this.getLayoutData(component);
                    if (layoutData.verticalSpan == 1) {
                        rowHeights[rowIndex] = Math.max(rowHeights[rowIndex], component.getPreferredSize().getRows());
                    }
                }
                ++n4;
            }
            ++rowIndex;
            ++n2;
        }
        int x = 0;
        while (x < this.numberOfColumns) {
            int y = 0;
            while (y < numberOfRows) {
                if (x >= table[y].length) {
                    ++y;
                    continue;
                }
                Component component = table[y][x];
                if (component == null) {
                    ++y;
                    continue;
                }
                GridLayoutData layoutData = this.getLayoutData(component);
                if (layoutData.verticalSpan > 1) {
                    int accumulatedHeight = 0;
                    int i = y;
                    while (i < y + layoutData.verticalSpan) {
                        accumulatedHeight += rowHeights[i];
                        ++i;
                    }
                    int preferredHeight = component.getPreferredSize().getRows();
                    if (preferredHeight > accumulatedHeight) {
                        int rowOffset = 0;
                        do {
                            int n5 = y + rowOffset++;
                            rowHeights[n5] = rowHeights[n5] + 1;
                            ++accumulatedHeight;
                            if (rowOffset != layoutData.verticalSpan) continue;
                            rowOffset = 0;
                        } while (preferredHeight > accumulatedHeight);
                    }
                }
                y += layoutData.verticalSpan;
            }
            ++x;
        }
        return rowHeights;
    }

    private Set<Integer> getExpandableColumns(Component[][] table) {
        TreeSet<Integer> expandableColumns = new TreeSet<Integer>();
        Component previousComponent = null;
        Component[][] componentArray = table;
        int n = table.length;
        int n2 = 0;
        while (n2 < n) {
            Component[] row = componentArray[n2];
            int i = 0;
            while (i < row.length) {
                if (row[i] != null && row[i] != previousComponent) {
                    GridLayoutData layoutData = this.getLayoutData(row[i]);
                    if (layoutData.grabExtraHorizontalSpace) {
                        expandableColumns.add(i);
                    }
                    previousComponent = row[i];
                }
                ++i;
            }
            ++n2;
        }
        return expandableColumns;
    }

    private Set<Integer> getExpandableRows(Component[][] table) {
        TreeSet<Integer> expandableRows = new TreeSet<Integer>();
        Component previousComponent = null;
        if (table.length > 0) {
            int columnIndex = 0;
            while (columnIndex < table[0].length) {
                int rowIndex = 0;
                while (rowIndex < table.length) {
                    Component cell = table[rowIndex][columnIndex];
                    if (cell != null && cell != previousComponent) {
                        GridLayoutData layoutData = this.getLayoutData(cell);
                        if (layoutData.grabExtraVerticalSpace) {
                            expandableRows.add(rowIndex);
                        }
                        previousComponent = cell;
                    }
                    ++rowIndex;
                }
                ++columnIndex;
            }
        }
        return expandableRows;
    }

    private int shrinkWidthToFitArea(TerminalSize area, int[] columnWidths) {
        int totalWidth = 0;
        int[] nArray = columnWidths;
        int n = columnWidths.length;
        int n2 = 0;
        while (n2 < n) {
            int width = nArray[n2];
            totalWidth += width;
            ++n2;
        }
        if (totalWidth > area.getColumns()) {
            int columnOffset = 0;
            do {
                if (columnWidths[columnOffset] > 0) {
                    int n3 = columnOffset;
                    columnWidths[n3] = columnWidths[n3] - 1;
                    --totalWidth;
                }
                if (++columnOffset != columnWidths.length) continue;
                columnOffset = 0;
            } while (totalWidth > area.getColumns());
        }
        return totalWidth;
    }

    private int shrinkHeightToFitArea(TerminalSize area, int[] rowHeights) {
        int totalHeight = 0;
        int[] nArray = rowHeights;
        int n = rowHeights.length;
        int n2 = 0;
        while (n2 < n) {
            int height = nArray[n2];
            totalHeight += height;
            ++n2;
        }
        if (totalHeight > area.getRows()) {
            int rowOffset = 0;
            do {
                if (rowHeights[rowOffset] > 0) {
                    int n3 = rowOffset;
                    rowHeights[n3] = rowHeights[n3] - 1;
                    --totalHeight;
                }
                if (++rowOffset != rowHeights.length) continue;
                rowOffset = 0;
            } while (totalHeight > area.getRows());
        }
        return totalHeight;
    }

    private int grabExtraHorizontalSpace(TerminalSize area, int[] columnWidths, Set<Integer> expandableColumns, int totalWidth) {
        Iterator<Integer> iterator = expandableColumns.iterator();
        while (iterator.hasNext()) {
            int columnIndex;
            int n = columnIndex = iterator.next().intValue();
            columnWidths[n] = columnWidths[n] + 1;
            if (area.getColumns() == ++totalWidth) break;
        }
        return totalWidth;
    }

    private int grabExtraVerticalSpace(TerminalSize area, int[] rowHeights, Set<Integer> expandableRows, int totalHeight) {
        Iterator<Integer> iterator = expandableRows.iterator();
        while (iterator.hasNext()) {
            int rowIndex;
            int n = rowIndex = iterator.next().intValue();
            rowHeights[n] = rowHeights[n] + 1;
            if (area.getColumns() == ++totalHeight) break;
        }
        return totalHeight;
    }

    private Component[][] buildTable(List<Component> components) {
        ArrayList<Component[]> rows = new ArrayList<Component[]>();
        ArrayList<int[]> hspans = new ArrayList<int[]>();
        ArrayList<int[]> vspans = new ArrayList<int[]>();
        int rowCount = 0;
        int rowsExtent = 1;
        LinkedList<Component> toBePlaced = new LinkedList<Component>(components);
        while (!toBePlaced.isEmpty() || rowCount < rowsExtent) {
            Component[] row = new Component[this.numberOfColumns];
            int[] hspan = new int[this.numberOfColumns];
            int[] vspan = new int[this.numberOfColumns];
            int i = 0;
            while (i < this.numberOfColumns) {
                if (i > 0 && hspan[i - 1] > 1) {
                    row[i] = row[i - 1];
                    hspan[i] = hspan[i - 1] - 1;
                    vspan[i] = vspan[i - 1];
                } else if (rowCount > 0 && ((int[])vspans.get(rowCount - 1))[i] > 1) {
                    row[i] = ((Component[])rows.get(rowCount - 1))[i];
                    hspan[i] = ((int[])hspans.get(rowCount - 1))[i];
                    vspan[i] = ((int[])vspans.get(rowCount - 1))[i] - 1;
                } else if (!toBePlaced.isEmpty()) {
                    Component component = (Component)toBePlaced.poll();
                    GridLayoutData gridLayoutData = this.getLayoutData(component);
                    row[i] = component;
                    hspan[i] = gridLayoutData.horizontalSpan;
                    vspan[i] = gridLayoutData.verticalSpan;
                    rowsExtent = Math.max(rowsExtent, rowCount + gridLayoutData.verticalSpan);
                } else {
                    row[i] = null;
                    hspan[i] = 1;
                    vspan[i] = 1;
                }
                ++i;
            }
            rows.add(row);
            hspans.add(hspan);
            vspans.add(vspan);
            ++rowCount;
        }
        return (Component[][])rows.toArray((T[])new Component[rows.size()][]);
    }

    private Component[][] eliminateUnusedRowsAndColumns(Component[][] table) {
        int n;
        if (table.length == 0) {
            return table;
        }
        ArrayList<Integer> rowsToRemove = new ArrayList<Integer>();
        ArrayList<Integer> columnsToRemove = new ArrayList<Integer>();
        int tableRows = table.length;
        int tableColumns = table[0].length;
        int column = tableColumns - 1;
        while (column > 0) {
            block11: {
                Component[][] componentArray = table;
                n = table.length;
                int n2 = 0;
                while (n2 < n) {
                    Component[] row = componentArray[n2];
                    if (row[column] == null) {
                        ++n2;
                        continue;
                    }
                    break block11;
                }
                columnsToRemove.add(column);
            }
            --column;
        }
        int row = tableRows - 1;
        while (row > 0) {
            block12: {
                int column2 = 0;
                while (column2 < tableColumns) {
                    if (table[row][column2] == null) {
                        ++column2;
                        continue;
                    }
                    break block12;
                }
                rowsToRemove.add(row);
            }
            --row;
        }
        if (rowsToRemove.isEmpty() && columnsToRemove.isEmpty()) {
            return table;
        }
        Component[][] newTable = new Component[tableRows - rowsToRemove.size()][];
        int insertedRowCounter = 0;
        Component[][] componentArray = table;
        int n3 = table.length;
        n = 0;
        while (n < n3) {
            Component[] row2 = componentArray[n];
            Component[] newColumn = new Component[tableColumns - columnsToRemove.size()];
            int insertedColumnCounter = 0;
            int column3 = 0;
            while (column3 < tableColumns) {
                if (!columnsToRemove.contains(column3)) {
                    newColumn[insertedColumnCounter++] = row2[column3];
                }
                ++column3;
            }
            newTable[insertedRowCounter++] = newColumn;
            ++n;
        }
        return newTable;
    }

    private GridLayoutData getLayoutData(Component component) {
        LayoutData layoutData = component.getLayoutData();
        if (layoutData instanceof GridLayoutData) {
            return (GridLayoutData)layoutData;
        }
        return DEFAULT;
    }

    public static enum Alignment {
        BEGINNING,
        CENTER,
        END,
        FILL;

    }

    static class GridLayoutData
    implements LayoutData {
        final Alignment horizontalAlignment;
        final Alignment verticalAlignment;
        final boolean grabExtraHorizontalSpace;
        final boolean grabExtraVerticalSpace;
        final int horizontalSpan;
        final int verticalSpan;

        private GridLayoutData(Alignment horizontalAlignment, Alignment verticalAlignment, boolean grabExtraHorizontalSpace, boolean grabExtraVerticalSpace, int horizontalSpan, int verticalSpan) {
            if (horizontalSpan < 1 || verticalSpan < 1) {
                throw new IllegalArgumentException("Horizontal/Vertical span must be 1 or greater");
            }
            this.horizontalAlignment = horizontalAlignment;
            this.verticalAlignment = verticalAlignment;
            this.grabExtraHorizontalSpace = grabExtraHorizontalSpace;
            this.grabExtraVerticalSpace = grabExtraVerticalSpace;
            this.horizontalSpan = horizontalSpan;
            this.verticalSpan = verticalSpan;
        }
    }
}

