/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.Direction;
import com.googlecode.lanterna.gui2.LayoutData;
import com.googlecode.lanterna.gui2.LayoutManager;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.stream.Collectors;

public class LinearLayout
implements LayoutManager {
    private final Direction direction;
    private int spacing;
    private boolean changed;

    public static LayoutData createLayoutData(Alignment alignment) {
        return LinearLayout.createLayoutData(alignment, GrowPolicy.None);
    }

    public static LayoutData createLayoutData(Alignment alignment, GrowPolicy growPolicy) {
        return new LinearLayoutData(alignment, growPolicy);
    }

    public LinearLayout() {
        this(Direction.VERTICAL);
    }

    public LinearLayout(Direction direction) {
        this.direction = direction;
        this.spacing = direction == Direction.HORIZONTAL ? 1 : 0;
        this.changed = true;
    }

    public LinearLayout setSpacing(int spacing) {
        this.spacing = spacing;
        this.changed = true;
        return this;
    }

    public int getSpacing() {
        return this.spacing;
    }

    @Override
    public TerminalSize getPreferredSize(List<Component> components) {
        components = components.stream().filter(Component::isVisible).collect(Collectors.toList());
        if (this.direction == Direction.VERTICAL) {
            return this.getPreferredSizeVertically(components);
        }
        return this.getPreferredSizeHorizontally(components);
    }

    private TerminalSize getPreferredSizeVertically(List<Component> components) {
        int maxWidth = 0;
        int height = 0;
        for (Component component : components) {
            TerminalSize preferredSize = component.getPreferredSize();
            if (maxWidth < preferredSize.getColumns()) {
                maxWidth = preferredSize.getColumns();
            }
            height += preferredSize.getRows();
        }
        return new TerminalSize(maxWidth, Math.max(0, height += this.spacing * (components.size() - 1)));
    }

    private TerminalSize getPreferredSizeHorizontally(List<Component> components) {
        int maxHeight = 0;
        int width = 0;
        for (Component component : components) {
            TerminalSize preferredSize = component.getPreferredSize();
            if (maxHeight < preferredSize.getRows()) {
                maxHeight = preferredSize.getRows();
            }
            width += preferredSize.getColumns();
        }
        return new TerminalSize(Math.max(0, width += this.spacing * (components.size() - 1)), maxHeight);
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public void doLayout(TerminalSize area, List<Component> components) {
        components = components.stream().filter(Component::isVisible).collect(Collectors.toList());
        if (this.direction == Direction.VERTICAL) {
            if (Boolean.getBoolean("com.googlecode.lanterna.gui2.LinearLayout.useOldNonFlexLayout")) {
                this.doVerticalLayout(area, components);
            } else {
                this.doFlexibleVerticalLayout(area, components);
            }
        } else if (Boolean.getBoolean("com.googlecode.lanterna.gui2.LinearLayout.useOldNonFlexLayout")) {
            this.doHorizontalLayout(area, components);
        } else {
            this.doFlexibleHorizontalLayout(area, components);
        }
        this.changed = false;
    }

    @Deprecated
    private void doVerticalLayout(TerminalSize area, List<Component> components) {
        int remainingVerticalSpace = area.getRows();
        int availableHorizontalSpace = area.getColumns();
        for (Component component : components) {
            if (remainingVerticalSpace <= 0) {
                component.setPosition(TerminalPosition.TOP_LEFT_CORNER);
                component.setSize(TerminalSize.ZERO);
                continue;
            }
            Alignment alignment = Alignment.Beginning;
            LayoutData layoutData = component.getLayoutData();
            if (layoutData instanceof LinearLayoutData) {
                alignment = ((LinearLayoutData)layoutData).alignment;
            }
            TerminalSize preferredSize = component.getPreferredSize();
            TerminalSize decidedSize = new TerminalSize(Math.min(availableHorizontalSpace, preferredSize.getColumns()), Math.min(remainingVerticalSpace, preferredSize.getRows()));
            if (alignment == Alignment.Fill) {
                decidedSize = decidedSize.withColumns(availableHorizontalSpace);
                alignment = Alignment.Beginning;
            }
            TerminalPosition position = component.getPosition();
            position = position.withRow(area.getRows() - remainingVerticalSpace);
            switch (alignment) {
                case End: {
                    position = position.withColumn(availableHorizontalSpace - decidedSize.getColumns());
                    break;
                }
                case Center: {
                    position = position.withColumn((availableHorizontalSpace - decidedSize.getColumns()) / 2);
                    break;
                }
                default: {
                    position = position.withColumn(0);
                }
            }
            component.setPosition(position);
            component.setSize(component.getSize().with(decidedSize));
            remainingVerticalSpace -= decidedSize.getRows() + this.spacing;
        }
    }

    private void doFlexibleVerticalLayout(TerminalSize area, List<Component> components) {
        LayoutData layoutData;
        int availableVerticalSpace = area.getRows();
        int availableHorizontalSpace = area.getColumns();
        ArrayList<Component> copyOfComponenets = new ArrayList<Component>(components);
        IdentityHashMap<Component, TerminalSize> fittingMap = new IdentityHashMap<Component, TerminalSize>();
        int totalRequiredVerticalSpace = 0;
        for (Component component : components) {
            Alignment alignment = Alignment.Beginning;
            layoutData = component.getLayoutData();
            if (layoutData instanceof LinearLayoutData) {
                alignment = ((LinearLayoutData)layoutData).alignment;
            }
            TerminalSize preferredSize = component.getPreferredSize();
            TerminalSize fittingSize = new TerminalSize(Math.min(availableHorizontalSpace, preferredSize.getColumns()), preferredSize.getRows());
            if (alignment == Alignment.Fill) {
                fittingSize = fittingSize.withColumns(availableHorizontalSpace);
            }
            fittingMap.put(component, fittingSize);
            totalRequiredVerticalSpace += fittingSize.getRows() + this.spacing;
        }
        if (!components.isEmpty()) {
            totalRequiredVerticalSpace -= this.spacing;
        }
        if (availableVerticalSpace < totalRequiredVerticalSpace) {
            copyOfComponenets.sort((o1, o2) -> -Integer.compare(((TerminalSize)fittingMap.get(o1)).getRows(), ((TerminalSize)fittingMap.get(o2)).getRows()));
            block5: while (availableVerticalSpace < totalRequiredVerticalSpace) {
                int largestSize = ((TerminalSize)fittingMap.get(copyOfComponenets.get(0))).getRows();
                for (Component largeComponent : copyOfComponenets) {
                    TerminalSize currentSize = (TerminalSize)fittingMap.get(largeComponent);
                    if (largestSize > currentSize.getRows()) continue block5;
                    fittingMap.put(largeComponent, currentSize.withRelativeRows(-1));
                    --totalRequiredVerticalSpace;
                }
            }
        }
        if (availableVerticalSpace > totalRequiredVerticalSpace) {
            boolean resizedOneComponent = false;
            while (availableVerticalSpace > totalRequiredVerticalSpace) {
                for (Component component : components) {
                    layoutData = (LinearLayoutData)component.getLayoutData();
                    TerminalSize currentSize = (TerminalSize)fittingMap.get(component);
                    if (layoutData != null && ((LinearLayoutData)layoutData).growPolicy == GrowPolicy.CanGrow) {
                        fittingMap.put(component, currentSize.withRelativeRows(1));
                        --availableVerticalSpace;
                        resizedOneComponent = true;
                    }
                    if (availableVerticalSpace <= totalRequiredVerticalSpace) break;
                }
                if (!resizedOneComponent) break;
            }
        }
        int topPosition = 0;
        for (Component component : components) {
            Alignment alignment = Alignment.Beginning;
            LayoutData layoutData2 = component.getLayoutData();
            if (layoutData2 instanceof LinearLayoutData) {
                alignment = ((LinearLayoutData)layoutData2).alignment;
            }
            TerminalSize decidedSize = (TerminalSize)fittingMap.get(component);
            TerminalPosition position = component.getPosition();
            position = position.withRow(topPosition);
            switch (alignment) {
                case End: {
                    position = position.withColumn(availableHorizontalSpace - decidedSize.getColumns());
                    break;
                }
                case Center: {
                    position = position.withColumn((availableHorizontalSpace - decidedSize.getColumns()) / 2);
                    break;
                }
                default: {
                    position = position.withColumn(0);
                }
            }
            component.setPosition(component.getPosition().with(position));
            component.setSize(component.getSize().with(decidedSize));
            topPosition += decidedSize.getRows() + this.spacing;
        }
    }

    @Deprecated
    private void doHorizontalLayout(TerminalSize area, List<Component> components) {
        int remainingHorizontalSpace = area.getColumns();
        int availableVerticalSpace = area.getRows();
        for (Component component : components) {
            if (remainingHorizontalSpace <= 0) {
                component.setPosition(TerminalPosition.TOP_LEFT_CORNER);
                component.setSize(TerminalSize.ZERO);
                continue;
            }
            Alignment alignment = Alignment.Beginning;
            LayoutData layoutData = component.getLayoutData();
            if (layoutData instanceof LinearLayoutData) {
                alignment = ((LinearLayoutData)layoutData).alignment;
            }
            TerminalSize preferredSize = component.getPreferredSize();
            TerminalSize decidedSize = new TerminalSize(Math.min(remainingHorizontalSpace, preferredSize.getColumns()), Math.min(availableVerticalSpace, preferredSize.getRows()));
            if (alignment == Alignment.Fill) {
                decidedSize = decidedSize.withRows(availableVerticalSpace);
                alignment = Alignment.Beginning;
            }
            TerminalPosition position = component.getPosition();
            position = position.withColumn(area.getColumns() - remainingHorizontalSpace);
            switch (alignment) {
                case End: {
                    position = position.withRow(availableVerticalSpace - decidedSize.getRows());
                    break;
                }
                case Center: {
                    position = position.withRow((availableVerticalSpace - decidedSize.getRows()) / 2);
                    break;
                }
                default: {
                    position = position.withRow(0);
                }
            }
            component.setPosition(position);
            component.setSize(component.getSize().with(decidedSize));
            remainingHorizontalSpace -= decidedSize.getColumns() + this.spacing;
        }
    }

    private void doFlexibleHorizontalLayout(TerminalSize area, List<Component> components) {
        LayoutData layoutData;
        int availableVerticalSpace = area.getRows();
        int availableHorizontalSpace = area.getColumns();
        ArrayList<Component> copyOfComponenets = new ArrayList<Component>(components);
        IdentityHashMap<Component, TerminalSize> fittingMap = new IdentityHashMap<Component, TerminalSize>();
        int totalRequiredHorizontalSpace = 0;
        for (Component component : components) {
            Alignment alignment = Alignment.Beginning;
            layoutData = component.getLayoutData();
            if (layoutData instanceof LinearLayoutData) {
                alignment = ((LinearLayoutData)layoutData).alignment;
            }
            TerminalSize preferredSize = component.getPreferredSize();
            TerminalSize fittingSize = new TerminalSize(preferredSize.getColumns(), Math.min(availableVerticalSpace, preferredSize.getRows()));
            if (alignment == Alignment.Fill) {
                fittingSize = fittingSize.withRows(availableVerticalSpace);
            }
            fittingMap.put(component, fittingSize);
            totalRequiredHorizontalSpace += fittingSize.getColumns() + this.spacing;
        }
        if (!components.isEmpty()) {
            totalRequiredHorizontalSpace -= this.spacing;
        }
        if (availableHorizontalSpace < totalRequiredHorizontalSpace) {
            copyOfComponenets.sort((o1, o2) -> -Integer.compare(((TerminalSize)fittingMap.get(o1)).getColumns(), ((TerminalSize)fittingMap.get(o2)).getColumns()));
            block5: while (availableHorizontalSpace < totalRequiredHorizontalSpace) {
                int largestSize = ((TerminalSize)fittingMap.get(copyOfComponenets.get(0))).getColumns();
                for (Component largeComponent : copyOfComponenets) {
                    TerminalSize currentSize = (TerminalSize)fittingMap.get(largeComponent);
                    if (largestSize > currentSize.getColumns()) continue block5;
                    fittingMap.put(largeComponent, currentSize.withRelativeColumns(-1));
                    --totalRequiredHorizontalSpace;
                }
            }
        }
        if (availableHorizontalSpace > totalRequiredHorizontalSpace) {
            boolean resizedOneComponent = false;
            while (availableHorizontalSpace > totalRequiredHorizontalSpace) {
                for (Component component : components) {
                    layoutData = (LinearLayoutData)component.getLayoutData();
                    TerminalSize currentSize = (TerminalSize)fittingMap.get(component);
                    if (layoutData != null && ((LinearLayoutData)layoutData).growPolicy == GrowPolicy.CanGrow) {
                        fittingMap.put(component, currentSize.withRelativeColumns(1));
                        --availableHorizontalSpace;
                        resizedOneComponent = true;
                    }
                    if (availableHorizontalSpace <= totalRequiredHorizontalSpace) break;
                }
                if (!resizedOneComponent) break;
            }
        }
        int leftPosition = 0;
        for (Component component : components) {
            Alignment alignment = Alignment.Beginning;
            LayoutData layoutData2 = component.getLayoutData();
            if (layoutData2 instanceof LinearLayoutData) {
                alignment = ((LinearLayoutData)layoutData2).alignment;
            }
            TerminalSize decidedSize = (TerminalSize)fittingMap.get(component);
            TerminalPosition position = component.getPosition();
            position = position.withColumn(leftPosition);
            switch (alignment) {
                case End: {
                    position = position.withRow(availableVerticalSpace - decidedSize.getRows());
                    break;
                }
                case Center: {
                    position = position.withRow((availableVerticalSpace - decidedSize.getRows()) / 2);
                    break;
                }
                default: {
                    position = position.withRow(0);
                }
            }
            component.setPosition(component.getPosition().with(position));
            component.setSize(component.getSize().with(decidedSize));
            leftPosition += decidedSize.getColumns() + this.spacing;
        }
    }

    public static enum Alignment {
        Beginning,
        Center,
        End,
        Fill;

    }

    public static enum GrowPolicy {
        None,
        CanGrow;

    }

    private static class LinearLayoutData
    implements LayoutData {
        private final Alignment alignment;
        private final GrowPolicy growPolicy;

        public LinearLayoutData(Alignment alignment, GrowPolicy growPolicy) {
            this.alignment = alignment;
            this.growPolicy = growPolicy;
        }
    }
}

