/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.graphics.ThemeDefinition;
import com.googlecode.lanterna.gui2.AbstractComponent;
import com.googlecode.lanterna.gui2.ComponentRenderer;
import com.googlecode.lanterna.gui2.Direction;
import com.googlecode.lanterna.gui2.TextGUIGraphics;

public class ScrollBar
extends AbstractComponent<ScrollBar> {
    private final Direction direction;
    private int maximum;
    private int position;
    private int viewSize;

    public ScrollBar(Direction direction) {
        this.direction = direction;
        this.maximum = 100;
        this.position = 0;
        this.viewSize = 0;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public ScrollBar setScrollMaximum(int maximum) {
        if (maximum < 0) {
            throw new IllegalArgumentException("Cannot set ScrollBar maximum to " + maximum);
        }
        if (this.maximum != maximum) {
            this.maximum = maximum;
            this.invalidate();
        }
        return this;
    }

    public int getScrollMaximum() {
        return this.maximum;
    }

    public ScrollBar setScrollPosition(int position) {
        int newPosition = Math.min(position, this.maximum);
        if (this.position != newPosition) {
            this.position = newPosition;
            this.invalidate();
        }
        return this;
    }

    public int getScrollPosition() {
        return this.position;
    }

    public ScrollBar setViewSize(int viewSize) {
        this.viewSize = viewSize;
        return this;
    }

    public int getViewSize() {
        if (this.viewSize > 0) {
            return this.viewSize;
        }
        if (this.direction == Direction.HORIZONTAL) {
            return this.getSize().getColumns();
        }
        return this.getSize().getRows();
    }

    @Override
    protected ComponentRenderer<ScrollBar> createDefaultRenderer() {
        return new DefaultScrollBarRenderer();
    }

    public static class DefaultScrollBarRenderer
    extends ScrollBarRenderer {
        private boolean growScrollTracker = true;

        public void setGrowScrollTracker(boolean growScrollTracker) {
            this.growScrollTracker = growScrollTracker;
        }

        @Override
        public void drawComponent(TextGUIGraphics graphics, ScrollBar component) {
            TerminalSize size = graphics.getSize();
            Direction direction = component.getDirection();
            int position = component.getScrollPosition();
            int maximum = component.getScrollMaximum();
            int viewSize = component.getViewSize();
            if (size.getRows() == 0 || size.getColumns() == 0) {
                return;
            }
            if (position + viewSize >= maximum) {
                position = Math.max(0, maximum - viewSize);
                component.setScrollPosition(position);
            }
            ThemeDefinition themeDefinition = component.getThemeDefinition();
            graphics.applyThemeStyle(themeDefinition.getNormal());
            if (direction == Direction.VERTICAL) {
                if (size.getRows() == 1) {
                    graphics.setCharacter(0, 0, themeDefinition.getCharacter("VERTICAL_BACKGROUND", '\u2592'));
                } else if (size.getRows() == 2) {
                    graphics.setCharacter(0, 0, themeDefinition.getCharacter("UP_ARROW", '\u25b2'));
                    graphics.setCharacter(0, 1, themeDefinition.getCharacter("DOWN_ARROW", '\u25bc'));
                } else {
                    float ratio;
                    int scrollableArea = size.getRows() - 2;
                    int scrollTrackerSize = 1;
                    if (this.growScrollTracker) {
                        ratio = this.clampRatio((float)viewSize / (float)maximum);
                        scrollTrackerSize = Math.max(1, (int)(ratio * (float)scrollableArea));
                    }
                    ratio = this.clampRatio((float)position / (float)(maximum - viewSize));
                    int scrollTrackerPosition = (int)(ratio * (float)(scrollableArea - scrollTrackerSize)) + 1;
                    graphics.setCharacter(0, 0, themeDefinition.getCharacter("UP_ARROW", '\u25b2'));
                    graphics.drawLine(0, 1, 0, size.getRows() - 2, themeDefinition.getCharacter("VERTICAL_BACKGROUND", '\u2592'));
                    graphics.setCharacter(0, size.getRows() - 1, themeDefinition.getCharacter("DOWN_ARROW", '\u25bc'));
                    if (scrollTrackerSize == 1) {
                        graphics.setCharacter(0, scrollTrackerPosition, themeDefinition.getCharacter("VERTICAL_SMALL_TRACKER", '\u2588'));
                    } else if (scrollTrackerSize == 2) {
                        graphics.setCharacter(0, scrollTrackerPosition, themeDefinition.getCharacter("VERTICAL_TRACKER_TOP", '\u2588'));
                        graphics.setCharacter(0, scrollTrackerPosition + 1, themeDefinition.getCharacter("VERTICAL_TRACKER_BOTTOM", '\u2588'));
                    } else {
                        graphics.setCharacter(0, scrollTrackerPosition, themeDefinition.getCharacter("VERTICAL_TRACKER_TOP", '\u2588'));
                        graphics.drawLine(0, scrollTrackerPosition + 1, 0, scrollTrackerPosition + scrollTrackerSize - 2, themeDefinition.getCharacter("VERTICAL_TRACKER_BACKGROUND", '\u2588'));
                        graphics.setCharacter(0, scrollTrackerPosition + scrollTrackerSize / 2, themeDefinition.getCharacter("VERTICAL_SMALL_TRACKER", '\u2588'));
                        graphics.setCharacter(0, scrollTrackerPosition + scrollTrackerSize - 1, themeDefinition.getCharacter("VERTICAL_TRACKER_BOTTOM", '\u2588'));
                    }
                }
            } else if (size.getColumns() == 1) {
                graphics.setCharacter(0, 0, themeDefinition.getCharacter("HORIZONTAL_BACKGROUND", '\u2592'));
            } else if (size.getColumns() == 2) {
                graphics.setCharacter(0, 0, '\u25c4');
                graphics.setCharacter(1, 0, '\u25ba');
            } else {
                float ratio;
                int scrollableArea = size.getColumns() - 2;
                int scrollTrackerSize = 1;
                if (this.growScrollTracker) {
                    ratio = this.clampRatio((float)viewSize / (float)maximum);
                    scrollTrackerSize = Math.max(1, (int)(ratio * (float)scrollableArea));
                }
                ratio = this.clampRatio((float)position / (float)(maximum - viewSize));
                int scrollTrackerPosition = (int)(ratio * (float)(scrollableArea - scrollTrackerSize)) + 1;
                graphics.setCharacter(0, 0, themeDefinition.getCharacter("LEFT_ARROW", '\u25c4'));
                graphics.drawLine(1, 0, size.getColumns() - 2, 0, themeDefinition.getCharacter("HORIZONTAL_BACKGROUND", '\u2592'));
                graphics.setCharacter(size.getColumns() - 1, 0, themeDefinition.getCharacter("RIGHT_ARROW", '\u25ba'));
                if (scrollTrackerSize == 1) {
                    graphics.setCharacter(scrollTrackerPosition, 0, themeDefinition.getCharacter("HORIZONTAL_SMALL_TRACKER", '\u2588'));
                } else if (scrollTrackerSize == 2) {
                    graphics.setCharacter(scrollTrackerPosition, 0, themeDefinition.getCharacter("HORIZONTAL_TRACKER_LEFT", '\u2588'));
                    graphics.setCharacter(scrollTrackerPosition + 1, 0, themeDefinition.getCharacter("HORIZONTAL_TRACKER_RIGHT", '\u2588'));
                } else {
                    graphics.setCharacter(scrollTrackerPosition, 0, themeDefinition.getCharacter("HORIZONTAL_TRACKER_LEFT", '\u2588'));
                    graphics.drawLine(scrollTrackerPosition + 1, 0, scrollTrackerPosition + scrollTrackerSize - 2, 0, themeDefinition.getCharacter("HORIZONTAL_TRACKER_BACKGROUND", '\u2588'));
                    graphics.setCharacter(scrollTrackerPosition + scrollTrackerSize / 2, 0, themeDefinition.getCharacter("HORIZONTAL_SMALL_TRACKER", '\u2588'));
                    graphics.setCharacter(scrollTrackerPosition + scrollTrackerSize - 1, 0, themeDefinition.getCharacter("HORIZONTAL_TRACKER_RIGHT", '\u2588'));
                }
            }
        }

        private float clampRatio(float value) {
            if (value < 0.0f) {
                return 0.0f;
            }
            if (value > 1.0f) {
                return 1.0f;
            }
            return value;
        }
    }

    public static abstract class ScrollBarRenderer
    implements ComponentRenderer<ScrollBar> {
        @Override
        public TerminalSize getPreferredSize(ScrollBar component) {
            return TerminalSize.ONE;
        }
    }
}

