/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2.menu;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.gui2.AbstractComponent;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.ComponentRenderer;
import com.googlecode.lanterna.gui2.Container;
import com.googlecode.lanterna.gui2.Interactable;
import com.googlecode.lanterna.gui2.InteractableLookupMap;
import com.googlecode.lanterna.gui2.TextGUIGraphics;
import com.googlecode.lanterna.gui2.menu.Menu;
import com.googlecode.lanterna.input.KeyStroke;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class MenuBar
extends AbstractComponent<MenuBar>
implements Container {
    private static final int EXTRA_PADDING = 0;
    private final List<Menu> menus = new CopyOnWriteArrayList<Menu>();

    public MenuBar add(Menu menu) {
        this.menus.add(menu);
        menu.onAdded(this);
        return this;
    }

    @Override
    public int getChildCount() {
        return this.getMenuCount();
    }

    @Override
    public List<Component> getChildrenList() {
        return new ArrayList<Component>(this.menus);
    }

    @Override
    public Collection<Component> getChildren() {
        return this.getChildrenList();
    }

    @Override
    public boolean containsComponent(Component component) {
        return this.menus.contains(component);
    }

    @Override
    public synchronized boolean removeComponent(Component component) {
        boolean hadMenu = this.menus.remove(component);
        if (hadMenu) {
            component.onRemoved(this);
        }
        return hadMenu;
    }

    @Override
    public synchronized Interactable nextFocus(Interactable fromThis) {
        if (this.menus.isEmpty()) {
            return null;
        }
        if (fromThis == null) {
            return this.menus.get(0);
        }
        if (!this.menus.contains(fromThis) || this.menus.indexOf(fromThis) == this.menus.size() - 1) {
            return null;
        }
        return this.menus.get(this.menus.indexOf(fromThis) + 1);
    }

    @Override
    public Interactable previousFocus(Interactable fromThis) {
        if (this.menus.isEmpty()) {
            return null;
        }
        if (fromThis == null) {
            return this.menus.get(this.menus.size() - 1);
        }
        if (!this.menus.contains(fromThis) || this.menus.indexOf(fromThis) == 0) {
            return null;
        }
        return this.menus.get(this.menus.indexOf(fromThis) - 1);
    }

    @Override
    public boolean handleInput(KeyStroke key) {
        return false;
    }

    public Menu getMenu(int index) {
        return this.menus.get(index);
    }

    public int getMenuCount() {
        return this.menus.size();
    }

    @Override
    protected ComponentRenderer<MenuBar> createDefaultRenderer() {
        return new DefaultMenuBarRenderer();
    }

    @Override
    public synchronized void updateLookupMap(InteractableLookupMap interactableLookupMap) {
        for (Menu menu : this.menus) {
            interactableLookupMap.add(menu);
        }
    }

    @Override
    public TerminalPosition toBasePane(TerminalPosition position) {
        return position;
    }

    public boolean isEmptyMenuBar() {
        return false;
    }

    public class DefaultMenuBarRenderer
    implements ComponentRenderer<MenuBar> {
        @Override
        public TerminalSize getPreferredSize(MenuBar menuBar) {
            int maxHeight = 1;
            int totalWidth = 0;
            int i = 0;
            while (i < menuBar.getMenuCount()) {
                Menu menu = menuBar.getMenu(i);
                TerminalSize preferredSize = menu.getPreferredSize();
                maxHeight = Math.max(maxHeight, preferredSize.getRows());
                totalWidth += preferredSize.getColumns();
                ++i;
            }
            return new TerminalSize(totalWidth += 0, maxHeight);
        }

        @Override
        public void drawComponent(TextGUIGraphics graphics, MenuBar menuBar) {
            graphics.applyThemeStyle(MenuBar.this.getThemeDefinition().getNormal());
            graphics.fill(' ');
            int leftPosition = 0;
            TerminalSize size = graphics.getSize();
            int remainingSpace = size.getColumns() - 0;
            int i = 0;
            while (i < menuBar.getMenuCount() && remainingSpace > 0) {
                Menu menu = menuBar.getMenu(i);
                TerminalSize preferredSize = menu.getPreferredSize();
                menu.setPosition(menu.getPosition().withColumn(leftPosition).withRow(0));
                int finalWidth = Math.min(preferredSize.getColumns(), remainingSpace);
                menu.setSize(menu.getSize().withColumns(finalWidth).withRows(size.getRows()));
                remainingSpace -= finalWidth + 0;
                leftPosition += finalWidth + 0;
                TextGUIGraphics componentGraphics = graphics.newTextGraphics(menu.getPosition(), menu.getSize());
                menu.draw(componentGraphics);
                ++i;
            }
        }
    }
}

