/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2.table;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.graphics.Theme;
import com.googlecode.lanterna.graphics.ThemeDefinition;
import com.googlecode.lanterna.gui2.Direction;
import com.googlecode.lanterna.gui2.ScrollBar;
import com.googlecode.lanterna.gui2.TextGUIGraphics;
import com.googlecode.lanterna.gui2.table.Table;
import com.googlecode.lanterna.gui2.table.TableCellBorderStyle;
import com.googlecode.lanterna.gui2.table.TableCellRenderer;
import com.googlecode.lanterna.gui2.table.TableHeaderRenderer;
import com.googlecode.lanterna.gui2.table.TableModel;
import com.googlecode.lanterna.gui2.table.TableRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class DefaultTableRenderer<V>
implements TableRenderer<V> {
    private final ScrollBar verticalScrollBar = new ScrollBar(Direction.VERTICAL);
    private final ScrollBar horizontalScrollBar = new ScrollBar(Direction.HORIZONTAL);
    private TableCellBorderStyle headerVerticalBorderStyle = TableCellBorderStyle.None;
    private TableCellBorderStyle headerHorizontalBorderStyle = TableCellBorderStyle.EmptySpace;
    private TableCellBorderStyle cellVerticalBorderStyle = TableCellBorderStyle.None;
    private TableCellBorderStyle cellHorizontalBorderStyle = TableCellBorderStyle.EmptySpace;
    private int viewTopRow = 0;
    private int viewLeftColumn = 0;
    private int visibleRowsOnLastDraw = 0;
    private TerminalSize cachedSize = null;
    private final List<Integer> preferredColumnSizes = new ArrayList<Integer>();
    private final List<Integer> preferredRowSizes = new ArrayList<Integer>();
    private final Set<Integer> expandableColumns = new TreeSet<Integer>();
    private int headerSizeInRows = 0;
    private boolean allowPartialColumn = false;
    private boolean scrollBarsHidden = false;

    public synchronized void setHeaderVerticalBorderStyle(TableCellBorderStyle headerVerticalBorderStyle) {
        this.headerVerticalBorderStyle = headerVerticalBorderStyle;
    }

    public synchronized void setHeaderHorizontalBorderStyle(TableCellBorderStyle headerHorizontalBorderStyle) {
        this.headerHorizontalBorderStyle = headerHorizontalBorderStyle;
    }

    public synchronized void setCellVerticalBorderStyle(TableCellBorderStyle cellVerticalBorderStyle) {
        this.cellVerticalBorderStyle = cellVerticalBorderStyle;
    }

    public synchronized void setCellHorizontalBorderStyle(TableCellBorderStyle cellHorizontalBorderStyle) {
        this.cellHorizontalBorderStyle = cellHorizontalBorderStyle;
    }

    public synchronized void setExpandableColumns(Collection<Integer> expandableColumns) {
        this.expandableColumns.clear();
        this.expandableColumns.addAll(expandableColumns);
    }

    @Override
    public boolean isScrollBarsHidden() {
        return this.scrollBarsHidden;
    }

    @Override
    public void setScrollBarsHidden(boolean scrollBarsHidden) {
        this.scrollBarsHidden = scrollBarsHidden;
    }

    private boolean isHorizontallySpaced() {
        return this.headerHorizontalBorderStyle != TableCellBorderStyle.None || this.cellHorizontalBorderStyle != TableCellBorderStyle.None;
    }

    @Override
    public int getVisibleRowsOnLastDraw() {
        return this.visibleRowsOnLastDraw;
    }

    @Override
    public int getViewTopRow() {
        return this.viewTopRow;
    }

    @Override
    public void setViewTopRow(int viewTopRow) {
        this.viewTopRow = viewTopRow;
    }

    @Override
    public int getViewLeftColumn() {
        return this.viewLeftColumn;
    }

    @Override
    public void setViewLeftColumn(int viewLeftColumn) {
        this.viewLeftColumn = viewLeftColumn;
    }

    @Override
    public void setAllowPartialColumn(boolean allowPartialColumn) {
        this.allowPartialColumn = allowPartialColumn;
    }

    @Override
    public boolean getAllowPartialColumn() {
        return this.allowPartialColumn;
    }

    @Override
    public synchronized TerminalSize getPreferredSize(Table<V> table) {
        int rowIndex;
        int columnIndex;
        if (!table.isInvalid() && this.cachedSize != null) {
            return this.cachedSize;
        }
        TableModel<V> tableModel = table.getTableModel();
        int viewLeftColumn = this.viewLeftColumn;
        int viewTopRow = this.viewTopRow;
        int visibleColumns = table.getVisibleColumns();
        int visibleRows = table.getVisibleRows();
        int selectedRow = table.getSelectedRow();
        int selectedColumn = table.getSelectedColumn();
        List<List<V>> rows = tableModel.getRows();
        List<String> columnHeaders = tableModel.getColumnLabels();
        TableHeaderRenderer<V> tableHeaderRenderer = table.getTableHeaderRenderer();
        TableCellRenderer<V> tableCellRenderer = table.getTableCellRenderer();
        if (visibleColumns == 0) {
            visibleColumns = tableModel.getColumnCount();
        }
        if (visibleRows == 0) {
            visibleRows = tableModel.getRowCount();
        }
        this.preferredColumnSizes.clear();
        this.preferredRowSizes.clear();
        if (tableModel.getColumnCount() == 0) {
            return TerminalSize.ZERO;
        }
        if (selectedColumn != -1 && viewLeftColumn > selectedColumn) {
            viewLeftColumn = selectedColumn;
        } else if (selectedColumn != 1 && viewLeftColumn <= selectedColumn - visibleColumns) {
            viewLeftColumn = Math.max(0, selectedColumn - visibleColumns + 1);
        }
        if (viewTopRow > selectedRow) {
            viewTopRow = selectedRow;
        } else if (viewTopRow <= selectedRow - visibleRows) {
            viewTopRow = Math.max(0, selectedRow - visibleRows + 1);
        }
        if (rows.size() == 0) {
            columnIndex = 0;
            while (columnIndex < columnHeaders.size()) {
                int columnSize = tableHeaderRenderer.getPreferredSize(table, columnHeaders.get(columnIndex), columnIndex).getColumns();
                if (this.preferredColumnSizes.size() == columnIndex) {
                    this.preferredColumnSizes.add(columnSize);
                } else if (this.preferredColumnSizes.get(columnIndex) < columnSize) {
                    this.preferredColumnSizes.set(columnIndex, columnSize);
                }
                ++columnIndex;
            }
        }
        int rowIndex2 = 0;
        while (rowIndex2 < rows.size()) {
            List<V> row = rows.get(rowIndex2);
            int columnIndex2 = 0;
            while (columnIndex2 < row.size()) {
                V cell = row.get(columnIndex2);
                int columnSize = tableCellRenderer.getPreferredSize(table, cell, columnIndex2, rowIndex2).getColumns();
                if (this.preferredColumnSizes.size() == columnIndex2) {
                    this.preferredColumnSizes.add(columnSize);
                } else if (this.preferredColumnSizes.get(columnIndex2) < columnSize) {
                    this.preferredColumnSizes.set(columnIndex2, columnSize);
                }
                ++columnIndex2;
            }
            if (rowIndex2 == 0) {
                columnIndex2 = 0;
                while (columnIndex2 < row.size()) {
                    int columnSize = tableHeaderRenderer.getPreferredSize(table, columnHeaders.get(columnIndex2), columnIndex2).getColumns();
                    if (this.preferredColumnSizes.size() == columnIndex2) {
                        this.preferredColumnSizes.add(columnSize);
                    } else if (this.preferredColumnSizes.get(columnIndex2) < columnSize) {
                        this.preferredColumnSizes.set(columnIndex2, columnSize);
                    }
                    ++columnIndex2;
                }
            }
            ++rowIndex2;
        }
        columnIndex = 0;
        while (columnIndex < columnHeaders.size()) {
            int rowIndex3 = 0;
            while (rowIndex3 < rows.size()) {
                V cell = rows.get(rowIndex3).get(columnIndex);
                int rowSize = tableCellRenderer.getPreferredSize(table, cell, columnIndex, rowIndex3).getRows();
                if (this.preferredRowSizes.size() == rowIndex3) {
                    this.preferredRowSizes.add(rowSize);
                } else if (this.preferredRowSizes.get(rowIndex3) < rowSize) {
                    this.preferredRowSizes.set(rowIndex3, rowSize);
                }
                ++rowIndex3;
            }
            ++columnIndex;
        }
        int preferredRowSize = 0;
        int preferredColumnSize = 0;
        if (table.getVisibleColumns() == 0) {
            for (Integer columnSize : this.preferredColumnSizes) {
                preferredColumnSize += columnSize.intValue();
            }
        } else {
            int columnIndex3 = viewLeftColumn;
            while (columnIndex3 < Math.min(this.preferredColumnSizes.size(), viewLeftColumn + visibleColumns)) {
                preferredColumnSize += this.preferredColumnSizes.get(columnIndex3).intValue();
                ++columnIndex3;
            }
        }
        if (table.getVisibleRows() == 0) {
            rowIndex = 0;
            while (rowIndex < rows.size()) {
                preferredRowSize += this.preferredRowSizes.get(rowIndex).intValue();
                ++rowIndex;
            }
        } else {
            rowIndex = viewTopRow;
            while (rowIndex < Math.min(rows.size(), viewTopRow + visibleRows)) {
                preferredRowSize += this.preferredRowSizes.get(rowIndex).intValue();
                ++rowIndex;
            }
        }
        this.headerSizeInRows = 0;
        int columnIndex4 = 0;
        while (columnIndex4 < columnHeaders.size()) {
            int headerRows = tableHeaderRenderer.getPreferredSize(table, columnHeaders.get(columnIndex4), columnIndex4).getRows();
            if (this.headerSizeInRows < headerRows) {
                this.headerSizeInRows = headerRows;
            }
            ++columnIndex4;
        }
        preferredRowSize += this.headerSizeInRows;
        if (this.headerVerticalBorderStyle != TableCellBorderStyle.None) {
            ++preferredRowSize;
        }
        if (this.cellVerticalBorderStyle != TableCellBorderStyle.None && !rows.isEmpty()) {
            preferredRowSize += Math.min(rows.size(), visibleRows) - 1;
        }
        if (this.isHorizontallySpaced() && !columnHeaders.isEmpty()) {
            preferredColumnSize += Math.min(tableModel.getColumnCount(), visibleColumns) - 1;
        }
        if (!this.scrollBarsHidden) {
            ++preferredColumnSize;
            if (visibleColumns < tableModel.getColumnCount()) {
                ++preferredRowSize;
            }
        }
        this.cachedSize = new TerminalSize(preferredColumnSize, preferredRowSize);
        return this.cachedSize;
    }

    @Override
    public TerminalPosition getCursorLocation(Table<V> component) {
        return null;
    }

    @Override
    public synchronized void drawComponent(TextGUIGraphics graphics, Table<V> table) {
        boolean needHorizontalScrollBar;
        boolean needVerticalScrollBar;
        int preferredVisibleColumns;
        TerminalSize area = graphics.getSize();
        if (area.getRows() == 0 || area.getColumns() == 0) {
            return;
        }
        if (table.isInvalid()) {
            this.getPreferredSize(table);
        }
        int headerSizeIncludingBorder = this.headerSizeInRows + this.headerVerticalBorderStyle.getSize();
        int selectedColumn = table.getSelectedColumn();
        int selectedRow = table.getSelectedRow();
        if (selectedColumn != -1 && this.viewLeftColumn > selectedColumn) {
            this.viewLeftColumn = selectedColumn;
        }
        if (this.viewTopRow > selectedRow) {
            this.viewTopRow = selectedRow;
        }
        if (this.viewTopRow >= table.getTableModel().getRowCount()) {
            this.viewTopRow = Math.max(0, table.getTableModel().getRowCount() - 1);
        }
        TerminalSize areaWithoutScrollBars = area.withRelativeRows(-headerSizeIncludingBorder);
        int preferredVisibleRows = table.getVisibleRows();
        if (preferredVisibleRows == 0) {
            preferredVisibleRows = table.getTableModel().getRowCount();
        }
        if ((preferredVisibleColumns = table.getVisibleColumns()) == 0) {
            preferredVisibleColumns = table.getTableModel().getColumnCount();
        }
        int visibleRows = this.calculateVisibleRows(areaWithoutScrollBars, this.viewTopRow, preferredVisibleRows);
        boolean bl = needVerticalScrollBar = !this.scrollBarsHidden && visibleRows < table.getTableModel().getRowCount();
        if (needVerticalScrollBar) {
            areaWithoutScrollBars = areaWithoutScrollBars.withRelativeColumns(-this.verticalScrollBar.getPreferredSize().getColumns());
        }
        int visibleColumns = this.calculateVisibleColumns(areaWithoutScrollBars, this.viewLeftColumn, preferredVisibleColumns);
        boolean bl2 = needHorizontalScrollBar = !this.scrollBarsHidden && visibleColumns < table.getTableModel().getColumnCount();
        if (needHorizontalScrollBar) {
            areaWithoutScrollBars = areaWithoutScrollBars.withRelativeRows(-this.horizontalScrollBar.getPreferredSize().getRows());
            visibleRows = this.calculateVisibleRows(areaWithoutScrollBars, this.viewTopRow, preferredVisibleRows);
            if (!needVerticalScrollBar && visibleRows < table.getTableModel().getRowCount()) {
                needVerticalScrollBar = true;
                areaWithoutScrollBars = areaWithoutScrollBars.withRelativeColumns(-this.verticalScrollBar.getPreferredSize().getColumns());
                visibleColumns = this.calculateVisibleColumns(areaWithoutScrollBars, this.viewLeftColumn, preferredVisibleColumns);
            }
        }
        while (selectedColumn != 1 && this.viewLeftColumn <= selectedColumn - visibleColumns) {
            this.viewLeftColumn = Math.max(0, selectedColumn - visibleColumns + 1);
            visibleColumns = this.calculateVisibleColumns(areaWithoutScrollBars, this.viewLeftColumn, preferredVisibleColumns);
        }
        while (this.viewTopRow <= selectedRow - visibleRows) {
            this.viewTopRow = Math.max(0, selectedRow - visibleRows + 1);
            visibleRows = this.calculateVisibleRows(areaWithoutScrollBars, this.viewTopRow, preferredVisibleRows);
        }
        int renderColumns = this.allowPartialColumn && visibleColumns < preferredVisibleColumns - this.viewLeftColumn ? visibleColumns + 1 : visibleColumns;
        List<Integer> columnSizes = this.fitColumnsInAvailableSpace(table, areaWithoutScrollBars, visibleColumns);
        this.drawHeader(graphics, table, columnSizes);
        this.drawRows(graphics.newTextGraphics(new TerminalPosition(0, headerSizeIncludingBorder), area.withRelativeRows(-headerSizeIncludingBorder)), table, columnSizes, visibleRows, visibleColumns, renderColumns, needVerticalScrollBar, needHorizontalScrollBar);
        this.visibleRowsOnLastDraw = visibleRows;
    }

    private int calculateVisibleRows(TerminalSize area, int viewTopRow, int preferredVisibleRows) {
        int remainingVerticalSpace = area.getRows();
        int visibleRows = 0;
        int borderAdjustment = this.cellVerticalBorderStyle.getSize();
        int row = viewTopRow;
        while (row < this.preferredRowSizes.size()) {
            int rowSize;
            if (preferredVisibleRows == visibleRows || remainingVerticalSpace < (rowSize = this.preferredRowSizes.get(row) + borderAdjustment)) break;
            remainingVerticalSpace -= rowSize;
            ++visibleRows;
            ++row;
        }
        return visibleRows;
    }

    private int calculateVisibleColumns(TerminalSize area, int viewLeftColumn, int preferredVisibleColumns) {
        int remainingHorizontalSpace = area.getColumns();
        int visibleColumns = 0;
        int borderAdjustment = this.cellHorizontalBorderStyle.getSize();
        int column = viewLeftColumn;
        while (column < this.preferredColumnSizes.size()) {
            if (preferredVisibleColumns == visibleColumns) break;
            int columnSize = this.preferredColumnSizes.get(column) + (column > viewLeftColumn ? borderAdjustment : 0);
            if (remainingHorizontalSpace < columnSize) break;
            remainingHorizontalSpace -= columnSize;
            ++visibleColumns;
            ++column;
        }
        return visibleColumns;
    }

    private List<Integer> fitColumnsInAvailableSpace(Table<V> table, TerminalSize area, int visibleColumns) {
        ArrayList<Integer> columnSizes = new ArrayList<Integer>(this.preferredColumnSizes);
        int horizontalSpaceRequirement = 0;
        int viewLeftColumn = table.getRenderer().getViewLeftColumn();
        List<String> headers = table.getTableModel().getColumnLabels();
        int endColumnIndex = Math.min(headers.size(), viewLeftColumn + visibleColumns);
        ArrayList<Integer> visibleExpandableColumns = new ArrayList<Integer>();
        int index = viewLeftColumn;
        while (index < endColumnIndex) {
            horizontalSpaceRequirement += this.preferredColumnSizes.get(index).intValue();
            if (this.headerHorizontalBorderStyle != TableCellBorderStyle.None && index < endColumnIndex - 1) {
                horizontalSpaceRequirement += this.headerHorizontalBorderStyle.getSize();
            }
            if (this.expandableColumns.contains(index)) {
                visibleExpandableColumns.add(index);
            }
            ++index;
        }
        int extraHorizontalSpace = area.getColumns() - horizontalSpaceRequirement;
        block1: while (extraHorizontalSpace > 0 && !visibleExpandableColumns.isEmpty()) {
            Iterator iterator = visibleExpandableColumns.iterator();
            while (iterator.hasNext()) {
                int expandableColumnIndex = (Integer)iterator.next();
                columnSizes.set(expandableColumnIndex, (Integer)columnSizes.get(expandableColumnIndex) + 1);
                if (--extraHorizontalSpace == 0) continue block1;
            }
        }
        return columnSizes;
    }

    private void drawHeader(TextGUIGraphics graphics, Table<V> table, List<Integer> columnSizes) {
        Theme theme = table.getTheme();
        TableHeaderRenderer<V> tableHeaderRenderer = table.getTableHeaderRenderer();
        List<String> headers = table.getTableModel().getColumnLabels();
        int viewLeftColumn = table.getRenderer().getViewLeftColumn();
        int visibleColumns = table.getVisibleColumns();
        if (visibleColumns == 0) {
            visibleColumns = table.getTableModel().getColumnCount();
        }
        int leftPosition = 0;
        int endColumnIndex = Math.min(headers.size(), viewLeftColumn + visibleColumns);
        int index = viewLeftColumn;
        while (index < endColumnIndex) {
            String label = headers.get(index);
            TerminalSize size = new TerminalSize(columnSizes.get(index), this.headerSizeInRows);
            tableHeaderRenderer.drawHeader(table, label, index, graphics.newTextGraphics(new TerminalPosition(leftPosition, 0), size));
            leftPosition += size.getColumns();
            if (this.headerHorizontalBorderStyle != TableCellBorderStyle.None && index < endColumnIndex - 1) {
                graphics.applyThemeStyle(theme.getDefinition(Table.class).getNormal());
                graphics.setCharacter(leftPosition, 0, this.getVerticalCharacter(this.headerHorizontalBorderStyle));
                ++leftPosition;
            }
            ++index;
        }
        if (this.headerVerticalBorderStyle != TableCellBorderStyle.None) {
            leftPosition = 0;
            int topPosition = this.headerSizeInRows;
            graphics.applyThemeStyle(theme.getDefinition(Table.class).getNormal());
            int i = viewLeftColumn;
            while (i < endColumnIndex) {
                if (i > viewLeftColumn) {
                    graphics.setCharacter(leftPosition, topPosition, this.getJunctionCharacter(this.headerVerticalBorderStyle, this.headerHorizontalBorderStyle, this.cellHorizontalBorderStyle));
                    ++leftPosition;
                }
                int columnWidth = columnSizes.get(i);
                graphics.drawLine(leftPosition, topPosition, leftPosition + columnWidth - 1, topPosition, this.getHorizontalCharacter(this.headerVerticalBorderStyle));
                leftPosition += columnWidth;
                ++i;
            }
            if (leftPosition < graphics.getSize().getColumns()) {
                graphics.drawLine(leftPosition, topPosition, graphics.getSize().getColumns() - 1, topPosition, this.getHorizontalCharacter(this.headerVerticalBorderStyle));
            }
        }
    }

    private void drawRows(TextGUIGraphics graphics, Table<V> table, List<Integer> columnSizes, int visibleRows, int visibleColumns, int renderColumns, boolean needVerticalScrollBar, boolean needHorizontalScrollBar) {
        Theme theme = table.getTheme();
        ThemeDefinition themeDefinition = theme.getDefinition(Table.class);
        TerminalSize area = graphics.getSize();
        TableCellRenderer<V> tableCellRenderer = table.getTableCellRenderer();
        TableModel<V> tableModel = table.getTableModel();
        List<List<V>> rows = tableModel.getRows();
        int viewTopRow = table.getRenderer().getViewTopRow();
        int viewLeftColumn = table.getRenderer().getViewLeftColumn();
        if (needVerticalScrollBar) {
            TerminalSize verticalScrollBarPreferredSize = this.verticalScrollBar.getPreferredSize();
            int scrollBarHeight = graphics.getSize().getRows();
            if (needHorizontalScrollBar) {
                --scrollBarHeight;
            }
            this.verticalScrollBar.setPosition(new TerminalPosition(graphics.getSize().getColumns() - verticalScrollBarPreferredSize.getColumns(), 0));
            this.verticalScrollBar.setSize(verticalScrollBarPreferredSize.withRows(scrollBarHeight));
            this.verticalScrollBar.setScrollMaximum(rows.size());
            this.verticalScrollBar.setViewSize(visibleRows);
            this.verticalScrollBar.setScrollPosition(viewTopRow);
            if (table.getParent() != this.verticalScrollBar.getParent()) {
                if (this.verticalScrollBar.getParent() != null) {
                    this.verticalScrollBar.onRemoved(this.verticalScrollBar.getParent());
                }
                if (table.getParent() != null) {
                    this.verticalScrollBar.onAdded(table.getParent());
                }
            }
            this.verticalScrollBar.draw(graphics.newTextGraphics(this.verticalScrollBar.getPosition(), this.verticalScrollBar.getSize()));
            graphics = graphics.newTextGraphics(TerminalPosition.TOP_LEFT_CORNER, graphics.getSize().withRelativeColumns(-verticalScrollBarPreferredSize.getColumns()));
        }
        if (needHorizontalScrollBar) {
            TerminalSize horizontalScrollBarPreferredSize = this.horizontalScrollBar.getPreferredSize();
            int scrollBarWidth = graphics.getSize().getColumns();
            this.horizontalScrollBar.setPosition(new TerminalPosition(0, graphics.getSize().getRows() - horizontalScrollBarPreferredSize.getRows()));
            this.horizontalScrollBar.setSize(horizontalScrollBarPreferredSize.withColumns(scrollBarWidth));
            this.horizontalScrollBar.setScrollMaximum(tableModel.getColumnCount());
            this.horizontalScrollBar.setViewSize(visibleColumns);
            this.horizontalScrollBar.setScrollPosition(viewLeftColumn);
            if (table.getParent() != this.horizontalScrollBar.getParent()) {
                if (this.horizontalScrollBar.getParent() != null) {
                    this.horizontalScrollBar.onRemoved(this.horizontalScrollBar.getParent());
                }
                if (table.getParent() != null) {
                    this.horizontalScrollBar.onAdded(table.getParent());
                }
            }
            this.horizontalScrollBar.draw(graphics.newTextGraphics(this.horizontalScrollBar.getPosition(), this.horizontalScrollBar.getSize()));
            graphics = graphics.newTextGraphics(TerminalPosition.TOP_LEFT_CORNER, graphics.getSize().withRelativeRows(-horizontalScrollBarPreferredSize.getRows()));
        }
        int topPosition = 0;
        int rowIndex = viewTopRow;
        while (rowIndex < Math.min(viewTopRow + visibleRows, rows.size())) {
            int leftPosition = 0;
            List<V> row = rows.get(rowIndex);
            int columnIndex = viewLeftColumn;
            while (columnIndex < Math.min(viewLeftColumn + renderColumns, row.size())) {
                if (columnIndex > viewLeftColumn) {
                    if (table.getSelectedRow() == rowIndex && !table.isCellSelection()) {
                        if (table.isFocused()) {
                            graphics.applyThemeStyle(themeDefinition.getActive());
                        } else {
                            graphics.applyThemeStyle(themeDefinition.getSelected());
                        }
                    } else {
                        graphics.applyThemeStyle(themeDefinition.getNormal());
                    }
                    graphics.setCharacter(leftPosition, topPosition, this.getVerticalCharacter(this.cellHorizontalBorderStyle));
                    ++leftPosition;
                }
                V cell = row.get(columnIndex);
                TerminalPosition cellPosition = new TerminalPosition(leftPosition, topPosition);
                TerminalSize cellArea = new TerminalSize(columnSizes.get(columnIndex), this.preferredRowSizes.get(rowIndex));
                tableCellRenderer.drawCell(table, cell, columnIndex, rowIndex, graphics.newTextGraphics(cellPosition, cellArea));
                leftPosition += cellArea.getColumns();
                if (columnIndex < row.size() - 1) {
                    if (table.getSelectedRow() == rowIndex && !table.isCellSelection()) {
                        if (table.isFocused()) {
                            graphics.applyThemeStyle(themeDefinition.getActive());
                        } else {
                            graphics.applyThemeStyle(themeDefinition.getSelected());
                        }
                    } else {
                        graphics.applyThemeStyle(themeDefinition.getNormal());
                    }
                    graphics.setCharacter(leftPosition, topPosition, this.getVerticalCharacter(this.cellHorizontalBorderStyle));
                }
                if (leftPosition > area.getColumns()) break;
                ++columnIndex;
            }
            topPosition += this.preferredRowSizes.get(rowIndex).intValue();
            if (this.cellVerticalBorderStyle != TableCellBorderStyle.None) {
                leftPosition = 0;
                graphics.applyThemeStyle(themeDefinition.getNormal());
                int i = viewLeftColumn;
                while (i < Math.min(viewLeftColumn + renderColumns + 1, row.size())) {
                    if (i > viewLeftColumn) {
                        graphics.setCharacter(leftPosition, topPosition, this.getJunctionCharacter(this.cellVerticalBorderStyle, this.cellHorizontalBorderStyle, this.cellHorizontalBorderStyle));
                        ++leftPosition;
                    }
                    int columnWidth = columnSizes.get(i);
                    graphics.drawLine(leftPosition, topPosition, leftPosition + columnWidth - 1, topPosition, this.getHorizontalCharacter(this.cellVerticalBorderStyle));
                    leftPosition += columnWidth;
                    ++i;
                }
                topPosition += this.cellVerticalBorderStyle.getSize();
            }
            if (topPosition > area.getRows()) break;
            ++rowIndex;
        }
    }

    private char getHorizontalCharacter(TableCellBorderStyle style) {
        switch (style) {
            case SingleLine: {
                return '\u2500';
            }
            case DoubleLine: {
                return '\u2550';
            }
        }
        return ' ';
    }

    private char getVerticalCharacter(TableCellBorderStyle style) {
        switch (style) {
            case SingleLine: {
                return '\u2502';
            }
            case DoubleLine: {
                return '\u2551';
            }
        }
        return ' ';
    }

    private char getJunctionCharacter(TableCellBorderStyle mainStyle, TableCellBorderStyle styleAbove, TableCellBorderStyle styleBelow) {
        if (mainStyle == TableCellBorderStyle.SingleLine) {
            if (styleAbove == TableCellBorderStyle.SingleLine) {
                if (styleBelow == TableCellBorderStyle.SingleLine) {
                    return '\u253c';
                }
                if (styleBelow == TableCellBorderStyle.DoubleLine) {
                    return '\u2534';
                }
                return '\u2534';
            }
            if (styleAbove == TableCellBorderStyle.DoubleLine) {
                if (styleBelow == TableCellBorderStyle.SingleLine) {
                    return '\u2568';
                }
                if (styleBelow == TableCellBorderStyle.DoubleLine) {
                    return '\u256b';
                }
                return '\u2568';
            }
            if (styleBelow == TableCellBorderStyle.SingleLine) {
                return '\u252c';
            }
            if (styleBelow == TableCellBorderStyle.DoubleLine) {
                return '\u2565';
            }
            return '\u2500';
        }
        if (mainStyle == TableCellBorderStyle.DoubleLine) {
            if (styleAbove == TableCellBorderStyle.SingleLine) {
                if (styleBelow == TableCellBorderStyle.SingleLine) {
                    return '\u256a';
                }
                if (styleBelow == TableCellBorderStyle.DoubleLine) {
                    return '\u2567';
                }
                return '\u2567';
            }
            if (styleAbove == TableCellBorderStyle.DoubleLine) {
                if (styleBelow == TableCellBorderStyle.SingleLine) {
                    return '\u2569';
                }
                if (styleBelow == TableCellBorderStyle.DoubleLine) {
                    return '\u256c';
                }
                return '\u2569';
            }
            if (styleBelow == TableCellBorderStyle.SingleLine) {
                return '\u2564';
            }
            if (styleBelow == TableCellBorderStyle.DoubleLine) {
                return '\u2566';
            }
            return '\u2550';
        }
        return ' ';
    }
}

