/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class TableModel<V> {
    private final List<String> columns;
    private final List<List<V>> rows;
    private final List<Listener<V>> listeners;

    public TableModel(String ... columnLabels) {
        this.columns = new ArrayList<String>(Arrays.asList(columnLabels));
        this.rows = new ArrayList<List<V>>();
        this.listeners = new ArrayList<Listener<V>>();
    }

    public synchronized int getColumnCount() {
        return this.columns.size();
    }

    public synchronized int getRowCount() {
        return this.rows.size();
    }

    public synchronized List<List<V>> getRows() {
        ArrayList<List<V>> copy = new ArrayList<List<V>>();
        for (List<V> row : this.rows) {
            copy.add(new ArrayList<V>(row));
        }
        return copy;
    }

    public synchronized List<String> getColumnLabels() {
        return new ArrayList<String>(this.columns);
    }

    public synchronized List<V> getRow(int index) {
        return new ArrayList(this.rows.get(index));
    }

    @SafeVarargs
    public final synchronized TableModel<V> addRow(V ... values) {
        this.addRow((Collection<V>)Arrays.asList(values));
        return this;
    }

    public synchronized TableModel<V> addRow(Collection<V> values) {
        this.insertRow(this.getRowCount(), values);
        return this;
    }

    public synchronized TableModel<V> insertRow(int index, Collection<V> values) {
        ArrayList<V> list = new ArrayList<V>(values);
        this.rows.add(index, list);
        for (Listener<V> listener : this.listeners) {
            listener.onRowAdded(this, index);
        }
        return this;
    }

    public synchronized TableModel<V> removeRow(int index) {
        List<V> removedRow = this.rows.remove(index);
        for (Listener<V> listener : this.listeners) {
            listener.onRowRemoved(this, index, removedRow);
        }
        return this;
    }

    public synchronized TableModel<V> clear() {
        while (this.rows.size() > 0) {
            this.removeRow(0);
        }
        return this;
    }

    public synchronized String getColumnLabel(int index) {
        return this.columns.get(index);
    }

    public synchronized TableModel<V> setColumnLabel(int index, String newLabel) {
        this.columns.set(index, newLabel);
        return this;
    }

    public synchronized TableModel<V> addColumn(String label, V[] newColumnValues) {
        return this.insertColumn(this.getColumnCount(), label, newColumnValues);
    }

    public synchronized TableModel<V> insertColumn(int index, String label, V[] newColumnValues) {
        this.columns.add(index, label);
        int i = 0;
        while (i < this.rows.size()) {
            List<V> row = this.rows.get(i);
            int j = row.size();
            while (j < index) {
                row.add(null);
                ++j;
            }
            if (newColumnValues != null && i < newColumnValues.length && newColumnValues[i] != null) {
                row.add(index, newColumnValues[i]);
            } else {
                row.add(index, null);
            }
            ++i;
        }
        for (Listener<V> listener : this.listeners) {
            listener.onColumnAdded(this, index);
        }
        return this;
    }

    public synchronized TableModel<V> removeColumn(int index) {
        String removedColumnHeader = this.columns.remove(index);
        ArrayList<V> removedColumn = new ArrayList<V>();
        for (List<V> list : this.rows) {
            removedColumn.add(list.remove(index));
        }
        for (Listener listener : this.listeners) {
            listener.onColumnRemoved(this, index, removedColumnHeader, removedColumn);
        }
        return this;
    }

    public synchronized V getCell(int columnIndex, int rowIndex) {
        if (rowIndex < 0 || columnIndex < 0) {
            throw new IndexOutOfBoundsException("Invalid row or column index: " + rowIndex + " " + columnIndex);
        }
        if (rowIndex >= this.getRowCount()) {
            throw new IndexOutOfBoundsException("TableModel has " + this.getRowCount() + " rows, invalid access at rowIndex " + rowIndex);
        }
        if (columnIndex >= this.getColumnCount()) {
            throw new IndexOutOfBoundsException("TableModel has " + columnIndex + " columns, invalid access at columnIndex " + columnIndex);
        }
        return this.rows.get(rowIndex).get(columnIndex);
    }

    public synchronized TableModel<V> setCell(int columnIndex, int rowIndex, V value) {
        this.getCell(columnIndex, rowIndex);
        List<V> row = this.rows.get(rowIndex);
        int j = row.size();
        while (j < columnIndex) {
            row.add(null);
            ++j;
        }
        V existingValue = row.get(columnIndex);
        if (existingValue == value) {
            return this;
        }
        row.set(columnIndex, value);
        for (Listener<V> listener : this.listeners) {
            listener.onCellChanged(this, rowIndex, columnIndex, existingValue, value);
        }
        return this;
    }

    public TableModel<V> addListener(Listener<V> listener) {
        this.listeners.add(listener);
        return this;
    }

    public TableModel<V> removeListener(Listener<V> listener) {
        this.listeners.remove(listener);
        return this;
    }

    public static interface Listener<V> {
        public void onRowAdded(TableModel<V> var1, int var2);

        public void onRowRemoved(TableModel<V> var1, int var2, List<V> var3);

        public void onColumnAdded(TableModel<V> var1, int var2);

        public void onColumnRemoved(TableModel<V> var1, int var2, String var3, List<V> var4);

        public void onCellChanged(TableModel<V> var1, int var2, int var3, V var4, V var5);
    }
}

