/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.input;

import com.googlecode.lanterna.input.CharacterPattern;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.input.KeyType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EscapeSequenceCharacterPattern
implements CharacterPattern {
    public static final int SHIFT = 1;
    public static final int ALT = 2;
    public static final int CTRL = 4;
    protected final Map<Integer, KeyType> stdMap = new HashMap<Integer, KeyType>();
    protected final Map<Character, KeyType> finMap = new HashMap<Character, KeyType>();
    protected boolean useEscEsc = true;

    public EscapeSequenceCharacterPattern() {
        this.finMap.put(Character.valueOf('A'), KeyType.ArrowUp);
        this.finMap.put(Character.valueOf('B'), KeyType.ArrowDown);
        this.finMap.put(Character.valueOf('C'), KeyType.ArrowRight);
        this.finMap.put(Character.valueOf('D'), KeyType.ArrowLeft);
        this.finMap.put(Character.valueOf('E'), KeyType.Unknown);
        this.finMap.put(Character.valueOf('G'), KeyType.Unknown);
        this.finMap.put(Character.valueOf('H'), KeyType.Home);
        this.finMap.put(Character.valueOf('F'), KeyType.End);
        this.finMap.put(Character.valueOf('P'), KeyType.F1);
        this.finMap.put(Character.valueOf('Q'), KeyType.F2);
        this.finMap.put(Character.valueOf('R'), KeyType.F3);
        this.finMap.put(Character.valueOf('S'), KeyType.F4);
        this.finMap.put(Character.valueOf('Z'), KeyType.ReverseTab);
        this.stdMap.put(1, KeyType.Home);
        this.stdMap.put(2, KeyType.Insert);
        this.stdMap.put(3, KeyType.Delete);
        this.stdMap.put(4, KeyType.End);
        this.stdMap.put(5, KeyType.PageUp);
        this.stdMap.put(6, KeyType.PageDown);
        this.stdMap.put(11, KeyType.F1);
        this.stdMap.put(12, KeyType.F2);
        this.stdMap.put(13, KeyType.F3);
        this.stdMap.put(14, KeyType.F4);
        this.stdMap.put(15, KeyType.F5);
        this.stdMap.put(16, KeyType.F5);
        this.stdMap.put(17, KeyType.F6);
        this.stdMap.put(18, KeyType.F7);
        this.stdMap.put(19, KeyType.F8);
        this.stdMap.put(20, KeyType.F9);
        this.stdMap.put(21, KeyType.F10);
        this.stdMap.put(23, KeyType.F11);
        this.stdMap.put(24, KeyType.F12);
        this.stdMap.put(25, KeyType.F13);
        this.stdMap.put(26, KeyType.F14);
        this.stdMap.put(28, KeyType.F15);
        this.stdMap.put(29, KeyType.F16);
        this.stdMap.put(31, KeyType.F17);
        this.stdMap.put(32, KeyType.F18);
        this.stdMap.put(33, KeyType.F19);
    }

    protected KeyStroke getKeyStroke(KeyType key, int mods) {
        boolean bShift = false;
        boolean bCtrl = false;
        boolean bAlt = false;
        if (key == null) {
            return null;
        }
        if (mods >= 0) {
            bShift = (mods & 1) != 0;
            bAlt = (mods & 2) != 0;
            bCtrl = (mods & 4) != 0;
        } else if (mods == -1 && key == KeyType.F3) {
            return new KeyStroke.RealF3();
        }
        return new KeyStroke(key, bCtrl, bAlt, bShift);
    }

    protected KeyStroke getKeyStrokeRaw(char first, int num1, int num2, char last, boolean bEsc) {
        KeyType kt;
        boolean bPuttyCtrl = false;
        boolean bRealF3 = false;
        if (last == '~' && this.stdMap.containsKey(num1)) {
            kt = this.stdMap.get(num1);
        } else if (this.finMap.containsKey(Character.valueOf(last))) {
            kt = this.finMap.get(Character.valueOf(last));
            if (first == 'O') {
                if (last >= 'A' && last <= 'D') {
                    bPuttyCtrl = true;
                }
                if (last == 'R') {
                    bRealF3 = true;
                }
            }
        } else {
            kt = null;
        }
        int mods = num2 - 1;
        if (bEsc) {
            mods = mods >= 0 ? (mods |= 2) : 2;
        }
        if (bPuttyCtrl) {
            mods = mods >= 0 ? (mods |= 4) : 4;
        }
        if (bRealF3) {
            mods = -1;
        }
        return this.getKeyStroke(kt, mods);
    }

    @Override
    public CharacterPattern.Matching match(List<Character> cur) {
        State state = State.START;
        int num1 = 0;
        int num2 = 0;
        char first = '\u0000';
        char last = '\u0000';
        boolean bEsc = false;
        for (char ch : cur) {
            switch (state) {
                case START: {
                    if (ch != '\u001b') {
                        return null;
                    }
                    state = State.INTRO;
                    break;
                }
                case INTRO: {
                    if (this.useEscEsc && ch == '\u001b' && !bEsc) {
                        bEsc = true;
                        break;
                    }
                    if (ch != '[' && ch != 'O') {
                        return null;
                    }
                    first = ch;
                    state = State.NUM1;
                    break;
                }
                case NUM1: {
                    if (ch == ';') {
                        state = State.NUM2;
                        break;
                    }
                    if (Character.isDigit(ch)) {
                        num1 = num1 * 10 + Character.digit(ch, 10);
                        break;
                    }
                    last = ch;
                    state = State.DONE;
                    break;
                }
                case NUM2: {
                    if (Character.isDigit(ch)) {
                        num2 = num2 * 10 + Character.digit(ch, 10);
                        break;
                    }
                    last = ch;
                    state = State.DONE;
                    break;
                }
                case DONE: {
                    return null;
                }
            }
        }
        if (state == State.DONE) {
            KeyStroke ks = this.getKeyStrokeRaw(first, num1, num2, last, bEsc);
            return ks != null ? new CharacterPattern.Matching(ks) : null;
        }
        return CharacterPattern.Matching.NOT_YET;
    }

    private static enum State {
        START,
        INTRO,
        NUM1,
        NUM2,
        DONE;

    }
}

