/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.screen;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TextCharacter;
import com.googlecode.lanterna.graphics.TextGraphics;
import com.googlecode.lanterna.graphics.TextImage;
import com.googlecode.lanterna.screen.Screen;
import com.googlecode.lanterna.screen.ScreenBuffer;
import com.googlecode.lanterna.screen.ScreenTextGraphics;
import com.googlecode.lanterna.screen.TabBehaviour;
import java.io.IOException;

public abstract class AbstractScreen
implements Screen {
    private TerminalPosition cursorPosition;
    private ScreenBuffer backBuffer;
    private ScreenBuffer frontBuffer;
    private final TextCharacter defaultCharacter;
    private TabBehaviour tabBehaviour;
    private TerminalSize terminalSize;
    private TerminalSize latestResizeRequest;

    public AbstractScreen(TerminalSize initialSize) {
        this(initialSize, DEFAULT_CHARACTER);
    }

    public AbstractScreen(TerminalSize initialSize, TextCharacter defaultCharacter) {
        this.frontBuffer = new ScreenBuffer(initialSize, defaultCharacter);
        this.backBuffer = new ScreenBuffer(initialSize, defaultCharacter);
        this.defaultCharacter = defaultCharacter;
        this.cursorPosition = new TerminalPosition(0, 0);
        this.tabBehaviour = TabBehaviour.ALIGN_TO_COLUMN_4;
        this.terminalSize = initialSize;
        this.latestResizeRequest = null;
    }

    @Override
    public TerminalPosition getCursorPosition() {
        return this.cursorPosition;
    }

    @Override
    public void setCursorPosition(TerminalPosition position) {
        if (position == null) {
            this.cursorPosition = null;
            return;
        }
        if (position.getColumn() < 0) {
            position = position.withColumn(0);
        }
        if (position.getRow() < 0) {
            position = position.withRow(0);
        }
        if (position.getColumn() >= this.terminalSize.getColumns()) {
            position = position.withColumn(this.terminalSize.getColumns() - 1);
        }
        if (position.getRow() >= this.terminalSize.getRows()) {
            position = position.withRow(this.terminalSize.getRows() - 1);
        }
        this.cursorPosition = position;
    }

    @Override
    public void setTabBehaviour(TabBehaviour tabBehaviour) {
        if (tabBehaviour != null) {
            this.tabBehaviour = tabBehaviour;
        }
    }

    @Override
    public TabBehaviour getTabBehaviour() {
        return this.tabBehaviour;
    }

    @Override
    public void setCharacter(TerminalPosition position, TextCharacter screenCharacter) {
        this.setCharacter(position.getColumn(), position.getRow(), screenCharacter);
    }

    @Override
    public TextGraphics newTextGraphics() {
        return new ScreenTextGraphics(this){

            @Override
            public TextGraphics drawImage(TerminalPosition topLeft, TextImage image, TerminalPosition sourceImageTopLeft, TerminalSize sourceImageSize) {
                AbstractScreen.this.backBuffer.copyFrom(image, sourceImageTopLeft.getRow(), sourceImageSize.getRows(), sourceImageTopLeft.getColumn(), sourceImageSize.getColumns(), topLeft.getRow(), topLeft.getColumn());
                return this;
            }
        };
    }

    @Override
    public synchronized void setCharacter(int column, int row, TextCharacter screenCharacter) {
        if (screenCharacter.is('\t')) {
            screenCharacter = screenCharacter.withCharacter(' ');
            int i = 0;
            while (i < this.tabBehaviour.replaceTabs("\t", column).length()) {
                this.backBuffer.setCharacterAt(column + i, row, screenCharacter);
                ++i;
            }
        } else {
            this.backBuffer.setCharacterAt(column, row, screenCharacter);
        }
    }

    @Override
    public synchronized TextCharacter getFrontCharacter(TerminalPosition position) {
        return this.getFrontCharacter(position.getColumn(), position.getRow());
    }

    @Override
    public TextCharacter getFrontCharacter(int column, int row) {
        return this.getCharacterFromBuffer(this.frontBuffer, column, row);
    }

    @Override
    public synchronized TextCharacter getBackCharacter(TerminalPosition position) {
        return this.getBackCharacter(position.getColumn(), position.getRow());
    }

    @Override
    public TextCharacter getBackCharacter(int column, int row) {
        return this.getCharacterFromBuffer(this.backBuffer, column, row);
    }

    @Override
    public void refresh() throws IOException {
        this.refresh(Screen.RefreshType.AUTOMATIC);
    }

    @Override
    public void close() throws IOException {
        this.stopScreen();
    }

    @Override
    public synchronized void clear() {
        this.backBuffer.setAll(this.defaultCharacter);
    }

    @Override
    public synchronized TerminalSize doResizeIfNecessary() {
        TerminalSize pendingResize = this.getAndClearPendingResize();
        if (pendingResize == null) {
            return null;
        }
        this.backBuffer = this.backBuffer.resize(pendingResize, this.defaultCharacter);
        this.frontBuffer = this.frontBuffer.resize(pendingResize, this.defaultCharacter);
        return pendingResize;
    }

    @Override
    public TerminalSize getTerminalSize() {
        return this.terminalSize;
    }

    protected ScreenBuffer getFrontBuffer() {
        return this.frontBuffer;
    }

    protected ScreenBuffer getBackBuffer() {
        return this.backBuffer;
    }

    private synchronized TerminalSize getAndClearPendingResize() {
        if (this.latestResizeRequest != null) {
            this.terminalSize = this.latestResizeRequest;
            this.latestResizeRequest = null;
            return this.terminalSize;
        }
        return null;
    }

    protected void addResizeRequest(TerminalSize newSize) {
        this.latestResizeRequest = newSize;
    }

    private TextCharacter getCharacterFromBuffer(ScreenBuffer buffer, int column, int row) {
        return buffer.getCharacterAt(column, row);
    }

    public String toString() {
        return this.getBackBuffer().toString();
    }

    @Override
    public void scrollLines(int firstLine, int lastLine, int distance) {
        this.getBackBuffer().scrollLines(firstLine, lastLine, distance);
    }
}

