/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.screen;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TextCharacter;
import com.googlecode.lanterna.graphics.BasicTextImage;
import com.googlecode.lanterna.graphics.TextGraphics;
import com.googlecode.lanterna.graphics.TextImage;

public class ScreenBuffer
implements TextImage {
    private final BasicTextImage backend;

    public ScreenBuffer(TerminalSize size, TextCharacter filler) {
        this(new BasicTextImage(size, filler));
    }

    private ScreenBuffer(BasicTextImage backend) {
        this.backend = backend;
    }

    @Override
    public ScreenBuffer resize(TerminalSize newSize, TextCharacter filler) {
        BasicTextImage resizedBackend = this.backend.resize(newSize, filler);
        return new ScreenBuffer(resizedBackend);
    }

    boolean isVeryDifferent(ScreenBuffer other, int threshold) {
        if (!this.getSize().equals(other.getSize())) {
            throw new IllegalArgumentException("Can only call isVeryDifferent comparing two ScreenBuffers of the same size! This is probably a bug in Lanterna.");
        }
        int differences = 0;
        int y = 0;
        while (y < this.getSize().getRows()) {
            int x = 0;
            while (x < this.getSize().getColumns()) {
                if (!this.getCharacterAt(x, y).equals(other.getCharacterAt(x, y)) && ++differences >= threshold) {
                    return true;
                }
                ++x;
            }
            ++y;
        }
        return false;
    }

    @Override
    public TerminalSize getSize() {
        return this.backend.getSize();
    }

    @Override
    public TextCharacter getCharacterAt(TerminalPosition position) {
        return this.backend.getCharacterAt(position);
    }

    @Override
    public TextCharacter getCharacterAt(int column, int row) {
        return this.backend.getCharacterAt(column, row);
    }

    @Override
    public void setCharacterAt(TerminalPosition position, TextCharacter character) {
        this.backend.setCharacterAt(position, character);
    }

    @Override
    public void setCharacterAt(int column, int row, TextCharacter character) {
        this.backend.setCharacterAt(column, row, character);
    }

    @Override
    public void setAll(TextCharacter character) {
        this.backend.setAll(character);
    }

    @Override
    public TextGraphics newTextGraphics() {
        return this.backend.newTextGraphics();
    }

    @Override
    public void copyTo(TextImage destination) {
        if (destination instanceof ScreenBuffer) {
            destination = ((ScreenBuffer)destination).backend;
        }
        this.backend.copyTo(destination);
    }

    @Override
    public void copyTo(TextImage destination, int startRowIndex, int rows, int startColumnIndex, int columns, int destinationRowOffset, int destinationColumnOffset) {
        if (destination instanceof ScreenBuffer) {
            destination = ((ScreenBuffer)destination).backend;
        }
        this.backend.copyTo(destination, startRowIndex, rows, startColumnIndex, columns, destinationRowOffset, destinationColumnOffset);
    }

    public void copyFrom(TextImage source, int startRowIndex, int rows, int startColumnIndex, int columns, int destinationRowOffset, int destinationColumnOffset) {
        source.copyTo(this.backend, startRowIndex, rows, startColumnIndex, columns, destinationRowOffset, destinationColumnOffset);
    }

    @Override
    public void scrollLines(int firstLine, int lastLine, int distance) {
        this.backend.scrollLines(firstLine, lastLine, distance);
    }

    public String toString() {
        return this.backend.toString();
    }
}

