/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.screen;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TextCharacter;
import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.graphics.TextGraphics;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.input.KeyType;
import com.googlecode.lanterna.screen.AbstractScreen;
import com.googlecode.lanterna.screen.Screen;
import java.io.IOException;

public class VirtualScreen
extends AbstractScreen {
    private final Screen realScreen;
    private final FrameRenderer frameRenderer = new DefaultFrameRenderer();
    private TerminalSize minimumSize;
    private TerminalPosition viewportTopLeft;
    private TerminalSize viewportSize;

    public VirtualScreen(Screen screen) {
        super(screen.getTerminalSize());
        this.realScreen = screen;
        this.minimumSize = screen.getTerminalSize();
        this.viewportTopLeft = TerminalPosition.TOP_LEFT_CORNER;
        this.viewportSize = this.minimumSize;
    }

    public void setMinimumSize(TerminalSize minimumSize) {
        this.minimumSize = minimumSize;
        TerminalSize virtualSize = minimumSize.max(this.realScreen.getTerminalSize());
        if (!minimumSize.equals(virtualSize)) {
            this.addResizeRequest(virtualSize);
            super.doResizeIfNecessary();
        }
        this.calculateViewport(this.realScreen.getTerminalSize());
    }

    public TerminalSize getMinimumSize() {
        return this.minimumSize;
    }

    public TerminalSize getViewportSize() {
        return this.viewportSize;
    }

    public void setViewportTopLeft(TerminalPosition position) {
        this.viewportTopLeft = position;
        while (this.viewportTopLeft.getColumn() > 0 && this.viewportTopLeft.getColumn() + this.viewportSize.getColumns() > this.minimumSize.getColumns()) {
            this.viewportTopLeft = this.viewportTopLeft.withRelativeColumn(-1);
        }
        while (this.viewportTopLeft.getRow() > 0 && this.viewportTopLeft.getRow() + this.viewportSize.getRows() > this.minimumSize.getRows()) {
            this.viewportTopLeft = this.viewportTopLeft.withRelativeRow(-1);
        }
    }

    @Override
    public void startScreen() throws IOException {
        this.realScreen.startScreen();
    }

    @Override
    public void stopScreen() throws IOException {
        this.realScreen.stopScreen();
    }

    @Override
    public TextCharacter getFrontCharacter(TerminalPosition position) {
        return null;
    }

    @Override
    public void setCursorPosition(TerminalPosition position) {
        super.setCursorPosition(position);
        if (position == null) {
            this.realScreen.setCursorPosition(null);
            return;
        }
        if ((position = position.withRelativeColumn(-this.viewportTopLeft.getColumn()).withRelativeRow(-this.viewportTopLeft.getRow())).getColumn() >= 0 && position.getColumn() < this.viewportSize.getColumns() && position.getRow() >= 0 && position.getRow() < this.viewportSize.getRows()) {
            this.realScreen.setCursorPosition(position);
        } else {
            this.realScreen.setCursorPosition(null);
        }
    }

    @Override
    public synchronized TerminalSize doResizeIfNecessary() {
        TerminalSize underlyingSize = this.realScreen.doResizeIfNecessary();
        if (underlyingSize == null) {
            return null;
        }
        TerminalSize newVirtualSize = this.calculateViewport(underlyingSize);
        if (!this.getTerminalSize().equals(newVirtualSize)) {
            this.addResizeRequest(newVirtualSize);
            return super.doResizeIfNecessary();
        }
        return newVirtualSize;
    }

    private TerminalSize calculateViewport(TerminalSize realTerminalSize) {
        TerminalSize newVirtualSize = this.minimumSize.max(realTerminalSize);
        if (newVirtualSize.equals(realTerminalSize)) {
            this.viewportSize = realTerminalSize;
            this.viewportTopLeft = TerminalPosition.TOP_LEFT_CORNER;
        } else {
            TerminalSize newViewportSize = this.frameRenderer.getViewportSize(realTerminalSize, newVirtualSize);
            if (newViewportSize.getRows() > this.viewportSize.getRows()) {
                this.viewportTopLeft = this.viewportTopLeft.withRow(Math.max(0, this.viewportTopLeft.getRow() - (newViewportSize.getRows() - this.viewportSize.getRows())));
            }
            if (newViewportSize.getColumns() > this.viewportSize.getColumns()) {
                this.viewportTopLeft = this.viewportTopLeft.withColumn(Math.max(0, this.viewportTopLeft.getColumn() - (newViewportSize.getColumns() - this.viewportSize.getColumns())));
            }
            this.viewportSize = newViewportSize;
        }
        return newVirtualSize;
    }

    @Override
    public void refresh(Screen.RefreshType refreshType) throws IOException {
        this.setCursorPosition(this.getCursorPosition());
        if (!this.viewportSize.equals(this.realScreen.getTerminalSize())) {
            this.frameRenderer.drawFrame(this.realScreen.newTextGraphics(), this.realScreen.getTerminalSize(), this.getTerminalSize(), this.viewportTopLeft);
        }
        TerminalPosition viewportOffset = this.frameRenderer.getViewportOffset();
        if (this.realScreen instanceof AbstractScreen) {
            AbstractScreen asAbstractScreen = (AbstractScreen)this.realScreen;
            this.getBackBuffer().copyTo(asAbstractScreen.getBackBuffer(), this.viewportTopLeft.getRow(), this.viewportSize.getRows(), this.viewportTopLeft.getColumn(), this.viewportSize.getColumns(), viewportOffset.getRow(), viewportOffset.getColumn());
        } else {
            int y = 0;
            while (y < this.viewportSize.getRows()) {
                int x = 0;
                while (x < this.viewportSize.getColumns()) {
                    this.realScreen.setCharacter(x + viewportOffset.getColumn(), y + viewportOffset.getRow(), this.getBackBuffer().getCharacterAt(x + this.viewportTopLeft.getColumn(), y + this.viewportTopLeft.getRow()));
                    ++x;
                }
                ++y;
            }
        }
        this.realScreen.refresh(refreshType);
    }

    @Override
    public KeyStroke pollInput() throws IOException {
        return this.filter(this.realScreen.pollInput());
    }

    @Override
    public KeyStroke readInput() throws IOException {
        return this.filter(this.realScreen.readInput());
    }

    private KeyStroke filter(KeyStroke keyStroke) throws IOException {
        if (keyStroke == null) {
            return null;
        }
        if (keyStroke.isAltDown() && keyStroke.getKeyType() == KeyType.ArrowLeft) {
            if (this.viewportTopLeft.getColumn() > 0) {
                this.viewportTopLeft = this.viewportTopLeft.withRelativeColumn(-1);
                this.refresh();
                return null;
            }
        } else if (keyStroke.isAltDown() && keyStroke.getKeyType() == KeyType.ArrowRight) {
            if (this.viewportTopLeft.getColumn() + this.viewportSize.getColumns() < this.getTerminalSize().getColumns()) {
                this.viewportTopLeft = this.viewportTopLeft.withRelativeColumn(1);
                this.refresh();
                return null;
            }
        } else if (keyStroke.isAltDown() && keyStroke.getKeyType() == KeyType.ArrowUp) {
            if (this.viewportTopLeft.getRow() > 0) {
                this.viewportTopLeft = this.viewportTopLeft.withRelativeRow(-1);
                this.realScreen.scrollLines(0, this.viewportSize.getRows() - 1, -1);
                this.refresh();
                return null;
            }
        } else if (keyStroke.isAltDown() && keyStroke.getKeyType() == KeyType.ArrowDown && this.viewportTopLeft.getRow() + this.viewportSize.getRows() < this.getTerminalSize().getRows()) {
            this.viewportTopLeft = this.viewportTopLeft.withRelativeRow(1);
            this.realScreen.scrollLines(0, this.viewportSize.getRows() - 1, 1);
            this.refresh();
            return null;
        }
        return keyStroke;
    }

    @Override
    public void scrollLines(int firstLine, int lastLine, int distance) {
        super.scrollLines(firstLine, lastLine, distance);
        int vpFirst = this.viewportTopLeft.getRow();
        int vpRows = this.viewportSize.getRows();
        firstLine = Math.max(0, firstLine - vpFirst);
        lastLine = Math.min(vpRows - 1, lastLine - vpFirst);
        if (firstLine <= lastLine) {
            this.realScreen.scrollLines(firstLine, lastLine, distance);
        }
    }

    private static class DefaultFrameRenderer
    implements FrameRenderer {
        private DefaultFrameRenderer() {
        }

        @Override
        public TerminalSize getViewportSize(TerminalSize realSize, TerminalSize virtualSize) {
            if (realSize.getColumns() > 1 && realSize.getRows() > 2) {
                return realSize.withRelativeColumns(-1).withRelativeRows(-2);
            }
            return realSize;
        }

        @Override
        public TerminalPosition getViewportOffset() {
            return TerminalPosition.TOP_LEFT_CORNER;
        }

        @Override
        public void drawFrame(TextGraphics graphics, TerminalSize realSize, TerminalSize virtualSize, TerminalPosition virtualScrollPosition) {
            if (realSize.getColumns() == 1 || realSize.getRows() <= 2) {
                return;
            }
            TerminalSize viewportSize = this.getViewportSize(realSize, virtualSize);
            graphics.setForegroundColor(TextColor.ANSI.WHITE);
            graphics.setBackgroundColor(TextColor.ANSI.BLACK);
            graphics.fill(' ');
            graphics.putString(0, graphics.getSize().getRows() - 1, "Terminal too small, use ALT+arrows to scroll");
            int horizontalSize = (int)((double)viewportSize.getColumns() / (double)virtualSize.getColumns() * (double)viewportSize.getColumns());
            int scrollable = viewportSize.getColumns() - horizontalSize - 1;
            int horizontalPosition = (int)((double)scrollable * ((double)virtualScrollPosition.getColumn() / (double)(virtualSize.getColumns() - viewportSize.getColumns())));
            graphics.drawLine(new TerminalPosition(horizontalPosition, graphics.getSize().getRows() - 2), new TerminalPosition(horizontalPosition + horizontalSize, graphics.getSize().getRows() - 2), '\u2592');
            int verticalSize = (int)((double)viewportSize.getRows() / (double)virtualSize.getRows() * (double)viewportSize.getRows());
            scrollable = viewportSize.getRows() - verticalSize - 1;
            int verticalPosition = (int)((double)scrollable * ((double)virtualScrollPosition.getRow() / (double)(virtualSize.getRows() - viewportSize.getRows())));
            graphics.drawLine(new TerminalPosition(graphics.getSize().getColumns() - 1, verticalPosition), new TerminalPosition(graphics.getSize().getColumns() - 1, verticalPosition + verticalSize), '\u2592');
        }
    }

    public static interface FrameRenderer {
        public TerminalSize getViewportSize(TerminalSize var1, TerminalSize var2);

        public TerminalPosition getViewportOffset();

        public void drawFrame(TextGraphics var1, TerminalSize var2, TerminalSize var3, TerminalPosition var4);
    }
}

