/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal.swing;

import com.googlecode.lanterna.Symbols;
import com.googlecode.lanterna.TextCharacter;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AWTTerminalFontConfiguration {
    public static final int DEFAULT_FONT_SIZE = 14;
    private static final Set<String> MONOSPACE_CHECK_OVERRIDE = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("VL Gothic Regular", "NanumGothic", "WenQuanYi Zen Hei Mono", "WenQuanYi Zen Hei", "AR PL UMing TW", "AR PL UMing HK", "AR PL UMing CN")));
    private final List<Font> fontPriority;
    private final int fontWidth;
    private final int fontHeight;
    private final boolean useAntiAliasing;
    private final BoldMode boldMode;
    private static final Set<Character> SYMBOLS_CACHE = new HashSet<Character>();

    static {
        Field[] fieldArray = Symbols.class.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getType() == Character.TYPE && (field.getModifiers() & 0x10) != 0 && (field.getModifiers() & 8) != 0) {
                try {
                    SYMBOLS_CACHE.add(Character.valueOf(field.getChar(null)));
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }

    private static List<Font> getDefaultWindowsFonts(int fontSize) {
        int adjustedFontSize = AWTTerminalFontConfiguration.getAdjustedFontSize(fontSize);
        return Collections.unmodifiableList(Arrays.asList(new Font("Courier New", 0, adjustedFontSize), new Font("Monospaced", 0, adjustedFontSize)));
    }

    private static List<Font> getDefaultLinuxFonts(int fontSize) {
        int adjustedFontSize = AWTTerminalFontConfiguration.getAdjustedFontSize(fontSize);
        return Collections.unmodifiableList(Arrays.asList(new Font("DejaVu Sans Mono", 0, adjustedFontSize), new Font("Monospaced", 0, adjustedFontSize), new Font("Ubuntu Mono", 0, adjustedFontSize), new Font("FreeMono", 0, adjustedFontSize), new Font("Liberation Mono", 0, adjustedFontSize), new Font("VL Gothic Regular", 0, adjustedFontSize), new Font("NanumGothic", 0, adjustedFontSize), new Font("WenQuanYi Zen Hei Mono", 0, adjustedFontSize), new Font("WenQuanYi Zen Hei", 0, adjustedFontSize), new Font("AR PL UMing TW", 0, adjustedFontSize), new Font("AR PL UMing HK", 0, adjustedFontSize), new Font("AR PL UMing CN", 0, adjustedFontSize)));
    }

    private static List<Font> getDefaultFonts(int fontSize) {
        int adjustedFontSize = AWTTerminalFontConfiguration.getAdjustedFontSize(fontSize);
        return Collections.unmodifiableList(Collections.singletonList(new Font("Monospaced", 0, adjustedFontSize)));
    }

    private static int getAdjustedFontSize(int fontSize) {
        int baseFontSize = fontSize;
        String[] javaVersion = System.getProperty("java.version", "1").split("\\.");
        if (System.getProperty("os.name", "").startsWith("Windows") && Integer.parseInt(javaVersion[0]) >= 9) {
            return baseFontSize;
        }
        return AWTTerminalFontConfiguration.getHPIAdjustedFontSize(baseFontSize);
    }

    private static int getHPIAdjustedFontSize(int baseFontSize) {
        if (Toolkit.getDefaultToolkit().getScreenResolution() >= 110) {
            return Toolkit.getDefaultToolkit().getScreenResolution() / (baseFontSize / 2) + 1;
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (ge.getMaximumWindowBounds().getWidth() > 4096.0) {
            return baseFontSize * 4;
        }
        if (ge.getMaximumWindowBounds().getWidth() > 2048.0) {
            return baseFontSize * 2;
        }
        return baseFontSize;
    }

    protected static Font[] selectDefaultFont() {
        return AWTTerminalFontConfiguration.selectDefaultFont(14);
    }

    protected static Font[] selectDefaultFont(int fontSize) {
        String osName = System.getProperty("os.name", "").toLowerCase();
        if (osName.contains("win")) {
            List<Font> windowsFonts = AWTTerminalFontConfiguration.getDefaultWindowsFonts(fontSize);
            return windowsFonts.toArray(new Font[0]);
        }
        if (osName.contains("linux")) {
            List<Font> linuxFonts = AWTTerminalFontConfiguration.getDefaultLinuxFonts(fontSize);
            return linuxFonts.toArray(new Font[0]);
        }
        List<Font> defaultFonts = AWTTerminalFontConfiguration.getDefaultFonts(fontSize);
        return defaultFonts.toArray(new Font[0]);
    }

    public static AWTTerminalFontConfiguration getDefault() {
        return AWTTerminalFontConfiguration.newInstance(AWTTerminalFontConfiguration.filterMonospaced(AWTTerminalFontConfiguration.selectDefaultFont(14)));
    }

    public static AWTTerminalFontConfiguration getDefaultOfSize(int fontSize) {
        return AWTTerminalFontConfiguration.newInstance(AWTTerminalFontConfiguration.filterMonospaced(AWTTerminalFontConfiguration.selectDefaultFont(fontSize)));
    }

    public static Font[] filterMonospaced(Font ... fonts) {
        ArrayList<Font> result = new ArrayList<Font>(fonts.length);
        Font[] fontArray = fonts;
        int n = fonts.length;
        int n2 = 0;
        while (n2 < n) {
            Font font = fontArray[n2];
            if (AWTTerminalFontConfiguration.isFontMonospaced(font)) {
                result.add(font);
            }
            ++n2;
        }
        return result.toArray(new Font[0]);
    }

    public static AWTTerminalFontConfiguration newInstance(Font ... fontsInOrderOfPriority) {
        return new AWTTerminalFontConfiguration(true, BoldMode.EVERYTHING_BUT_SYMBOLS, fontsInOrderOfPriority);
    }

    protected AWTTerminalFontConfiguration(boolean useAntiAliasing, BoldMode boldMode, Font ... fontsInOrderOfPriority) {
        if (fontsInOrderOfPriority == null || fontsInOrderOfPriority.length == 0) {
            throw new IllegalArgumentException("Must pass in a valid list of fonts to SwingTerminalFontConfiguration");
        }
        this.useAntiAliasing = useAntiAliasing;
        this.boldMode = boldMode;
        this.fontPriority = new ArrayList<Font>(Arrays.asList(fontsInOrderOfPriority));
        this.fontWidth = this.getFontWidth(this.fontPriority.get(0));
        this.fontHeight = this.getFontHeight(this.fontPriority.get(0));
        for (Font font : this.fontPriority) {
            if (AWTTerminalFontConfiguration.isFontMonospaced(font)) continue;
            throw new IllegalArgumentException("Font " + font + " isn't monospaced!");
        }
        int i = 1;
        while (i < this.fontPriority.size()) {
            Font font = this.fontPriority.get(i);
            while (this.getFontWidth(font) > this.fontWidth || this.getFontHeight(font) > this.fontHeight) {
                float newSize = font.getSize2D() - 0.5f;
                if ((double)newSize < 0.01) {
                    throw new IllegalStateException("Unable to shrink font " + (i + 1) + " to fit the size of highest priority font " + this.fontPriority.get(0));
                }
                font = font.deriveFont(newSize);
                this.fontPriority.set(i, font);
            }
            ++i;
        }
    }

    Font getFontForCharacter(TextCharacter character) {
        Font normalFont = this.getFontForCharacter(character.getCharacterString());
        if ((this.boldMode == BoldMode.EVERYTHING || this.boldMode == BoldMode.EVERYTHING_BUT_SYMBOLS && this.isNotASymbol(character.getCharacterString().charAt(0))) && character.isBold()) {
            normalFont = normalFont.deriveFont(1);
        }
        if (character.isItalic()) {
            normalFont = normalFont.deriveFont(2);
        }
        return normalFont;
    }

    private Font getFontForCharacter(String string) {
        for (Font font : this.fontPriority) {
            if (font.canDisplayUpTo(string) != -1) continue;
            return font;
        }
        return this.fontPriority.get(0);
    }

    public int getFontWidth() {
        return this.fontWidth;
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public boolean isAntiAliased() {
        return this.useAntiAliasing;
    }

    private static boolean isFontMonospaced(Font font) {
        if (MONOSPACE_CHECK_OVERRIDE.contains(font.getName())) {
            return true;
        }
        FontRenderContext frc = new FontRenderContext(null, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF, RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT);
        Rectangle2D iBounds = font.getStringBounds("i", frc);
        Rectangle2D mBounds = font.getStringBounds("W", frc);
        return iBounds.getWidth() == mBounds.getWidth();
    }

    private int getFontWidth(Font font) {
        return (int)font.getStringBounds("W", this.getFontRenderContext()).getWidth();
    }

    private int getFontHeight(Font font) {
        return (int)font.getStringBounds("W", this.getFontRenderContext()).getHeight();
    }

    private FontRenderContext getFontRenderContext() {
        return new FontRenderContext(null, this.useAntiAliasing ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF, RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT);
    }

    private boolean isNotASymbol(char character) {
        return !SYMBOLS_CACHE.contains(Character.valueOf(character));
    }

    public static enum BoldMode {
        EVERYTHING,
        EVERYTHING_BUT_SYMBOLS,
        NOTHING;

    }
}

