/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal.swing;

import com.googlecode.lanterna.SGR;
import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.graphics.TextGraphics;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.terminal.IOSafeTerminal;
import com.googlecode.lanterna.terminal.TerminalResizeListener;
import com.googlecode.lanterna.terminal.swing.AWTTerminal;
import com.googlecode.lanterna.terminal.swing.SwingTerminalFontConfiguration;
import com.googlecode.lanterna.terminal.swing.TerminalEmulatorColorConfiguration;
import com.googlecode.lanterna.terminal.swing.TerminalEmulatorDeviceConfiguration;
import com.googlecode.lanterna.terminal.swing.TerminalScrollController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.concurrent.TimeUnit;

public class ScrollingAWTTerminal
extends Container
implements IOSafeTerminal {
    private final AWTTerminal awtTerminal;
    private final Scrollbar scrollBar = new Scrollbar(1);
    private volatile boolean scrollModelUpdateBySystem;

    public ScrollingAWTTerminal() {
        this(TerminalEmulatorDeviceConfiguration.getDefault(), SwingTerminalFontConfiguration.getDefault(), TerminalEmulatorColorConfiguration.getDefault());
    }

    public ScrollingAWTTerminal(TerminalEmulatorDeviceConfiguration deviceConfiguration, SwingTerminalFontConfiguration fontConfiguration, TerminalEmulatorColorConfiguration colorConfiguration) {
        this.awtTerminal = new AWTTerminal(deviceConfiguration, fontConfiguration, colorConfiguration, new ScrollController());
        this.setLayout(new BorderLayout());
        this.add((Component)this.awtTerminal, "Center");
        this.add((Component)this.scrollBar, "East");
        this.scrollBar.setMinimum(0);
        this.scrollBar.setMaximum(20);
        this.scrollBar.setValue(0);
        this.scrollBar.setVisibleAmount(20);
        this.scrollBar.addAdjustmentListener(new ScrollbarListener());
        this.scrollModelUpdateBySystem = false;
    }

    public void addInput(KeyStroke keyStroke) {
        this.awtTerminal.addInput(keyStroke);
    }

    @Override
    public KeyStroke pollInput() {
        return this.awtTerminal.pollInput();
    }

    @Override
    public KeyStroke readInput() {
        return this.awtTerminal.readInput();
    }

    @Override
    public void enterPrivateMode() {
        this.awtTerminal.enterPrivateMode();
    }

    @Override
    public void exitPrivateMode() {
        this.awtTerminal.exitPrivateMode();
    }

    @Override
    public void clearScreen() {
        this.awtTerminal.clearScreen();
    }

    @Override
    public void setCursorPosition(int x, int y) {
        this.awtTerminal.setCursorPosition(x, y);
    }

    @Override
    public void setCursorPosition(TerminalPosition position) {
        this.awtTerminal.setCursorPosition(position);
    }

    @Override
    public TerminalPosition getCursorPosition() {
        return this.awtTerminal.getCursorPosition();
    }

    @Override
    public void setCursorVisible(boolean visible) {
        this.awtTerminal.setCursorVisible(visible);
    }

    @Override
    public void putCharacter(char c) {
        this.awtTerminal.putCharacter(c);
    }

    @Override
    public void putString(String string) {
        this.awtTerminal.putString(string);
    }

    @Override
    public TextGraphics newTextGraphics() {
        return this.awtTerminal.newTextGraphics();
    }

    @Override
    public void enableSGR(SGR sgr) {
        this.awtTerminal.enableSGR(sgr);
    }

    @Override
    public void disableSGR(SGR sgr) {
        this.awtTerminal.disableSGR(sgr);
    }

    @Override
    public void resetColorAndSGR() {
        this.awtTerminal.resetColorAndSGR();
    }

    @Override
    public void setForegroundColor(TextColor color) {
        this.awtTerminal.setForegroundColor(color);
    }

    @Override
    public void setBackgroundColor(TextColor color) {
        this.awtTerminal.setBackgroundColor(color);
    }

    @Override
    public TerminalSize getTerminalSize() {
        return this.awtTerminal.getTerminalSize();
    }

    @Override
    public byte[] enquireTerminal(int timeout, TimeUnit timeoutUnit) {
        return this.awtTerminal.enquireTerminal(timeout, timeoutUnit);
    }

    @Override
    public void bell() {
        this.awtTerminal.bell();
    }

    @Override
    public void flush() {
        this.awtTerminal.flush();
    }

    @Override
    public void close() {
        this.awtTerminal.close();
    }

    @Override
    public void addResizeListener(TerminalResizeListener listener) {
        this.awtTerminal.addResizeListener(listener);
    }

    @Override
    public void removeResizeListener(TerminalResizeListener listener) {
        this.awtTerminal.removeResizeListener(listener);
    }

    private class ScrollController
    implements TerminalScrollController {
        private int scrollValue;

        private ScrollController() {
        }

        @Override
        public void updateModel(int totalSize, int screenHeight) {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(() -> this.updateModel(totalSize, screenHeight));
                return;
            }
            try {
                ScrollingAWTTerminal.this.scrollModelUpdateBySystem = true;
                int value = ScrollingAWTTerminal.this.scrollBar.getValue();
                int maximum = ScrollingAWTTerminal.this.scrollBar.getMaximum();
                int visibleAmount = ScrollingAWTTerminal.this.scrollBar.getVisibleAmount();
                if (maximum != totalSize) {
                    int lastMaximum = maximum;
                    int n = maximum = totalSize > screenHeight ? totalSize : screenHeight;
                    if (lastMaximum < maximum && lastMaximum - visibleAmount - value == 0) {
                        value = ScrollingAWTTerminal.this.scrollBar.getValue() + (maximum - lastMaximum);
                    }
                }
                if (value + screenHeight > maximum) {
                    value = maximum - screenHeight;
                }
                if (visibleAmount != screenHeight) {
                    if (visibleAmount > screenHeight) {
                        value += visibleAmount - screenHeight;
                    }
                    visibleAmount = screenHeight;
                }
                if (value > maximum - visibleAmount) {
                    value = maximum - visibleAmount;
                }
                if (value < 0) {
                    value = 0;
                }
                this.scrollValue = value;
                if (ScrollingAWTTerminal.this.scrollBar.getMaximum() != maximum) {
                    ScrollingAWTTerminal.this.scrollBar.setMaximum(maximum);
                }
                if (ScrollingAWTTerminal.this.scrollBar.getVisibleAmount() != visibleAmount) {
                    ScrollingAWTTerminal.this.scrollBar.setVisibleAmount(visibleAmount);
                }
                if (ScrollingAWTTerminal.this.scrollBar.getValue() != value) {
                    ScrollingAWTTerminal.this.scrollBar.setValue(value);
                }
            }
            finally {
                ScrollingAWTTerminal.this.scrollModelUpdateBySystem = false;
            }
        }

        @Override
        public int getScrollingOffset() {
            return this.scrollValue;
        }
    }

    private class ScrollbarListener
    implements AdjustmentListener {
        private ScrollbarListener() {
        }

        @Override
        public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
            if (!ScrollingAWTTerminal.this.scrollModelUpdateBySystem) {
                ScrollingAWTTerminal.this.awtTerminal.repaint();
            }
        }
    }
}

