/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal.virtual;

import com.googlecode.lanterna.TextCharacter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

class TextBuffer {
    private static final TextCharacter DOUBLE_WIDTH_CHAR_PADDING = new TextCharacter(' ');
    private final LinkedList<List<TextCharacter>> lines = new LinkedList();

    TextBuffer() {
        this.newLine();
    }

    synchronized void newLine() {
        this.lines.add(new ArrayList(200));
    }

    synchronized void removeTopLines(int numberOfLinesToRemove) {
        int i = 0;
        while (i < numberOfLinesToRemove) {
            this.lines.removeFirst();
            ++i;
        }
    }

    synchronized void clear() {
        this.lines.clear();
        this.newLine();
    }

    ListIterator<List<TextCharacter>> getLinesFrom(int rowNumber) {
        return this.lines.listIterator(rowNumber);
    }

    synchronized int getLineCount() {
        return this.lines.size();
    }

    synchronized int setCharacter(int lineNumber, int columnIndex, TextCharacter textCharacter) {
        if (lineNumber < 0 || columnIndex < 0) {
            throw new IllegalArgumentException("Illegal argument to TextBuffer.setCharacter(..), lineNumber = " + lineNumber + ", columnIndex = " + columnIndex);
        }
        if (textCharacter == null) {
            textCharacter = TextCharacter.DEFAULT_CHARACTER;
        }
        while (lineNumber >= this.lines.size()) {
            this.newLine();
        }
        List<TextCharacter> line = this.lines.get(lineNumber);
        while (line.size() <= columnIndex) {
            line.add(TextCharacter.DEFAULT_CHARACTER);
        }
        int returnStyle = 0;
        if (line.get(columnIndex).isDoubleWidth()) {
            line.set(columnIndex + 1, line.get(columnIndex).withCharacter(' '));
            returnStyle = 1;
        } else if (line.get(columnIndex) == DOUBLE_WIDTH_CHAR_PADDING) {
            line.set(columnIndex - 1, TextCharacter.DEFAULT_CHARACTER);
            returnStyle = 2;
        }
        line.set(columnIndex, textCharacter);
        if (textCharacter.isDoubleWidth()) {
            this.setCharacter(lineNumber, columnIndex + 1, DOUBLE_WIDTH_CHAR_PADDING);
        }
        return returnStyle;
    }

    synchronized TextCharacter getCharacter(int lineNumber, int columnIndex) {
        if (lineNumber < 0 || columnIndex < 0) {
            throw new IllegalArgumentException("Illegal argument to TextBuffer.getCharacter(..), lineNumber = " + lineNumber + ", columnIndex = " + columnIndex);
        }
        if (lineNumber >= this.lines.size()) {
            return TextCharacter.DEFAULT_CHARACTER;
        }
        List<TextCharacter> line = this.lines.get(lineNumber);
        if (line.size() <= columnIndex) {
            return TextCharacter.DEFAULT_CHARACTER;
        }
        TextCharacter textCharacter = line.get(columnIndex);
        if (textCharacter == DOUBLE_WIDTH_CHAR_PADDING) {
            return line.get(columnIndex - 1);
        }
        return textCharacter;
    }

    public String toString() {
        StringBuilder bo = new StringBuilder();
        for (List list : this.lines) {
            StringBuilder b = new StringBuilder();
            for (TextCharacter c : list) {
                b.append(c.getCharacterString());
            }
            bo.append(b.toString().replaceFirst("\\s+$", ""));
            bo.append('\n');
        }
        return bo.toString();
    }
}

