/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import org.h2.command.Parser;
import org.h2.command.dml.ScriptBase;
import org.h2.command.dml.SetTypes;
import org.h2.constraint.Constraint;
import org.h2.engine.Comment;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Right;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.engine.Setting;
import org.h2.engine.SysProperties;
import org.h2.engine.User;
import org.h2.engine.UserAggregate;
import org.h2.engine.UserDataType;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.schema.Constant;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.SchemaObjectBase;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.table.Column;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.table.TableType;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.Value;
import org.h2.value.ValueString;

public class ScriptCommand
extends ScriptBase {
    private Charset charset = Constants.UTF8;
    private Set<String> schemaNames;
    private Collection<Table> tables;
    private boolean passwords;
    private boolean data;
    private boolean settings;
    private boolean drop;
    private boolean simple;
    private LocalResult result;
    private String lineSeparatorString;
    private byte[] lineSeparator;
    private byte[] buffer;
    private boolean tempLobTableCreated;
    private int nextLobId;
    private int lobBlockSize = 4096;

    public ScriptCommand(Session session) {
        super(session);
    }

    @Override
    public boolean isQuery() {
        return true;
    }

    public void setSchemaNames(Set<String> set) {
        this.schemaNames = set;
    }

    public void setTables(Collection<Table> collection) {
        this.tables = collection;
    }

    public void setData(boolean bl) {
        this.data = bl;
    }

    public void setPasswords(boolean bl) {
        this.passwords = bl;
    }

    public void setSettings(boolean bl) {
        this.settings = bl;
    }

    public void setLobBlockSize(long l) {
        this.lobBlockSize = MathUtils.convertLongToInt(l);
    }

    public void setDrop(boolean bl) {
        this.drop = bl;
    }

    @Override
    public ResultInterface queryMeta() {
        LocalResult localResult = this.createResult();
        localResult.done();
        return localResult;
    }

    private LocalResult createResult() {
        Expression[] expressionArray = new Expression[]{new ExpressionColumn(this.session.getDatabase(), new Column("SCRIPT", 13))};
        return new LocalResult(this.session, expressionArray, 1);
    }

    @Override
    public ResultInterface query(int n) {
        Object object;
        this.session.getUser().checkAdmin();
        this.reset();
        Database database = this.session.getDatabase();
        if (this.schemaNames != null) {
            for (String object32 : this.schemaNames) {
                Schema schema = database.findSchema(object32);
                if (schema != null) continue;
                throw DbException.get(90079, object32);
            }
        }
        try {
            Object object2;
            Object object3;
            Object object4;
            this.result = this.createResult();
            this.deleteStore();
            this.openOutput();
            if (this.out != null) {
                this.buffer = new byte[4096];
            }
            if (this.settings) {
                for (Setting setting : database.getAllSettings()) {
                    if (setting.getName().equals(SetTypes.getTypeName(34))) continue;
                    this.add(setting.getCreateSQL(), false);
                }
            }
            if (this.out != null) {
                this.add("", true);
            }
            for (User user : database.getAllUsers()) {
                this.add(user.getCreateSQL(this.passwords), false);
            }
            for (Role role : database.getAllRoles()) {
                this.add(role.getCreateSQL(true), false);
            }
            for (Schema schema : database.getAllSchemas()) {
                if (this.excludeSchema(schema)) continue;
                this.add(schema.getCreateSQL(), false);
            }
            for (UserDataType userDataType : database.getAllUserDataTypes()) {
                if (this.drop) {
                    this.add(userDataType.getDropSQL(), false);
                }
                this.add(userDataType.getCreateSQL(), false);
            }
            for (SchemaObject schemaObject : database.getAllSchemaObjects(11)) {
                if (this.excludeSchema(schemaObject.getSchema())) continue;
                Constant constant = (Constant)schemaObject;
                this.add(constant.getCreateSQL(), false);
            }
            object = database.getAllTablesAndViews(false);
            Collections.sort(object, new Comparator<Table>(){

                @Override
                public int compare(Table table, Table table2) {
                    return table.getId() - table2.getId();
                }
            });
            Iterator iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                Table table = (Table)iterator.next();
                if (this.excludeSchema(table.getSchema()) || this.excludeTable(table) || table.isHidden()) continue;
                table.lock(this.session, false, false);
                object4 = table.getCreateSQL();
                if (object4 == null || !this.drop) continue;
                this.add(table.getDropSQL(), false);
            }
            for (SchemaObject schemaObject : database.getAllSchemaObjects(9)) {
                if (this.excludeSchema(schemaObject.getSchema())) continue;
                if (this.drop) {
                    this.add(schemaObject.getDropSQL(), false);
                }
                this.add(schemaObject.getCreateSQL(), false);
            }
            for (UserAggregate userAggregate : database.getAllAggregates()) {
                if (this.drop) {
                    this.add(userAggregate.getDropSQL(), false);
                }
                this.add(userAggregate.getCreateSQL(), false);
            }
            for (SchemaObject schemaObject : database.getAllSchemaObjects(3)) {
                if (this.excludeSchema(schemaObject.getSchema())) continue;
                object4 = (Sequence)schemaObject;
                if (this.drop) {
                    this.add(((Sequence)object4).getDropSQL(), false);
                }
                this.add(((Sequence)object4).getCreateSQL(), false);
            }
            boolean bl = false;
            Iterator iterator2 = ((ArrayList)object).iterator();
            while (iterator2.hasNext()) {
                Object object5;
                object4 = (Table)iterator2.next();
                if (this.excludeSchema(((SchemaObjectBase)object4).getSchema()) || this.excludeTable((Table)object4) || ((Table)object4).isHidden()) continue;
                ((Table)object4).lock(this.session, false, false);
                String string = ((DbObjectBase)object4).getCreateSQL();
                if (string == null) continue;
                object3 = ((Table)object4).getTableType();
                this.add(string, false);
                object2 = ((Table)object4).getConstraints();
                if (object2 != null) {
                    object5 = ((ArrayList)object2).iterator();
                    while (object5.hasNext()) {
                        Constraint constraint = (Constraint)object5.next();
                        if (!"PRIMARY KEY".equals(constraint.getConstraintType())) continue;
                        this.add(constraint.getCreateSQLWithoutIndexes(), false);
                    }
                }
                if (TableType.TABLE == object3) {
                    if (((Table)object4).canGetRowCount()) {
                        object5 = "-- " + ((Table)object4).getRowCountApproximation() + " +/- SELECT COUNT(*) FROM " + ((SchemaObjectBase)object4).getSQL();
                        this.add((String)object5, false);
                    }
                    if (this.data) {
                        int n2;
                        n2 = this.generateInsertValues(n2, (Table)object4);
                    }
                }
                object5 = ((Table)object4).getIndexes();
                for (int i = 0; object5 != null && i < ((ArrayList)object5).size(); ++i) {
                    Index index = (Index)((ArrayList)object5).get(i);
                    if (index.getIndexType().getBelongsToConstraint()) continue;
                    this.add(index.getCreateSQL(), false);
                }
            }
            if (this.tempLobTableCreated) {
                this.add("DROP TABLE IF EXISTS SYSTEM_LOB_STREAM", true);
                this.add("CALL SYSTEM_COMBINE_BLOB(-1)", true);
                this.add("DROP ALIAS IF EXISTS SYSTEM_COMBINE_CLOB", true);
                this.add("DROP ALIAS IF EXISTS SYSTEM_COMBINE_BLOB", true);
                this.tempLobTableCreated = false;
            }
            ArrayList<SchemaObject> arrayList = database.getAllSchemaObjects(5);
            Collections.sort(arrayList, new Comparator<SchemaObject>(){

                @Override
                public int compare(SchemaObject schemaObject, SchemaObject schemaObject2) {
                    return ((Constraint)schemaObject).compareTo((Constraint)schemaObject2);
                }
            });
            for (SchemaObject schemaObject : arrayList) {
                if (this.excludeSchema(schemaObject.getSchema()) || this.excludeTable(((Constraint)(object3 = (Constraint)schemaObject)).getTable()) || ((Constraint)object3).getTable().isHidden() || "PRIMARY KEY".equals(((Constraint)object3).getConstraintType())) continue;
                this.add(((Constraint)object3).getCreateSQLWithoutIndexes(), false);
            }
            for (SchemaObject schemaObject : database.getAllSchemaObjects(4)) {
                if (this.excludeSchema(schemaObject.getSchema()) || this.excludeTable(((TriggerObject)(object3 = (TriggerObject)schemaObject)).getTable())) continue;
                this.add(((TriggerObject)object3).getCreateSQL(), false);
            }
            for (Right right : database.getAllRights()) {
                object3 = right.getGrantedObject();
                if (object3 != null && (object3 instanceof Schema ? this.excludeSchema((Schema)object3) : object3 instanceof Table && (this.excludeSchema(((SchemaObjectBase)(object2 = (Table)object3)).getSchema()) || this.excludeTable((Table)object2)))) continue;
                this.add(right.getCreateSQL(), false);
            }
            for (Comment comment : database.getAllComments()) {
                this.add(comment.getCreateSQL(), false);
            }
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.getFileName());
        }
        finally {
            this.closeIO();
        }
        this.result.done();
        object = this.result;
        this.reset();
        return object;
    }

    private int generateInsertValues(int n, Table table) throws IOException {
        int n2;
        PlanItem planItem = table.getBestPlanItem(this.session, null, null, -1, null, null);
        Index index = planItem.getIndex();
        Cursor cursor = index.find(this.session, null, null);
        Column[] columnArray = table.getColumns();
        StatementBuilder statementBuilder = new StatementBuilder("INSERT INTO ");
        statementBuilder.append(table.getSQL()).append('(');
        Column[] object = columnArray;
        int row = object.length;
        for (n2 = 0; n2 < row; ++n2) {
            Column column = object[n2];
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(Parser.quoteIdentifier(column.getName()));
        }
        statementBuilder.append(") VALUES");
        if (!this.simple) {
            statementBuilder.append('\n');
        }
        statementBuilder.append('(');
        String string = statementBuilder.toString();
        statementBuilder = null;
        while (cursor.next()) {
            Row row2 = cursor.get();
            if (statementBuilder == null) {
                statementBuilder = new StatementBuilder(string);
            } else {
                statementBuilder.append(",\n(");
            }
            for (n2 = 0; n2 < row2.getColumnCount(); ++n2) {
                Value value;
                if (n2 > 0) {
                    statementBuilder.append(", ");
                }
                if ((value = row2.getValue(n2)).getPrecision() > (long)this.lobBlockSize) {
                    int n3;
                    if (value.getType() == 16) {
                        n3 = this.writeLobStream(value);
                        statementBuilder.append("SYSTEM_COMBINE_CLOB(" + n3 + ")");
                        continue;
                    }
                    if (value.getType() == 15) {
                        n3 = this.writeLobStream(value);
                        statementBuilder.append("SYSTEM_COMBINE_BLOB(" + n3 + ")");
                        continue;
                    }
                    statementBuilder.append(value.getSQL());
                    continue;
                }
                statementBuilder.append(value.getSQL());
            }
            statementBuilder.append(')');
            if ((++n & 0x7F) == 0) {
                this.checkCanceled();
            }
            if (!this.simple && statementBuilder.length() <= 4096) continue;
            this.add(statementBuilder.toString(), true);
            statementBuilder = null;
        }
        if (statementBuilder != null) {
            this.add(statementBuilder.toString(), true);
        }
        return n;
    }

    private int writeLobStream(Value value) throws IOException {
        if (!this.tempLobTableCreated) {
            this.add("CREATE TABLE IF NOT EXISTS SYSTEM_LOB_STREAM(ID INT NOT NULL, PART INT NOT NULL, CDATA VARCHAR, BDATA BINARY)", true);
            this.add("CREATE PRIMARY KEY SYSTEM_LOB_STREAM_PRIMARY_KEY ON SYSTEM_LOB_STREAM(ID, PART)", true);
            this.add("CREATE ALIAS IF NOT EXISTS SYSTEM_COMBINE_CLOB FOR \"" + this.getClass().getName() + ".combineClob\"", true);
            this.add("CREATE ALIAS IF NOT EXISTS SYSTEM_COMBINE_BLOB FOR \"" + this.getClass().getName() + ".combineBlob\"", true);
            this.tempLobTableCreated = true;
        }
        int n = this.nextLobId++;
        block4 : switch (value.getType()) {
            case 15: {
                byte[] byArray = new byte[this.lobBlockSize];
                try (InputStream inputStream = value.getInputStream();){
                    int n2 = 0;
                    while (true) {
                        StringBuilder stringBuilder = new StringBuilder(this.lobBlockSize * 2);
                        stringBuilder.append("INSERT INTO SYSTEM_LOB_STREAM VALUES(" + n + ", " + n2 + ", NULL, '");
                        int n3 = IOUtils.readFully(inputStream, byArray, this.lobBlockSize);
                        if (n3 <= 0) {
                            break block4;
                        }
                        stringBuilder.append(StringUtils.convertBytesToHex(byArray, n3)).append("')");
                        String string = stringBuilder.toString();
                        this.add(string, true);
                        ++n2;
                    }
                }
            }
            case 16: {
                char[] cArray = new char[this.lobBlockSize];
                try (Reader reader = value.getReader();){
                    int n4 = 0;
                    while (true) {
                        StringBuilder stringBuilder = new StringBuilder(this.lobBlockSize * 2);
                        stringBuilder.append("INSERT INTO SYSTEM_LOB_STREAM VALUES(" + n + ", " + n4 + ", ");
                        int n5 = IOUtils.readFully(reader, cArray, this.lobBlockSize);
                        if (n5 == 0) {
                            break block4;
                        }
                        stringBuilder.append(StringUtils.quoteStringSQL(new String(cArray, 0, n5))).append(", NULL)");
                        String string = stringBuilder.toString();
                        this.add(string, true);
                        ++n4;
                    }
                }
            }
            default: {
                DbException.throwInternalError("type:" + value.getType());
            }
        }
        return n;
    }

    public static InputStream combineBlob(Connection connection, int n) throws SQLException {
        if (n < 0) {
            return null;
        }
        final ResultSet resultSet = ScriptCommand.getLobStream(connection, "BDATA", n);
        return new InputStream(){
            private InputStream current;
            private boolean closed;

            @Override
            public int read() throws IOException {
                try {
                    while (true) {
                        int n;
                        if (this.current == null) {
                            if (this.closed) {
                                return -1;
                            }
                            if (!resultSet.next()) {
                                this.close();
                                return -1;
                            }
                            this.current = resultSet.getBinaryStream(1);
                            this.current = new BufferedInputStream(this.current);
                        }
                        if ((n = this.current.read()) >= 0) {
                            return n;
                        }
                        this.current = null;
                    }
                }
                catch (SQLException sQLException) {
                    throw DbException.convertToIOException(sQLException);
                }
            }

            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    throw DbException.convertToIOException(sQLException);
                }
            }
        };
    }

    public static Reader combineClob(Connection connection, int n) throws SQLException {
        if (n < 0) {
            return null;
        }
        final ResultSet resultSet = ScriptCommand.getLobStream(connection, "CDATA", n);
        return new Reader(){
            private Reader current;
            private boolean closed;

            @Override
            public int read() throws IOException {
                try {
                    while (true) {
                        int n;
                        if (this.current == null) {
                            if (this.closed) {
                                return -1;
                            }
                            if (!resultSet.next()) {
                                this.close();
                                return -1;
                            }
                            this.current = resultSet.getCharacterStream(1);
                            this.current = new BufferedReader(this.current);
                        }
                        if ((n = this.current.read()) >= 0) {
                            return n;
                        }
                        this.current = null;
                    }
                }
                catch (SQLException sQLException) {
                    throw DbException.convertToIOException(sQLException);
                }
            }

            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    throw DbException.convertToIOException(sQLException);
                }
            }

            @Override
            public int read(char[] cArray, int n, int n2) throws IOException {
                int n3;
                if (n2 == 0) {
                    return 0;
                }
                int n4 = this.read();
                if (n4 == -1) {
                    return -1;
                }
                cArray[n] = (char)n4;
                for (n3 = 1; n3 < n2 && (n4 = this.read()) != -1; ++n3) {
                    cArray[n + n3] = (char)n4;
                }
                return n3;
            }
        };
    }

    private static ResultSet getLobStream(Connection connection, String string, int n) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT " + string + " FROM SYSTEM_LOB_STREAM WHERE ID=? ORDER BY PART");
        preparedStatement.setInt(1, n);
        return preparedStatement.executeQuery();
    }

    private void reset() {
        this.result = null;
        this.buffer = null;
        this.lineSeparatorString = SysProperties.LINE_SEPARATOR;
        this.lineSeparator = this.lineSeparatorString.getBytes(this.charset);
    }

    private boolean excludeSchema(Schema schema) {
        if (this.schemaNames != null && !this.schemaNames.contains(schema.getName())) {
            return true;
        }
        if (this.tables != null) {
            for (Table table : schema.getAllTablesAndViews()) {
                if (!this.tables.contains(table)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean excludeTable(Table table) {
        return this.tables != null && !this.tables.contains(table);
    }

    private void add(String object, boolean bl) throws IOException {
        if (object == null) {
            return;
        }
        if (this.lineSeparator.length > 1 || this.lineSeparator[0] != 10) {
            object = StringUtils.replaceAll((String)object, "\n", this.lineSeparatorString);
        }
        object = (String)object + ";";
        if (this.out != null) {
            int n;
            byte[] byArray = ((String)object).getBytes(this.charset);
            int n2 = MathUtils.roundUpInt(byArray.length + this.lineSeparator.length, 16);
            this.buffer = Utils.copy(byArray, this.buffer);
            if (n2 > this.buffer.length) {
                this.buffer = new byte[n2];
            }
            System.arraycopy(byArray, 0, this.buffer, 0, byArray.length);
            for (n = byArray.length; n < n2 - this.lineSeparator.length; ++n) {
                this.buffer[n] = 32;
            }
            n = 0;
            int n3 = n2 - this.lineSeparator.length;
            while (n3 < n2) {
                this.buffer[n3] = this.lineSeparator[n];
                ++n3;
                ++n;
            }
            this.out.write(this.buffer, 0, n2);
            if (!bl) {
                Value[] valueArray = new Value[]{ValueString.get((String)object)};
                this.result.addRow(valueArray);
            }
        } else {
            Value[] valueArray = new Value[]{ValueString.get((String)object)};
            this.result.addRow(valueArray);
        }
    }

    public void setSimple(boolean bl) {
        this.simple = bl;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public int getType() {
        return 65;
    }
}

