/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.h2.command.Prepared;
import org.h2.command.dml.Query;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.expression.Alias;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.ViewIndex;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.result.SortOrder;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.table.TableType;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;

public class TableView
extends Table {
    private static final long ROW_COUNT_APPROXIMATION = 100L;
    private String querySQL;
    private ArrayList<Table> tables;
    private Column[] columnTemplates;
    private Query viewQuery;
    private ViewIndex index;
    private boolean recursive;
    private DbException createException;
    private long lastModificationCheck;
    private long maxDataModificationId;
    private User owner;
    private Query topQuery;
    private ResultInterface recursiveResult;
    private boolean tableExpression;
    private boolean isRecursiveQueryDetected;

    public TableView(Schema schema, int n, String string, String string2, ArrayList<Parameter> arrayList, Column[] columnArray, Session session, boolean bl) {
        super(schema, n, string, false, true);
        this.init(string2, arrayList, columnArray, session, bl);
    }

    public void replace(String string, Session session, boolean bl, boolean bl2) {
        String string2 = this.querySQL;
        Column[] columnArray = this.columnTemplates;
        boolean bl3 = this.recursive;
        this.init(string, null, this.columnTemplates, session, bl);
        DbException dbException = this.recompile(session, bl2, true);
        if (dbException != null) {
            this.init(string2, null, columnArray, session, bl3);
            this.recompile(session, true, false);
            throw dbException;
        }
    }

    private synchronized void init(String string, ArrayList<Parameter> arrayList, Column[] columnArray, Session session, boolean bl) {
        this.querySQL = string;
        this.columnTemplates = columnArray;
        this.recursive = bl;
        this.isRecursiveQueryDetected = false;
        this.index = new ViewIndex(this, string, arrayList, bl);
        this.initColumnsAndTables(session);
    }

    private static Query compileViewQuery(Session session, String string) {
        Prepared prepared;
        session.setParsingView(true);
        try {
            prepared = session.prepare(string);
        }
        finally {
            session.setParsingView(false);
        }
        if (!(prepared instanceof Query)) {
            throw DbException.getSyntaxError(string, 0);
        }
        return (Query)prepared;
    }

    public synchronized DbException recompile(Session session, boolean bl, boolean bl2) {
        block6: {
            try {
                TableView.compileViewQuery(session, this.querySQL);
            }
            catch (DbException dbException) {
                if (bl) break block6;
                return dbException;
            }
        }
        ArrayList<TableView> arrayList = this.getViews();
        if (arrayList != null) {
            arrayList = New.arrayList(arrayList);
        }
        this.initColumnsAndTables(session);
        if (arrayList != null) {
            for (TableView tableView : arrayList) {
                DbException dbException = tableView.recompile(session, bl, false);
                if (dbException == null || bl) continue;
                return dbException;
            }
        }
        if (bl2) {
            TableView.clearIndexCaches(this.database);
        }
        return bl ? null : this.createException;
    }

    private void initColumnsAndTables(Session session) {
        Column[] columnArray;
        block13: {
            this.removeViewFromTables();
            try {
                Query query = TableView.compileViewQuery(session, this.querySQL);
                this.querySQL = query.getPlanSQL();
                this.tables = New.arrayList(query.getTables());
                ArrayList<Expression> arrayList = query.getExpressions();
                ArrayList<Column> arrayList2 = New.arrayList();
                int n = query.getColumnCount();
                for (int i = 0; i < n; ++i) {
                    Expression expression;
                    Expression expression2 = arrayList.get(i);
                    String string = null;
                    int n2 = -1;
                    if (this.columnTemplates != null && this.columnTemplates.length > i) {
                        string = this.columnTemplates[i].getName();
                        n2 = this.columnTemplates[i].getType();
                    }
                    if (string == null) {
                        string = expression2.getAlias();
                    }
                    if (n2 == -1) {
                        n2 = expression2.getType();
                    }
                    long l = expression2.getPrecision();
                    int n3 = expression2.getScale();
                    int n4 = expression2.getDisplaySize();
                    Column column = new Column(string, n2, l, n3, n4);
                    column.setTable(this, i);
                    ExpressionColumn expressionColumn = null;
                    if (expression2 instanceof ExpressionColumn) {
                        expressionColumn = (ExpressionColumn)expression2;
                    } else if (expression2 instanceof Alias && (expression = expression2.getNonAliasExpression()) instanceof ExpressionColumn) {
                        expressionColumn = (ExpressionColumn)expression;
                    }
                    if (expressionColumn != null && (expression = expressionColumn.getColumn().getCheckConstraint(session, string)) != null) {
                        column.addCheckConstraint(session, expression);
                    }
                    arrayList2.add(column);
                }
                columnArray = new Column[arrayList2.size()];
                arrayList2.toArray(columnArray);
                this.createException = null;
                this.viewQuery = query;
            }
            catch (DbException dbException) {
                dbException.addSQL(this.getCreateSQL());
                this.createException = dbException;
                if (this.isRecursiveQueryExceptionDetected(this.createException)) {
                    this.isRecursiveQueryDetected = true;
                }
                this.tables = New.arrayList();
                columnArray = new Column[]{};
                if (!this.recursive || this.columnTemplates == null) break block13;
                columnArray = new Column[this.columnTemplates.length];
                for (int i = 0; i < this.columnTemplates.length; ++i) {
                    columnArray[i] = this.columnTemplates[i].getClone();
                }
                this.index.setRecursive(true);
                this.createException = null;
            }
        }
        this.setColumns(columnArray);
        if (this.getId() != 0) {
            this.addViewToTables();
        }
    }

    @Override
    public boolean isView() {
        return true;
    }

    public boolean isInvalid() {
        return this.createException != null;
    }

    @Override
    public PlanItem getBestPlanItem(Session session, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, HashSet<Column> hashSet) {
        CacheKey cacheKey = new CacheKey(nArray, this);
        Map<Object, ViewIndex> map = session.getViewIndexCache(this.topQuery != null);
        ViewIndex viewIndex = map.get(cacheKey);
        if (viewIndex == null || viewIndex.isExpired()) {
            viewIndex = new ViewIndex(this, this.index, session, nArray, tableFilterArray, n, sortOrder);
            map.put(cacheKey, viewIndex);
        }
        PlanItem planItem = new PlanItem();
        planItem.cost = viewIndex.getCost(session, nArray, tableFilterArray, n, sortOrder, hashSet);
        planItem.setIndex(viewIndex);
        return planItem;
    }

    @Override
    public boolean isQueryComparable() {
        if (!super.isQueryComparable()) {
            return false;
        }
        for (Table table : this.tables) {
            if (table.isQueryComparable()) continue;
            return false;
        }
        return this.topQuery == null || this.topQuery.isEverything(ExpressionVisitor.QUERY_COMPARABLE_VISITOR);
    }

    public Query getTopQuery() {
        return this.topQuery;
    }

    @Override
    public String getDropSQL() {
        return "DROP VIEW IF EXISTS " + this.getSQL() + " CASCADE";
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        return this.getCreateSQL(false, true, string);
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQL(false, true);
    }

    public String getCreateSQL(boolean bl, boolean bl2) {
        return this.getCreateSQL(bl, bl2, this.getSQL());
    }

    private String getCreateSQL(boolean bl, boolean bl2, String string) {
        StatementBuilder statementBuilder = new StatementBuilder("CREATE ");
        if (bl) {
            statementBuilder.append("OR REPLACE ");
        }
        if (bl2) {
            statementBuilder.append("FORCE ");
        }
        statementBuilder.append("VIEW ");
        statementBuilder.append(string);
        if (this.comment != null) {
            statementBuilder.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        if (this.columns != null && this.columns.length > 0) {
            statementBuilder.append('(');
            for (Column column : this.columns) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append(column.getSQL());
            }
            statementBuilder.append(')');
        } else if (this.columnTemplates != null) {
            statementBuilder.append('(');
            for (Column column : this.columnTemplates) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append(column.getName());
            }
            statementBuilder.append(')');
        }
        return statementBuilder.append(" AS\n").append(this.querySQL).toString();
    }

    @Override
    public void checkRename() {
    }

    @Override
    public boolean lock(Session session, boolean bl, boolean bl2) {
        return false;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void unlock(Session session) {
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    @Override
    public Index addIndex(Session session, String string, int n, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, String string2) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void removeRow(Session session, Row row) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void addRow(Session session, Row row) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void checkSupportAlter() {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public long getRowCount(Session session) {
        throw DbException.throwInternalError(this.toString());
    }

    @Override
    public boolean canGetRowCount() {
        return false;
    }

    @Override
    public boolean canDrop() {
        return true;
    }

    @Override
    public TableType getTableType() {
        return TableType.VIEW;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.removeViewFromTables();
        super.removeChildrenAndResources(session);
        this.database.removeMeta(session, this.getId());
        this.querySQL = null;
        this.index = null;
        TableView.clearIndexCaches(this.database);
        this.invalidate();
    }

    public static void clearIndexCaches(Database database) {
        for (Session session : database.getSessions(true)) {
            session.clearViewIndexCache();
        }
    }

    @Override
    public String getSQL() {
        if (this.isTemporary()) {
            return "(\n" + StringUtils.indent(this.querySQL) + ")";
        }
        return super.getSQL();
    }

    public String getQuery() {
        return this.querySQL;
    }

    @Override
    public Index getScanIndex(Session session) {
        return this.getBestPlanItem(session, null, null, -1, null, null).getIndex();
    }

    @Override
    public Index getScanIndex(Session session, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, HashSet<Column> hashSet) {
        if (this.createException != null) {
            String string = this.createException.getMessage();
            throw DbException.get(90109, this.createException, this.getSQL(), string);
        }
        PlanItem planItem = this.getBestPlanItem(session, nArray, tableFilterArray, n, sortOrder, hashSet);
        return planItem.getIndex();
    }

    @Override
    public boolean canReference() {
        return false;
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return null;
    }

    @Override
    public long getMaxDataModificationId() {
        if (this.createException != null) {
            return Long.MAX_VALUE;
        }
        if (this.viewQuery == null) {
            return Long.MAX_VALUE;
        }
        long l = this.database.getModificationDataId();
        if (l > this.lastModificationCheck && this.maxDataModificationId <= l) {
            this.maxDataModificationId = this.viewQuery.getMaxDataModificationId();
            this.lastModificationCheck = l;
        }
        return this.maxDataModificationId;
    }

    @Override
    public Index getUniqueIndex() {
        return null;
    }

    private void removeViewFromTables() {
        if (this.tables != null) {
            for (Table table : this.tables) {
                table.removeView(this);
            }
            this.tables.clear();
        }
    }

    private void addViewToTables() {
        for (Table table : this.tables) {
            table.addView(this);
        }
    }

    private void setOwner(User user) {
        this.owner = user;
    }

    public User getOwner() {
        return this.owner;
    }

    public static TableView createTempView(Session session, User user, String string, Query query, Query query2) {
        Schema schema = session.getDatabase().getSchema("PUBLIC");
        String string2 = query.getPlanSQL();
        TableView tableView = new TableView(schema, 0, string, string2, query.getParameters(), null, session, false);
        if (tableView.createException != null) {
            throw tableView.createException;
        }
        tableView.setTopQuery(query2);
        tableView.setOwner(user);
        tableView.setTemporary(true);
        return tableView;
    }

    private void setTopQuery(Query query) {
        this.topQuery = query;
    }

    @Override
    public long getRowCountApproximation() {
        return 100L;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    public int getParameterOffset(ArrayList<Parameter> arrayList) {
        int n;
        int n2 = n = this.topQuery == null ? -1 : TableView.getMaxParameterIndex(this.topQuery.getParameters());
        if (arrayList != null) {
            n = Math.max(n, TableView.getMaxParameterIndex(arrayList));
        }
        return n + 1;
    }

    private static int getMaxParameterIndex(ArrayList<Parameter> arrayList) {
        int n = -1;
        for (Parameter parameter : arrayList) {
            n = Math.max(n, parameter.getIndex());
        }
        return n;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    @Override
    public boolean isDeterministic() {
        if (this.recursive || this.viewQuery == null) {
            return false;
        }
        return this.viewQuery.isEverything(ExpressionVisitor.DETERMINISTIC_VISITOR);
    }

    public void setRecursiveResult(ResultInterface resultInterface) {
        if (this.recursiveResult != null) {
            this.recursiveResult.close();
        }
        this.recursiveResult = resultInterface;
    }

    public ResultInterface getRecursiveResult() {
        return this.recursiveResult;
    }

    public void setTableExpression(boolean bl) {
        this.tableExpression = bl;
    }

    public boolean isTableExpression() {
        return this.tableExpression;
    }

    @Override
    public void addDependencies(HashSet<DbObject> hashSet) {
        super.addDependencies(hashSet);
        if (this.tables != null) {
            for (Table table : this.tables) {
                if (TableType.VIEW == table.getTableType()) continue;
                table.addDependencies(hashSet);
            }
        }
    }

    public boolean isRecursiveQueryDetected() {
        return this.isRecursiveQueryDetected;
    }

    private boolean isRecursiveQueryExceptionDetected(DbException dbException) {
        if (dbException == null) {
            return false;
        }
        if (dbException.getErrorCode() != 42102) {
            return false;
        }
        return dbException.getMessage().contains("\"" + this.getName() + "\"");
    }

    private static final class CacheKey {
        private final int[] masks;
        private final TableView view;

        CacheKey(int[] nArray, TableView tableView) {
            this.masks = nArray;
            this.view = tableView;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + Arrays.hashCode(this.masks);
            n = 31 * n + this.view.hashCode();
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)object;
            if (this.view != cacheKey.view) {
                return false;
            }
            return Arrays.equals(this.masks, cacheKey.masks);
        }
    }
}

