/*
 * Decompiled with CFR 0.152.
 */
package org.h2.bnf;

import java.util.HashMap;
import org.h2.bnf.Bnf;
import org.h2.bnf.BnfVisitor;
import org.h2.bnf.Rule;
import org.h2.bnf.RuleHead;
import org.h2.bnf.Sentence;
import org.h2.util.StringUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class RuleElement
implements Rule {
    private final boolean keyword;
    private final String name;
    private Rule link;
    private final int type;

    public RuleElement(String name, String topic) {
        this.name = name;
        this.keyword = name.length() == 1 || name.equals(StringUtils.toUpperEnglish(name));
        topic = StringUtils.toLowerEnglish(topic);
        this.type = topic.startsWith("function") ? 2 : 1;
    }

    @Override
    public void accept(BnfVisitor visitor) {
        visitor.visitRuleElement(this.keyword, this.name, this.link);
    }

    @Override
    public void setLinks(HashMap<String, RuleHead> ruleMap) {
        if (this.link != null) {
            this.link.setLinks(ruleMap);
        }
        if (this.keyword) {
            return;
        }
        String test = Bnf.getRuleMapKey(this.name);
        int i = 0;
        while (i < test.length()) {
            String t = test.substring(i);
            RuleHead r = ruleMap.get(t);
            if (r != null) {
                this.link = r.getRule();
                return;
            }
            ++i;
        }
        throw new AssertionError((Object)("Unknown " + this.name + "/" + test));
    }

    @Override
    public boolean autoComplete(Sentence sentence) {
        sentence.stopIfRequired();
        if (this.keyword) {
            String query = sentence.getQuery();
            String q = query.trim();
            String up = sentence.getQueryUpper().trim();
            if (up.startsWith(this.name)) {
                query = query.substring(this.name.length());
                while (!"_".equals(this.name) && Bnf.startWithSpace(query)) {
                    query = query.substring(1);
                }
                sentence.setQuery(query);
                return true;
            }
            if ((q.length() == 0 || this.name.startsWith(up)) && q.length() < this.name.length()) {
                sentence.add(this.name, this.name.substring(q.length()), this.type);
            }
            return false;
        }
        return this.link.autoComplete(sentence);
    }

    public String toString() {
        return this.name;
    }
}

